/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Symbol;
import dev.latvian.mods.rhino.SymbolKey;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.Deletable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;

public class NativeJavaList
extends NativeJavaObject {
    private static final TypeInfo REDUCE_FUNC_ARG = TypeInfo.of(BinaryOperator.class);
    public final List list;
    public final TypeInfo listType;

    public NativeJavaList(Context cx, Scriptable scope, Object jo, List list, TypeInfo type) {
        super(scope, jo, type, cx);
        this.list = list;
        this.listType = type.param(0);
    }

    @Override
    public String getClassName() {
        return "JavaList";
    }

    @Override
    public boolean has(Context cx, int index, Scriptable start) {
        if (this.isWithValidIndex(index)) {
            return true;
        }
        return super.has(cx, index, start);
    }

    @Override
    public boolean has(Context cx, Symbol key, Scriptable start) {
        if (SymbolKey.IS_CONCAT_SPREADABLE.equals(key)) {
            return true;
        }
        return super.has(cx, key, start);
    }

    @Override
    public Object get(Context cx, int index, Scriptable start) {
        if (this.isWithValidIndex(index)) {
            return cx.javaToJS(this.list.get(index), start, this.listType);
        }
        return Undefined.INSTANCE;
    }

    @Override
    public Object get(Context cx, Symbol key, Scriptable start) {
        if (SymbolKey.IS_CONCAT_SPREADABLE.equals(key)) {
            return Boolean.TRUE;
        }
        return super.get(cx, key, start);
    }

    @Override
    public void put(Context cx, int index, Scriptable start, Object value) {
        if (this.isWithValidIndex(index)) {
            this.list.set(index, cx.jsToJava(value, this.listType));
            return;
        }
        super.put(cx, index, start, value);
    }

    @Override
    public Object[] getIds(Context cx) {
        List list = (List)this.javaObject;
        Object[] result = new Object[list.size()];
        int i = list.size();
        while (--i >= 0) {
            result[i] = i;
        }
        return result;
    }

    private boolean isWithValidIndex(int index) {
        return index >= 0 && index < this.list.size();
    }

    @Override
    public void delete(Context cx, int index) {
        if (this.isWithValidIndex(index)) {
            Deletable.deleteObject(this.list.remove(index));
        }
    }

    @Override
    protected void initMembers(Context cx, Scriptable scope) {
        super.initMembers(cx, scope);
        TypeInfo reduceFuncArg = REDUCE_FUNC_ARG.withParams(this.listType);
        this.addCustomProperty("length", TypeInfo.INT, this::getLength);
        this.addCustomFunction("push", TypeInfo.INT, this::push, TypeInfo.OBJECT);
        this.addCustomFunction("pop", this.listType, this::pop);
        this.addCustomFunction("shift", this.listType, this::shift);
        this.addCustomFunction("unshift", TypeInfo.INT, this::unshift, TypeInfo.OBJECT);
        this.addCustomFunction("concat", this.typeInfo, this::concat, TypeInfo.RAW_LIST);
        this.addCustomFunction("join", TypeInfo.STRING, this::join, TypeInfo.STRING);
        this.addCustomFunction("reverse", TypeInfo.NONE, this::reverse);
        this.addCustomFunction("slice", TypeInfo.NONE, this::slice, TypeInfo.OBJECT);
        this.addCustomFunction("splice", TypeInfo.NONE, this::splice, TypeInfo.OBJECT);
        this.addCustomFunction("every", TypeInfo.BOOLEAN, this::every, TypeInfo.RAW_PREDICATE);
        this.addCustomFunction("some", TypeInfo.BOOLEAN, this::some, TypeInfo.RAW_PREDICATE);
        this.addCustomFunction("filter", this.typeInfo, this::filter, TypeInfo.RAW_PREDICATE);
        this.addCustomFunction("map", TypeInfo.RAW_LIST, this::map, TypeInfo.RAW_FUNCTION);
        this.addCustomFunction("reduce", this.listType, this::reduce, reduceFuncArg);
        this.addCustomFunction("reduceRight", this.listType, this::reduceRight, reduceFuncArg);
        this.addCustomFunction("find", this.listType, this::find, TypeInfo.RAW_PREDICATE);
        this.addCustomFunction("findIndex", TypeInfo.NONE, this::findIndex, TypeInfo.RAW_PREDICATE);
        this.addCustomFunction("findLast", this.listType, this::findLast, TypeInfo.RAW_PREDICATE);
        this.addCustomFunction("findLastIndex", TypeInfo.NONE, this::findLastIndex, TypeInfo.RAW_PREDICATE);
    }

    private int getLength(Context cx) {
        return this.list.size();
    }

    private int push(Context cx, Object[] args) {
        if (args.length == 1) {
            this.list.add(cx.jsToJava(args[0], this.listType));
        } else if (args.length > 1) {
            Object[] args1 = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                args1[i] = cx.jsToJava(args[i], this.listType);
            }
            this.list.addAll(Arrays.asList(args1));
        }
        return this.list.size();
    }

    private Object pop(Context cx) {
        if (this.list.isEmpty()) {
            return Undefined.INSTANCE;
        }
        return this.list.removeLast();
    }

    private Object shift(Context cx) {
        if (this.list.isEmpty()) {
            return Undefined.INSTANCE;
        }
        return this.list.removeFirst();
    }

    private int unshift(Context cx, Object[] args) {
        for (int i = args.length - 1; i >= 0; --i) {
            this.list.addFirst(cx.jsToJava(args[i], this.listType));
        }
        return this.list.size();
    }

    private Object concat(Context cx, Object[] args) {
        ArrayList list1 = new ArrayList(this.list);
        if (args.length > 0 && args[0] instanceof List) {
            list1.addAll((List)cx.jsToJava(args[0], this.typeInfo));
        }
        return list1;
    }

    private String join(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return "";
        }
        if (this.list.size() == 1) {
            return ScriptRuntime.toString(cx, this.list.getFirst());
        }
        String j = ScriptRuntime.toString(cx, args[0]);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.list.size(); ++i) {
            if (i > 0) {
                sb.append(j);
            }
            sb.append(ScriptRuntime.toString(cx, this.list.get(i)));
        }
        return sb.toString();
    }

    private NativeJavaList reverse(Context cx) {
        if (this.list.size() > 1) {
            Collections.reverse(this.list);
        }
        return this;
    }

    private Object slice(Context cx, Object[] args) {
        throw new IllegalStateException("Not implemented yet!");
    }

    private Object splice(Context cx, Object[] args) {
        throw new IllegalStateException("Not implemented yet!");
    }

    private Object every(Context cx, Object[] args) {
        Predicate predicate = (Predicate)args[0];
        for (Object o : this.list) {
            if (predicate.test(o)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Object some(Context cx, Object[] args) {
        Predicate predicate = (Predicate)args[0];
        for (Object o : this.list) {
            if (!predicate.test(o)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Object filter(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return this;
        }
        Predicate predicate = (Predicate)args[0];
        ArrayList list1 = new ArrayList();
        for (Object o : this.list) {
            if (!predicate.test(o)) continue;
            list1.add(o);
        }
        return list1;
    }

    private Object map(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return this;
        }
        Function function = (Function)args[0];
        ArrayList list1 = new ArrayList();
        for (Object o : this.list) {
            list1.add(function.apply(o));
        }
        return list1;
    }

    private Object reduce(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return Undefined.INSTANCE;
        }
        if (this.list.size() == 1) {
            return this.list.getFirst();
        }
        BinaryOperator operator = (BinaryOperator)args[0];
        Object o = this.get(cx, 0, (Scriptable)this);
        for (int i = 1; i < this.list.size(); ++i) {
            o = operator.apply(o, this.get(cx, i, (Scriptable)this));
        }
        return o;
    }

    private Object reduceRight(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return Undefined.INSTANCE;
        }
        if (this.list.size() == 1) {
            return this.list.getFirst();
        }
        BinaryOperator operator = (BinaryOperator)args[0];
        Object o = this.get(cx, 0, (Scriptable)this);
        for (int i = this.list.size() - 1; i >= 1; --i) {
            o = operator.apply(o, this.get(cx, i, (Scriptable)this));
        }
        return o;
    }

    private Object find(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return Undefined.INSTANCE;
        }
        Predicate predicate = (Predicate)args[0];
        for (Object o : this.list) {
            if (!predicate.test(o)) continue;
            return o;
        }
        return Undefined.INSTANCE;
    }

    private Object findIndex(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return -1;
        }
        Predicate predicate = (Predicate)args[0];
        for (int i = 0; i < this.list.size(); ++i) {
            if (!predicate.test(this.list.get(i))) continue;
            return i;
        }
        return -1;
    }

    private Object findLast(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return Undefined.INSTANCE;
        }
        Predicate predicate = (Predicate)args[0];
        for (int i = this.list.size() - 1; i >= 0; --i) {
            Object o = this.list.get(i);
            if (!predicate.test(o)) continue;
            return o;
        }
        return Undefined.INSTANCE;
    }

    private Object findLastIndex(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return -1;
        }
        Predicate predicate = (Predicate)args[0];
        for (int i = this.list.size() - 1; i >= 0; --i) {
            if (!predicate.test(this.list.get(i))) continue;
            return i;
        }
        return -1;
    }
}

