/*
 * Decompiled with CFR 0.152.
 */
package net.dshbwlto.createbionics.block.custom.stalker;

import java.util.List;
import net.dshbwlto.createbionics.block.BionicsBlocks;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class StalkerEngineWaxBlock
extends Block {
    public StalkerEngineWaxBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!itemStack.is(Items.SAND)) {
            return super.useItemOn(itemStack, blockState, level, pos, player, hand, hitResult);
        }
        if (level.isClientSide) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        level.playSound((Player)null, pos, SoundEvents.SAND_BREAK, SoundSource.BLOCKS, 1.0f, 0.8f);
        level.setBlock(pos, ((Block)BionicsBlocks.STALKER_ENGINE_MOLD.get()).defaultBlockState(), 11);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return super.propagatesSkylightDown(state, level, pos);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.createbionics.anoleitem.tooltip.shift"));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.createbionics.anoleitem.tooltip.shift1"));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.createbionics.wax_cast.tooltip.1"));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.createbionics.anoleitem.tooltip.shift1"));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.createbionics.wax_cast.tooltip.iron"));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.createbionics.anoleitem.tooltip.shift"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

