/*
 * Decompiled with CFR 0.152.
 */
package net.dshbwlto.createbionics.entity.client.oxhauler;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.dshbwlto.createbionics.entity.client.ModModelLayers;
import net.dshbwlto.createbionics.entity.client.oxhauler.OxhaulerColorLayer;
import net.dshbwlto.createbionics.entity.client.oxhauler.OxhaulerModel;
import net.dshbwlto.createbionics.entity.client.oxhauler.OxhaulerVariant;
import net.dshbwlto.createbionics.entity.custom.OxhaulerEntity;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class OxhaulerRenderer
extends MobRenderer<OxhaulerEntity, OxhaulerModel<OxhaulerEntity>> {
    private static final Map<OxhaulerVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(OxhaulerVariant.class), map -> {
        map.put(OxhaulerVariant.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/oxhauler/oxhauler.png"));
        map.put(OxhaulerVariant.COPPER, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/oxhauler/oxhauler_copper.png"));
        map.put(OxhaulerVariant.NETHERITE1, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/oxhauler/oxhauler_netherite1.png"));
        map.put(OxhaulerVariant.NETHERITE2, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/oxhauler/oxhauler_netherite2.png"));
    });

    public OxhaulerRenderer(EntityRendererProvider.Context context) {
        super(context, new OxhaulerModel(context.bakeLayer(ModModelLayers.OXHAULER)), 1.6f);
        this.addLayer(new OxhaulerColorLayer((RenderLayerParent<OxhaulerEntity, OxhaulerModel<OxhaulerEntity>>)this, context.getModelSet()));
    }

    public ResourceLocation getTextureLocation(OxhaulerEntity entity) {
        return LOCATION_BY_VARIANT.get((Object)entity.getVariant());
    }

    public void render(OxhaulerEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.5f, 0.5f, 0.5f);
        }
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

