/*
 * Decompiled with CFR 0.152.
 */
package net.dshbwlto.createbionics.entity.custom;

import java.util.function.Predicate;
import net.dshbwlto.createbionics.entity.BionicsEntities;
import net.dshbwlto.createbionics.entity.client.replete.RepleteVariant;
import net.dshbwlto.createbionics.item.BionicsItems;
import net.dshbwlto.createbionics.sound.BionicsSounds;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class RepleteEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(RepleteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FILL = SynchedEntityData.defineId(RepleteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int fuelTime = 501;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState sitDownAnimationState = new AnimationState();
    public final AnimationState sitPoseAnimationState = new AnimationState();
    public final AnimationState sitUpAnimationState = new AnimationState();
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK = SynchedEntityData.defineId(RepleteEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    private static final EntityDataAccessor<ItemStack> DYE_STACK = SynchedEntityData.defineId(RepleteEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Boolean> LEGL = SynchedEntityData.defineId(RepleteEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LEGR = SynchedEntityData.defineId(RepleteEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LEG2L = SynchedEntityData.defineId(RepleteEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LEG2R = SynchedEntityData.defineId(RepleteEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LEG3L = SynchedEntityData.defineId(RepleteEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LEG3R = SynchedEntityData.defineId(RepleteEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public RepleteEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BionicsItems.COMMAND_WHISTLE.get()}), true));
        this.goalSelector.addGoal(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f));
        if (this.isTame()) {
            this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        }
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 5.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.SAFE_FALL_DISTANCE, 200.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 200.0);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.BARRIER);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)BionicsEntities.REPLETE.get().create((Level)level);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ITEM_BREAK;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.ANVIL_PLACE;
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            for (int i = 0; i < 1; ++i) {
                if (this.isCurrentlyGlowing()) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
        if (!this.level().isClientSide && this.isAlive() && --this.fuelTime == 0 && this.isTame()) {
            this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.setGlowingTag(true);
            if (!this.isSitting()) {
                this.toggleSitting();
            }
            this.getOwner().sendSystemMessage((Component)Component.literal((String)(this.getOwner().getName().getString() + ", \u00a7cyour Replete has run out of fuel!\u00a7r")));
        }
        if (this.fuelTime == 500 && this.isTame()) {
            this.setGlowingTag(true);
            this.getOwner().sendSystemMessage((Component)Component.literal((String)(this.getOwner().getName().getString() + ", your Replete is running low on fuel! Top it up with coal or charcoal!")));
        }
        if (this.fuelTime == 100 && this.isTame()) {
            this.setGlowingTag(true);
            this.getOwner().sendSystemMessage((Component)Component.literal((String)(this.getOwner().getName().getString() + ", your Replete is running very low on fuel! Top it up with coal or charcoal immediately!")));
        }
        super.aiStep();
    }

    public boolean fireImmune() {
        if (this.getVariant() == RepleteVariant.NETHERITE3) {
            return true;
        }
        return super.fireImmune();
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 60;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isVisuallySitting()) {
            this.sitUpAnimationState.stop();
            if (this.isVisuallySittingDown()) {
                this.sitDownAnimationState.startIfStopped(this.tickCount);
                this.sitPoseAnimationState.stop();
            } else {
                this.sitDownAnimationState.stop();
                this.sitPoseAnimationState.startIfStopped(this.tickCount);
            }
        } else {
            this.sitDownAnimationState.stop();
            this.sitPoseAnimationState.stop();
            this.sitUpAnimationState.animateWhen(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.tickCount);
        }
    }

    public boolean isInPoseTransition() {
        long i = this.getPoseTime();
        return i < (long)(this.isSitting() ? 40 : 52);
    }

    public boolean isVisuallySitting() {
        return this.getPoseTime() < 0L != this.isSitting();
    }

    private boolean isVisuallySittingDown() {
        return this.isSitting() && this.getPoseTime() < 40L && this.getPoseTime() >= 0L;
    }

    public void resetLastPoseChangeTick(long lastPoseChangeTick) {
        this.entityData.set(LAST_POSE_CHANGE_TICK, (Object)lastPoseChangeTick);
    }

    public long getPoseTime() {
        return this.level().getGameTime() - Math.abs((Long)this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    private void resetLastPoseChangeTickToFullStand(long lastPoseChangedTick) {
        this.resetLastPoseChangeTick(Math.max(0L, lastPoseChangedTick - 52L - 1L));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.tickCount % 30 == 0 && !this.isCurrentlyGlowing() && !this.isSilent()) {
            this.level().playLocalSound(this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5, BionicsSounds.ENGINE.get(), this.getSoundSource(), 0.01f + this.random.nextFloat(), 1.2f, false);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        Item itemForNetherite = Items.NETHERITE_INGOT;
        Item itemForRedstone = Items.REDSTONE;
        Item itemForGold = Items.GOLD_INGOT;
        Item itemForDiamond = Items.DIAMOND;
        Item itemForFuel = Items.CHARCOAL;
        int lastFill = (Integer)this.entityData.get(FILL);
        if (item == BionicsItems.SILENT_PISTON.get() && this.isOwnedBy((LivingEntity)player) && !this.isSilent()) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.setSilent(true);
            return InteractionResult.SUCCESS;
        }
        if (item == Items.COAL || item == Items.CHARCOAL) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.fuelTime = 100000;
            this.setGlowingTag(false);
            return InteractionResult.SUCCESS;
        }
        if (item == Items.WATER_BUCKET && (Integer)this.entityData.get(FILL) < 160) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
                player.addItem(new ItemStack((ItemLike)Items.BUCKET));
            }
            this.entityData.set(FILL, (Object)(lastFill + 1));
            return InteractionResult.SUCCESS;
        }
        if (item == Items.BUCKET && (Integer)this.entityData.get(FILL) > 0) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
                player.addItem(new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            this.entityData.set(FILL, (Object)(lastFill - 1));
            return InteractionResult.SUCCESS;
        }
        if (!this.isTame() && this.getMainHandItem().isEmpty()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            if (!EventHooks.onAnimalTame((Animal)this, (Player)player)) {
                super.tame(player);
                this.navigation.recomputePath();
                this.setTarget(null);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
                this.fuelTime = 510;
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && this.isOwnedBy((LivingEntity)player) && itemstack.isEmpty()) {
            this.toggleSitting();
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public boolean isSitting() {
        return (Long)this.entityData.get(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public void toggleSitting() {
        if (this.isSitting()) {
            this.standUp();
        } else {
            this.sitDown();
        }
    }

    public void sitDown() {
        if (!this.isSitting()) {
            this.setPose(Pose.SITTING);
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.resetLastPoseChangeTick(-this.level().getGameTime());
        }
        this.setOrderedToSit(true);
        this.setInSittingPose(true);
    }

    public void standUp() {
        if (this.isSitting()) {
            this.setPose(Pose.STANDING);
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.resetLastPoseChangeTick(this.level().getGameTime());
        }
        this.setOrderedToSit(false);
        this.setInSittingPose(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LAST_POSE_CHANGE_TICK, (Object)0L);
        builder.define(VARIANT, (Object)0);
        builder.define(FILL, (Object)0);
        builder.define(DYE_STACK, (Object)ItemStack.EMPTY);
        builder.define(LEGL, (Object)false);
        builder.define(LEGR, (Object)false);
        builder.define(LEG2L, (Object)false);
        builder.define(LEG2R, (Object)false);
        builder.define(LEG3L, (Object)false);
        builder.define(LEG3R, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putLong("LastPoseTick", ((Long)this.entityData.get(LAST_POSE_CHANGE_TICK)).longValue());
        compound.putInt("Variant", this.getTypeVariant());
        compound.putInt("Fill", this.getFillLevel());
        compound.putInt("RefuelTime", this.fuelTime);
        compound.putBoolean("LegL", this.leg_l());
        compound.putBoolean("LegR", this.leg_r());
        compound.putBoolean("Leg2L", this.leg2_l());
        compound.putBoolean("Leg2R", this.leg2_r());
        compound.putBoolean("Hat5", this.leg3_l());
        compound.putBoolean("Leg3L", this.leg3_r());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        long i = compound.getLong("LastPoseTick");
        if (i < 0L) {
            this.setPose(Pose.SITTING);
        }
        this.resetLastPoseChangeTick(i);
        this.entityData.set(VARIANT, (Object)compound.getInt("Variant"));
        this.entityData.set(FILL, (Object)compound.getInt("Variant"));
        if (compound.contains("RefuelTime")) {
            this.fuelTime = compound.getInt("RefuelTime");
        }
        this.entityData.set(LEGL, (Object)compound.getBoolean("LegL"));
        this.entityData.set(LEGR, (Object)compound.getBoolean("LegR"));
        this.entityData.set(LEG2L, (Object)compound.getBoolean("Leg2L"));
        this.entityData.set(LEG2R, (Object)compound.getBoolean("Leg2R"));
        this.entityData.set(LEG3L, (Object)compound.getBoolean("Leg3L"));
        this.entityData.set(LEG3R, (Object)compound.getBoolean("Leg3R"));
    }

    private void setTypeVariant(int typeVariant) {
        this.entityData.set(VARIANT, (Object)typeVariant);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    private int getFillLevel() {
        return (Integer)this.entityData.get(FILL);
    }

    public RepleteVariant getVariant() {
        return RepleteVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(RepleteVariant variant) {
        this.entityData.set(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public boolean leg_l() {
        return (Boolean)this.entityData.get(LEGL);
    }

    public boolean leg_r() {
        return (Boolean)this.entityData.get(LEGR);
    }

    public boolean leg2_l() {
        return (Boolean)this.entityData.get(LEG2L);
    }

    public boolean leg2_r() {
        return (Boolean)this.entityData.get(LEG2R);
    }

    public boolean leg3_l() {
        return (Boolean)this.entityData.get(LEG3L);
    }

    public boolean leg3_r() {
        return (Boolean)this.entityData.get(LEG3R);
    }

    public boolean fluid_1() {
        return (Integer)this.entityData.get(FILL) <= 6 && (Integer)this.entityData.get(FILL) > 0;
    }

    public boolean fluid_2() {
        return (Integer)this.entityData.get(FILL) <= 12 && (Integer)this.entityData.get(FILL) > 6;
    }

    public boolean fluid_3() {
        return (Integer)this.entityData.get(FILL) <= 18 && (Integer)this.entityData.get(FILL) > 12;
    }

    public boolean fluid_4() {
        return (Integer)this.entityData.get(FILL) <= 24 && (Integer)this.entityData.get(FILL) > 18;
    }

    public boolean fluid_5() {
        return (Integer)this.entityData.get(FILL) <= 30 && (Integer)this.entityData.get(FILL) > 24;
    }

    public boolean fluid_6() {
        return (Integer)this.entityData.get(FILL) <= 36 && (Integer)this.entityData.get(FILL) > 30;
    }

    public boolean fluid_7() {
        return (Integer)this.entityData.get(FILL) <= 42 && (Integer)this.entityData.get(FILL) > 36;
    }

    public boolean fluid_8() {
        return (Integer)this.entityData.get(FILL) <= 48 && (Integer)this.entityData.get(FILL) > 42;
    }

    public boolean fluid_9() {
        return (Integer)this.entityData.get(FILL) <= 54 && (Integer)this.entityData.get(FILL) > 48;
    }

    public boolean fluid_10() {
        return (Integer)this.entityData.get(FILL) <= 60 && (Integer)this.entityData.get(FILL) > 54;
    }

    public boolean fluid_11() {
        return (Integer)this.entityData.get(FILL) <= 66 && (Integer)this.entityData.get(FILL) > 60;
    }

    public boolean fluid_12() {
        return (Integer)this.entityData.get(FILL) <= 72 && (Integer)this.entityData.get(FILL) > 66;
    }

    public boolean fluid_13() {
        return (Integer)this.entityData.get(FILL) <= 78 && (Integer)this.entityData.get(FILL) > 72;
    }

    public boolean fluid_14() {
        return (Integer)this.entityData.get(FILL) <= 84 && (Integer)this.entityData.get(FILL) > 78;
    }

    public boolean fluid_15() {
        return (Integer)this.entityData.get(FILL) <= 90 && (Integer)this.entityData.get(FILL) > 84;
    }

    public boolean fluid_16() {
        return (Integer)this.entityData.get(FILL) <= 96 && (Integer)this.entityData.get(FILL) > 90;
    }

    public boolean fluid_17() {
        return (Integer)this.entityData.get(FILL) <= 102 && (Integer)this.entityData.get(FILL) > 96;
    }

    public boolean fluid_18() {
        return (Integer)this.entityData.get(FILL) <= 108 && (Integer)this.entityData.get(FILL) > 102;
    }

    public boolean fluid_19() {
        return (Integer)this.entityData.get(FILL) <= 114 && (Integer)this.entityData.get(FILL) > 108;
    }

    public boolean fluid_20() {
        return (Integer)this.entityData.get(FILL) <= 120 && (Integer)this.entityData.get(FILL) > 114;
    }

    public boolean fluid_21() {
        return (Integer)this.entityData.get(FILL) <= 126 && (Integer)this.entityData.get(FILL) > 120;
    }

    public boolean fluid_22() {
        return (Integer)this.entityData.get(FILL) <= 132 && (Integer)this.entityData.get(FILL) > 126;
    }

    public boolean fluid_23() {
        return (Integer)this.entityData.get(FILL) <= 138 && (Integer)this.entityData.get(FILL) > 132;
    }

    public boolean fluid_24() {
        return (Integer)this.entityData.get(FILL) > 138;
    }
}

