/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Locale;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum EntityMatch implements StringRepresentable
{
    PLAYERS,
    PLAYERS_AND_ENTITIES,
    ENTITIES;

    public static final Codec<EntityMatch> CODEC;
    public static final StreamCodec<FriendlyByteBuf, EntityMatch> STREAM_CODEC;
    private static final Map<String, EntityMatch> NAME_VALUES;
    private static final EntityMatch[] VALUES;

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public EntityMatch next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static EntityMatch fromName(String name) {
        return NAME_VALUES.getOrDefault(name, PLAYERS_AND_ENTITIES);
    }

    static {
        CODEC = StringRepresentable.fromEnum(EntityMatch::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(EntityMatch.class);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (EntityMatch value : EntityMatch.values()) {
            builder.put((Object)value.getSerializedName(), (Object)value);
        }
        NAME_VALUES = builder.build();
        VALUES = EntityMatch.values();
    }
}

