/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.filter;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum Direction implements StringRepresentable
{
    BOTH("both"),
    INPUT("input"),
    OUTPUT("output");

    public static final Codec<Direction> CODEC;
    public static final StreamCodec<FriendlyByteBuf, Direction> STREAM_CODEC;
    private final String name;
    private static final Map<String, Direction> NAME_VALUES;
    private static final Direction[] VALUES;

    private Direction(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public Direction next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static Direction fromName(String name) {
        return NAME_VALUES.getOrDefault(name, BOTH);
    }

    static {
        CODEC = StringRepresentable.fromEnum(Direction::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Direction.class);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Direction value : Direction.values()) {
            builder.put((Object)value.getSerializedName(), (Object)value);
        }
        NAME_VALUES = builder.build();
        VALUES = Direction.values();
    }
}

