/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.latvian.mods.kubejs.client.icon.KubeIconRenderer;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.TextWrapper;
import dev.latvian.mods.kubejs.util.NotificationToastData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;

public class NotificationToast
implements Toast {
    private final NotificationToastData notification;
    private final long duration;
    private final KubeIconRenderer icon;
    private final List<FormattedCharSequence> text;
    private int width;
    private int height;
    private long lastChanged;
    private boolean changed;

    public NotificationToast(Minecraft mc, NotificationToastData notification) {
        this.notification = notification;
        this.duration = notification.duration().toMillis();
        this.icon = notification.icon().map(KubeIconRenderer::from).orElse(null);
        this.text = new ArrayList<FormattedCharSequence>(2);
        this.width = 0;
        this.height = 0;
        if (!TextWrapper.isEmpty(notification.text())) {
            this.text.addAll(mc.font.split((FormattedText)notification.text(), 240));
        }
        for (FormattedCharSequence l : this.text) {
            this.width = Math.max(this.width, mc.font.width(l));
        }
        this.width += 12;
        if (this.icon != null) {
            this.width += 24;
        }
        this.height = Math.max(this.text.size() * 10 + 12, 28);
        if (this.text.isEmpty() && this.icon != null) {
            this.width = 28;
            this.height = 28;
        }
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    private void drawRectangle(Matrix4f m, int x0, int y0, int x1, int y1, int r, int g, int b) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buf.addVertex(m, (float)x0, (float)y1, 0.0f).setColor(r, g, b, 255);
        buf.addVertex(m, (float)x1, (float)y1, 0.0f).setColor(r, g, b, 255);
        buf.addVertex(m, (float)x1, (float)y0, 0.0f).setColor(r, g, b, 255);
        buf.addVertex(m, (float)x0, (float)y0, 0.0f).setColor(r, g, b, 255);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
    }

    public Toast.Visibility render(GuiGraphics graphics, ToastComponent toastComponent, long l) {
        if (this.changed) {
            this.lastChanged = l;
            this.changed = false;
        }
        Minecraft mc = toastComponent.getMinecraft();
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(-2.0, 2.0, 0.0);
        Matrix4f m = poseStack.last().pose();
        int w = this.width();
        int h = this.height();
        int oc = this.notification.outlineColor().orElse(NotificationToastData.DEFAULT_OUTLINE_COLOR).kjs$getRGB();
        int ocr = FastColor.ARGB32.red((int)oc);
        int ocg = FastColor.ARGB32.green((int)oc);
        int ocb = FastColor.ARGB32.blue((int)oc);
        int bc = this.notification.borderColor().orElse(NotificationToastData.DEFAULT_BORDER_COLOR).kjs$getRGB();
        int bcr = FastColor.ARGB32.red((int)bc);
        int bcg = FastColor.ARGB32.green((int)bc);
        int bcb = FastColor.ARGB32.blue((int)bc);
        int bgc = this.notification.backgroundColor().orElse(NotificationToastData.DEFAULT_BACKGROUND_COLOR).kjs$getRGB();
        int bgcr = FastColor.ARGB32.red((int)bgc);
        int bgcg = FastColor.ARGB32.green((int)bgc);
        int bgcb = FastColor.ARGB32.blue((int)bgc);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.drawRectangle(m, 2, 0, w - 2, h, ocr, ocg, ocb);
        this.drawRectangle(m, 0, 2, w, h - 2, ocr, ocg, ocb);
        this.drawRectangle(m, 1, 1, w - 1, h - 1, ocr, ocg, ocb);
        this.drawRectangle(m, 2, 1, w - 2, h - 1, bcr, bcg, bcb);
        this.drawRectangle(m, 1, 2, w - 1, h - 2, bcr, bcg, bcb);
        this.drawRectangle(m, 2, 2, w - 2, h - 2, bgcr, bgcg, bgcb);
        if (this.icon != null) {
            this.icon.draw(mc, graphics, 14, h / 2, this.notification.iconSize());
        }
        int th = this.icon == null ? 6 : 26;
        int tv = (h - this.text.size() * 10) / 2 + 1;
        for (int i = 0; i < this.text.size(); ++i) {
            graphics.drawString(mc.font, this.text.get(i), th, tv + i * 10, 0xFFFFFF, this.notification.textShadow());
        }
        poseStack.popPose();
        return l - this.lastChanged < this.duration ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }
}

