/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import dev.latvian.mods.kubejs.block.predicate.BlockEntityPredicate;
import dev.latvian.mods.kubejs.block.predicate.BlockIDPredicate;
import dev.latvian.mods.kubejs.block.predicate.BlockPredicate;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.BuildingMaterialProperties;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.DirectionWrapper;
import dev.latvian.mods.kubejs.registry.RegistryKubeEvent;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.KubeResourceLocation;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

@Info(value="Various block related helper functions")
public class BlockWrapper {
    public static final TypeInfo TYPE_INFO = TypeInfo.of(Block.class);
    public static final TypeInfo STATE_TYPE_INFO = TypeInfo.of(BlockState.class);
    private static Collection<BlockState> ALL_STATE_CACHE = null;
    private static Map<String, Direction> facingMap;

    public static BlockIDPredicate id(ResourceLocation id) {
        return new BlockIDPredicate(id);
    }

    public static BlockIDPredicate id(ResourceLocation id, Map<String, Object> properties) {
        BlockIDPredicate b = BlockWrapper.id(id);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            b = b.with(entry.getKey(), entry.getValue().toString());
        }
        return b;
    }

    public static BlockEntityPredicate entity(ResourceLocation id) {
        return new BlockEntityPredicate(id);
    }

    public static BlockPredicate custom(BlockPredicate predicate) {
        return predicate;
    }

    @Info(value="Get a map of direction name to Direction. Functionally identical to Direction.ALL")
    public static Map<String, Direction> getFacing() {
        if (facingMap == null) {
            facingMap = new HashMap<String, Direction>(6);
            for (Direction facing : DirectionWrapper.VALUES) {
                facingMap.put(facing.getSerializedName(), facing);
            }
        }
        return facingMap;
    }

    @Info(value="Gets a Block from a block id")
    public static Block getBlock(ResourceLocation id) {
        return (Block)BuiltInRegistries.BLOCK.get(id);
    }

    @Info(value="Gets a blocks id from the Block")
    @Nullable
    public static ResourceLocation getId(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    @Info(value="Gets a list of the classname of all registered blocks")
    public static List<String> getTypeList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Block block : BuiltInRegistries.BLOCK) {
            list.add(block.kjs$getId());
        }
        return list;
    }

    @Info(value="Gets a list of all blocks with tags")
    public static List<ResourceLocation> getTaggedIds(ResourceLocation tag) {
        return (List)Util.make(new LinkedList(), list -> {
            for (Holder holder : BuiltInRegistries.BLOCK.getTagOrEmpty(Tags.block(tag))) {
                ResourceKey l = holder.getKey();
                if (l == null) continue;
                list.add(l.location());
            }
        });
    }

    public static Collection<BlockState> getAllBlockStates() {
        if (ALL_STATE_CACHE != null) {
            return ALL_STATE_CACHE;
        }
        HashSet states = new HashSet();
        for (Block block : BuiltInRegistries.BLOCK) {
            states.addAll(block.getStateDefinition().getPossibleStates());
        }
        ALL_STATE_CACHE = Collections.unmodifiableCollection(states);
        return ALL_STATE_CACHE;
    }

    public static BlockState parseBlockState(RegistryAccessContainer registries, String string) {
        if (string.isEmpty()) {
            return Blocks.AIR.defaultBlockState();
        }
        try {
            return BlockStateParser.parseForBlock((HolderLookup)registries.access().lookupOrThrow(Registries.BLOCK), (String)string, (boolean)false).blockState();
        }
        catch (Exception ex) {
            return Blocks.AIR.defaultBlockState();
        }
    }

    public static BlockSetType wrapSetType(Context cx, Object from, TypeInfo target) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockSetType.class, CharSequence.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                BlockSetType type;
                yield type = (BlockSetType)object;
            }
            case 1 -> {
                CharSequence charSequence = (CharSequence)object;
                String str = charSequence.toString();
                for (BlockSetType type : BlockSetType.values().toList()) {
                    if (!type.name().equalsIgnoreCase(str)) continue;
                    yield type;
                }
                yield null;
            }
            default -> (BlockSetType)((RecordTypeInfo)target).wrap(cx, from, target);
        };
    }

    @Info(value="Parses a block state from the input string. May throw for invalid inputs!")
    public static BlockState wrapBlockState(RegistryAccessContainer registries, Object o) {
        Object object = o;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockState.class, Block.class}, (Object)object, n)) {
            case -1 -> Blocks.AIR.defaultBlockState();
            case 0 -> {
                BlockState bs;
                yield bs = (BlockState)object;
            }
            case 1 -> {
                Block block = (Block)object;
                yield block.defaultBlockState();
            }
            default -> BlockWrapper.parseBlockState(registries, o.toString());
        };
    }

    public static BlockState withProperties(BlockState state, Map<?, ?> properties) {
        HashMap<String, Property> pmap = new HashMap<String, Property>();
        for (Property property : state.getProperties()) {
            pmap.put(property.getName(), property);
        }
        for (Map.Entry entry : properties.entrySet()) {
            Property property = (Property)pmap.get(String.valueOf(entry.getKey()));
            if (property == null) continue;
            state = (BlockState)state.setValue(property, (Comparable)Cast.to(property.getValue(String.valueOf(entry.getValue())).orElseThrow()));
        }
        return state;
    }

    public static void registerBuildingMaterial(Context cx, RegistryKubeEvent<Block> event, KubeResourceLocation id, BuildingMaterialProperties properties) {
        properties.register(cx, event, id);
    }

    public static void registerBuildingMaterial(Context cx, RegistryKubeEvent<Block> event, KubeResourceLocation id) {
        BlockWrapper.registerBuildingMaterial(cx, event, id, (BuildingMaterialProperties)cx.jsToJava(Map.of(), BuildingMaterialProperties.TYPE_INFO));
    }
}

