/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.BuilderFactory;
import dev.latvian.mods.kubejs.registry.BuilderType;
import dev.latvian.mods.kubejs.registry.BuilderTypeRegistry;
import dev.latvian.mods.kubejs.registry.ServerRegistryRegistry;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public record BuilderTypeRegistryHandler(Map<ResourceKey<?>, Info<?>> map) implements BuilderTypeRegistry,
ServerRegistryRegistry
{
    public static final Lazy<Map<ResourceKey<?>, Info<?>>> INFO = Lazy.identityMap(map -> {
        BuilderTypeRegistryHandler handler = new BuilderTypeRegistryHandler((Map<ResourceKey<?>, Info<?>>)map);
        KubeJSPlugins.forEachPlugin(handler, KubeJSPlugin::registerBuilderTypes);
        KubeJSPlugins.forEachPlugin(handler, KubeJSPlugin::registerServerRegistries);
    });

    public static <T> Info<T> info(ResourceKey<Registry<T>> key) {
        return INFO.get().get(key);
    }

    @Override
    public <T> void of(ResourceKey<Registry<T>> registry, Consumer<BuilderTypeRegistry.Callback<T>> callback) {
        callback.accept(new RegConsumer(this.map.computeIfAbsent(registry, k -> new Info())));
    }

    @Override
    public <T> void register(ResourceKey<Registry<T>> registry, Codec<T> directCodec, TypeInfo typeInfo) {
        Info info = this.map.computeIfAbsent(registry, k -> new Info());
        info.directCodec = directCodec;
        info.typeInfo = typeInfo == null ? TypeInfo.NONE : typeInfo;
    }

    public static class Info<T> {
        private BuilderType<T> defaultType;
        private Map<ResourceLocation, BuilderType<T>> types;
        private Map<String, BuilderType<T>> fallbackLookup;
        private Codec<T> directCodec;
        private TypeInfo typeInfo;

        @Nullable
        public BuilderType<T> defaultType() {
            return this.defaultType;
        }

        public List<BuilderType<T>> types() {
            return this.types == null ? List.of() : List.copyOf(this.types.values());
        }

        @Nullable
        public BuilderType<T> namedType(ResourceLocation name) {
            BuilderType<T> t;
            BuilderType<T> builderType = t = this.types == null ? null : this.types.get(name);
            return t != null ? t : (this.fallbackLookup == null ? null : this.fallbackLookup.get(name.getPath()));
        }

        @Nullable
        public Codec<T> directCodec() {
            return this.directCodec;
        }

        @Nullable
        public TypeInfo typeInfo() {
            return this.typeInfo;
        }
    }

    private record RegConsumer<T>(Info<T> info) implements BuilderTypeRegistry.Callback<T>
    {
        private static final ResourceLocation DEFAULT = KubeJS.id("default");

        @Override
        public void addDefault(Class<? extends BuilderBase<? extends T>> builderType, BuilderFactory factory) {
            if (this.info.defaultType != null) {
                ConsoleJS.STARTUP.warn("Previous default type '" + this.info.defaultType.builderClass().getName() + "' for registry '" + String.valueOf(this.info) + "' replaced with '" + builderType.getName() + "'!");
            }
            this.info.defaultType = new BuilderType(DEFAULT, builderType, factory);
        }

        @Override
        public void add(ResourceLocation type, Class<? extends BuilderBase<? extends T>> builderType, BuilderFactory factory) {
            BuilderType prev;
            if (this.info.types == null) {
                this.info.types = new LinkedHashMap();
            }
            if (this.info.fallbackLookup == null) {
                this.info.fallbackLookup = new HashMap();
            }
            if ((prev = this.info.types.get(type)) != null) {
                ConsoleJS.STARTUP.warn("Previous '" + String.valueOf(type) + "' type '" + prev.builderClass().getName() + "' for registry '" + String.valueOf(this.info) + "' replaced with '" + builderType.getName() + "'!");
            }
            BuilderType builderTypeDef = new BuilderType(type, builderType, factory);
            this.info.types.put(type, builderTypeDef);
            this.info.fallbackLookup.put(type.getPath(), builderTypeDef);
        }
    }
}

