/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.web.local.client;

import com.madgag.gif.fmsware.AnimatedGifEncoder;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.serialization.DynamicOps;
import dev.latvian.apps.tinyserver.content.ResponseContent;
import dev.latvian.apps.tinyserver.http.response.HTTPPayload;
import dev.latvian.apps.tinyserver.http.response.HTTPResponse;
import dev.latvian.apps.tinyserver.http.response.HTTPStatus;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.BlockWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.UUIDWrapper;
import dev.latvian.mods.kubejs.util.CachedComponentObject;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.web.KJSHTTPRequest;
import dev.latvian.mods.kubejs.web.local.client.FakeClientWorld;
import dev.latvian.mods.kubejs.web.local.client.MovedVertexConsumer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Vector3f;

public class ImageGenerator {
    public static final ItemTransform ROTATED_BLOCK_TRANSFORM = new ItemTransform(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f));
    public static final ResourceLocation WILDCARD_TEXTURE = KubeJS.id("textures/misc/wildcard.png");
    public static final Int2ObjectMap<TextureTarget> FB_CACHE = new Int2ObjectArrayMap();

    public static TextureTarget getCanvas(int size) {
        TextureTarget target = (TextureTarget)FB_CACHE.get(size);
        if (target == null) {
            target = new TextureTarget(size, size, true, Minecraft.ON_OSX);
            target.setClearColor(0.54f, 0.54f, 0.54f, 0.0f);
            FB_CACHE.put(size, (Object)target);
        }
        return target;
    }

    private static CachedImage renderCanvas(KJSHTTPRequest req, int canvasSize, int imageSize, String dir, @Nullable ByteBuf cacheBuf, boolean wildcard, Consumer<RenderImage> render) {
        Path cachePath;
        int size;
        int n = size = imageSize > 0 ? imageSize : req.variable("size").asInt();
        if (size < 1 || size > 1024) {
            return new CachedImage(HTTPStatus.BAD_REQUEST.text("Invalid size, must be [1, 1024]"), null);
        }
        if (req.query().containsKey("uncached")) {
            cacheBuf = null;
        }
        if (cacheBuf != null) {
            cacheBuf.writeBoolean(wildcard);
        }
        String cacheUUIDStr = cacheBuf == null ? null : UUIDWrapper.toString(UUID.nameUUIDFromBytes(cacheBuf.array()));
        Path path = cachePath = cacheUUIDStr == null ? null : KubeJSPaths.dir(KubeJSPaths.LOCAL.resolve("cache/web/img/" + dir + "/" + cacheUUIDStr.substring(0, 2))).resolve(cacheUUIDStr + "_" + size + ".png");
        if (cachePath != null && Files.exists(cachePath, new LinkOption[0])) {
            String pathStr = KubeJSPaths.GAMEDIR.relativize(cachePath).toString().replace('\\', '/');
            return new CachedImage(HTTPResponse.ok().content(cachePath).header("X-KubeJS-Cache-Key", (Object)cacheUUIDStr).header("X-KubeJS-Cache-Path", (Object)pathStr), pathStr);
        }
        byte[] bytes = req.supplyInMainThread(() -> {
            TextureTarget target = ImageGenerator.getCanvas(size);
            Minecraft mc = Minecraft.getInstance();
            MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
            target.clear(Minecraft.ON_OSX);
            target.bindWrite(true);
            RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)canvasSize, (float)canvasSize, 0.0f, -1000.0f, 1000.0f), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
            Matrix4fStack view = RenderSystem.getModelViewStack();
            view.pushMatrix();
            view.translation(0.0f, 0.0f, 0.0f);
            RenderSystem.applyModelViewMatrix();
            GuiGraphics graphics = new GuiGraphics(mc, bufferSource);
            render.accept(new RenderImage(mc, graphics, size));
            if (wildcard) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                graphics.blit(WILDCARD_TEXTURE, 0, 0, 300, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            graphics.flush();
            target.bindRead();
            RenderSystem.bindTexture((int)target.getColorTextureId());
            try {
                byte[] byArray;
                NativeImage image = new NativeImage(size, size, false);
                try {
                    image.downloadTexture(0, false);
                    image.flipY();
                    for (int y = 0; y < size; ++y) {
                        for (int x = 0; x < size; ++x) {
                            int color = image.getPixelRGBA(x, y);
                            int a = color >> 24 & 0xFF;
                            if (a == 0) {
                                image.setPixelRGBA(x, y, 0);
                                continue;
                            }
                            if (a >= 255) continue;
                            image.setPixelRGBA(x, y, color & 0xFFFFFF | 0xFF000000);
                        }
                    }
                    byArray = image.asByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            image.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        byte[] byArray2 = null;
                        return byArray2;
                    }
                }
                image.close();
                return byArray;
            }
            finally {
                target.unbindRead();
                target.unbindWrite();
                view.popMatrix();
                RenderSystem.applyModelViewMatrix();
            }
        });
        if (cachePath != null) {
            try {
                Files.write(cachePath, bytes, new OpenOption[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String pathStr = KubeJSPaths.GAMEDIR.relativize(cachePath).toString().replace('\\', '/');
            return new CachedImage(HTTPResponse.ok().content(bytes, "image/png").header("X-KubeJS-Cache-Key", (Object)cacheUUIDStr).header("X-KubeJS-Cache-Path", (Object)pathStr), pathStr);
        }
        return new CachedImage(HTTPResponse.ok().content(bytes, "image/png"), null);
    }

    private static CachedImage renderAnimated(KJSHTTPRequest req, String dir, @Nullable ByteBuf cacheBuf, List<CachedImage> images) throws Exception {
        Path cachePath;
        int size = req.variable("size").asInt();
        if (size < 1 || size > 1024) {
            return new CachedImage(HTTPStatus.BAD_REQUEST.text("Invalid size, must be [1, 1024]"), null);
        }
        if (req.query().containsKey("uncached")) {
            cacheBuf = null;
        }
        String cacheUUIDStr = cacheBuf == null ? null : UUIDWrapper.toString(UUID.nameUUIDFromBytes(cacheBuf.array()));
        Path path = cachePath = cacheUUIDStr == null ? null : KubeJSPaths.dir(KubeJSPaths.LOCAL.resolve("cache/web/img/" + dir + "/" + cacheUUIDStr.substring(0, 2))).resolve(cacheUUIDStr + "_" + size + ".gif");
        if (cachePath != null && Files.exists(cachePath, new LinkOption[0])) {
            String pathStr = KubeJSPaths.GAMEDIR.relativize(cachePath).toString().replace('\\', '/');
            return new CachedImage(HTTPResponse.ok().content(cachePath).header("X-KubeJS-Cache-Key", (Object)cacheUUIDStr).header("X-KubeJS-Cache-Path", (Object)pathStr), pathStr);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        AnimatedGifEncoder encoder = new AnimatedGifEncoder();
        encoder.start((OutputStream)outputStream);
        encoder.setSize(size, size);
        encoder.setBackground(Color.BLUE);
        encoder.setTransparent(Color.BLUE, false);
        encoder.setRepeat(0);
        encoder.setDelay(1000);
        HashSet bodyKeys = new HashSet();
        req.runInMainThread(() -> {
            for (CachedImage image : images) {
                try {
                    ContentGrabber content = new ContentGrabber(KubeJS.DISPLAY_NAME, req.startTime());
                    image.response().build((HTTPPayload)content);
                    if (content.body == null || !bodyKeys.add(new BodyKey(content.body))) continue;
                    encoder.addFrame(ImageIO.read(new ByteArrayInputStream(content.body)));
                }
                catch (Exception exception) {}
            }
        });
        encoder.finish();
        byte[] bytes = outputStream.toByteArray();
        if (cachePath != null) {
            try {
                Files.write(cachePath, bytes, new OpenOption[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String pathStr = KubeJSPaths.GAMEDIR.relativize(cachePath).toString().replace('\\', '/');
            return new CachedImage(HTTPResponse.ok().content(bytes, "image/gif").header("X-KubeJS-Cache-Key", (Object)cacheUUIDStr).header("X-KubeJS-Cache-Path", (Object)pathStr), pathStr);
        }
        return new CachedImage(HTTPResponse.ok().content(bytes, "image/gif"), null);
    }

    public static HTTPResponse renderAllItems(KJSHTTPRequest req) throws Exception {
        int size = req.variable("size").asInt();
        if (size < 1 || size > 1024) {
            return HTTPStatus.BAD_REQUEST.text("Invalid size, must be [1, 1024]");
        }
        return HTTPResponse.noContent();
    }

    public static HTTPResponse item(KJSHTTPRequest req) throws Exception {
        ItemStack stack = ((Item)BuiltInRegistries.ITEM.get(req.id())).getDefaultInstance();
        stack.applyComponents(req.components((DynamicOps<Tag>)req.registries().nbt()));
        return ImageGenerator.renderItem(req, 0, stack, req.query().containsKey("wildcard")).response();
    }

    public static CachedImage renderItem(KJSHTTPRequest req, int imageSize, ItemStack stack, boolean wildcard) {
        if (stack.isEmpty()) {
            return new CachedImage((HTTPResponse)HTTPStatus.NOT_FOUND, null);
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        CachedComponentObject.writeCacheKey(buf, stack.getItem(), DataComponentWrapper.visualPatch(stack.getComponentsPatch()));
        return ImageGenerator.renderCanvas(req, 16, imageSize, "item", (ByteBuf)buf, wildcard, render -> {
            render.graphics.renderFakeItem(stack, 0, 0, 0);
            render.graphics.renderItemDecorations(render.mc.font, stack, 0, 0);
        });
    }

    public static HTTPResponse block(KJSHTTPRequest req) throws Exception {
        BlockState state = BlockWrapper.withProperties(((Block)BuiltInRegistries.BLOCK.get(req.id())).defaultBlockState(), req.query());
        return ImageGenerator.renderBlock(req, state, req.query().containsKey("wildcard")).response();
    }

    public static CachedImage renderBlock(KJSHTTPRequest req, BlockState state, boolean wildcard) {
        if (state.isEmpty()) {
            return new CachedImage((HTTPResponse)HTTPStatus.NOT_FOUND, null);
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeUtf(state.kjs$getId());
        buf.writeVarInt(state.getBlock().getStateDefinition().getProperties().size());
        for (Property p : state.getProperties()) {
            buf.writeUtf(p.getName());
            if (p instanceof BooleanProperty) {
                BooleanProperty p1 = (BooleanProperty)p;
                buf.writeBoolean(((Boolean)state.getValue((Property)p1)).booleanValue());
                continue;
            }
            if (p instanceof IntegerProperty) {
                IntegerProperty p1 = (IntegerProperty)p;
                buf.writeVarInt(((Integer)Cast.to(state.getValue((Property)p1))).intValue());
                continue;
            }
            buf.writeUtf(p.getName((Comparable)Cast.to(state.getValue(p))));
        }
        return ImageGenerator.renderCanvas(req, 16, 0, "block", (ByteBuf)buf, wildcard, render -> {
            boolean flag;
            BakedModel model = render.mc.getBlockRenderer().getBlockModel(state);
            PoseStack pose = render.graphics.pose();
            pose.pushPose();
            pose.translate(8.0f, 8.0f, 150.0f);
            pose.scale(16.0f, -16.0f, 16.0f);
            boolean bl = flag = !model.usesBlockLight();
            if (flag) {
                Lighting.setupForFlatItems();
            }
            ROTATED_BLOCK_TRANSFORM.apply(false, pose);
            pose.translate(-0.5f, -0.5f, -0.5f);
            for (RenderType renderType : model.getRenderTypes(state, RandomSource.create((long)0L), ModelData.EMPTY)) {
                render.mc.getBlockRenderer().renderSingleBlock(state, pose, (MultiBufferSource)render.graphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
            }
            try {
                FluidState fluidState = state.getFluidState();
                if (!fluidState.is(Fluids.EMPTY)) {
                    FakeClientWorld world = new FakeClientWorld((LevelReader)render.mc.level, state, (ResourceKey<Biome>)Biomes.THE_VOID);
                    render.mc.getBlockRenderer().renderLiquid(BlockPos.ZERO, (BlockAndTintGetter)world, (VertexConsumer)new MovedVertexConsumer(render.graphics.bufferSource().getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState)), pose.last()), state, fluidState);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            render.graphics.flush();
            if (flag) {
                Lighting.setupFor3DItems();
            }
            render.graphics.pose().popPose();
        });
    }

    public static HTTPResponse fluid(KJSHTTPRequest req) throws Exception {
        FluidStack stack = new FluidStack((Fluid)BuiltInRegistries.FLUID.get(req.id()), 1000);
        stack.applyComponents(req.components((DynamicOps<Tag>)req.registries().nbt()));
        return ImageGenerator.renderFluid(req, stack, req.query().containsKey("wildcard")).response();
    }

    public static CachedImage renderFluid(KJSHTTPRequest req, FluidStack stack, boolean wildcard) {
        if (stack.isEmpty()) {
            return new CachedImage((HTTPResponse)HTTPStatus.NOT_FOUND, null);
        }
        IClientFluidTypeExtensions fluidInfo = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
        ResourceLocation still = fluidInfo.getStillTexture(stack);
        int tint = fluidInfo.getTintColor(stack);
        int a = 255;
        int r = tint >> 16 & 0xFF;
        int g = tint >> 8 & 0xFF;
        int b = tint & 0xFF;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        CachedComponentObject.writeCacheKey(buf, stack.getFluid(), DataComponentWrapper.visualPatch(stack.getComponentsPatch()));
        return ImageGenerator.renderCanvas(req, 16, 0, "fluid", (ByteBuf)buf, wildcard, render -> {
            TextureAtlasSprite s = (TextureAtlasSprite)render.mc.kjs$getBlockTextureAtlas().apply(still);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            Matrix4f m = render.graphics.pose().last().pose();
            builder.addVertex(m, 0.0f, 0.0f, 0.0f).setUv(s.getU0(), s.getV1()).setColor(r, g, b, a);
            builder.addVertex(m, 0.0f, 16.0f, 0.0f).setUv(s.getU0(), s.getV0()).setColor(r, g, b, a);
            builder.addVertex(m, 16.0f, 16.0f, 0.0f).setUv(s.getU1(), s.getV0()).setColor(r, g, b, a);
            builder.addVertex(m, 16.0f, 0.0f, 0.0f).setUv(s.getU1(), s.getV1()).setColor(r, g, b, a);
            BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        });
    }

    public static HTTPResponse itemTag(KJSHTTPRequest req) throws Exception {
        Optional tag = BuiltInRegistries.ITEM.getTag(ItemTags.create((ResourceLocation)req.id()));
        if (tag.isEmpty()) {
            return HTTPStatus.NOT_FOUND;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        ArrayList<CachedImage> list = new ArrayList<CachedImage>();
        for (Holder holder : (HolderSet.Named)tag.get()) {
            buf.writeUtf(((Item)holder.value()).kjs$getId());
            list.add(ImageGenerator.renderItem(req, 0, ((Item)holder.value()).getDefaultInstance(), true));
        }
        return ImageGenerator.renderAnimated(req, "item_tag", (ByteBuf)buf, list).response();
    }

    public static HTTPResponse blockTag(KJSHTTPRequest req) throws Exception {
        Optional tag = BuiltInRegistries.BLOCK.getTag(BlockTags.create((ResourceLocation)req.id()));
        if (tag.isEmpty()) {
            return HTTPStatus.NOT_FOUND;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        ArrayList<CachedImage> list = new ArrayList<CachedImage>();
        for (Holder holder : (HolderSet.Named)tag.get()) {
            buf.writeUtf(((Block)holder.value()).kjs$getId());
            Item item = ((Block)holder.value()).asItem();
            if (item != Items.AIR) {
                list.add(ImageGenerator.renderItem(req, 0, item.getDefaultInstance(), true));
                continue;
            }
            list.add(ImageGenerator.renderBlock(req, ((Block)holder.value()).defaultBlockState(), true));
        }
        return ImageGenerator.renderAnimated(req, "block_tag", (ByteBuf)buf, list).response();
    }

    public static HTTPResponse fluidTag(KJSHTTPRequest req) throws Exception {
        Optional tag = BuiltInRegistries.FLUID.getTag(FluidTags.create((ResourceLocation)req.id()));
        if (tag.isEmpty()) {
            return HTTPStatus.NOT_FOUND;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        ArrayList<CachedImage> list = new ArrayList<CachedImage>();
        for (Holder holder : (HolderSet.Named)tag.get()) {
            buf.writeUtf(((Fluid)holder.value()).kjs$getId());
            list.add(ImageGenerator.renderFluid(req, new FluidStack(holder, 1000), true));
        }
        return ImageGenerator.renderAnimated(req, "fluid_tag", (ByteBuf)buf, list).response();
    }

    public record CachedImage(HTTPResponse response, @Nullable String pathStr) {
    }

    private record RenderImage(Minecraft mc, GuiGraphics graphics, int size) {
    }

    private static class ContentGrabber
    extends HTTPPayload {
        private byte[] body = null;

        public ContentGrabber(String serverName, Instant serverTime) {
            super(serverName, serverTime);
        }

        public void setBody(ResponseContent body) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                body.write((OutputStream)out);
                this.body = out.toByteArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private record BodyKey(byte[] bytes) {
        @Override
        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            byte[] bytes1;
            if (this == o) return true;
            if (!(o instanceof BodyKey)) return false;
            BodyKey bodyKey = (BodyKey)o;
            try {
                byte[] byArray;
                bytes1 = byArray = bodyKey.bytes();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (!Arrays.equals(this.bytes, bytes1)) return false;
            return true;
        }
    }
}

