/*
 * Decompiled with CFR 0.152.
 */
package net.dshbwlto.createbionics;

import com.mojang.logging.LogUtils;
import net.dshbwlto.createbionics.Config;
import net.dshbwlto.createbionics.block.BionicsBlocks;
import net.dshbwlto.createbionics.entity.BionicsEntities;
import net.dshbwlto.createbionics.entity.client.anole.AnoleRenderer;
import net.dshbwlto.createbionics.entity.client.oxhauler.OxhaulerRenderer;
import net.dshbwlto.createbionics.entity.client.replete.RepleteRenderer;
import net.dshbwlto.createbionics.fluid.BaseFluidType;
import net.dshbwlto.createbionics.fluid.BionicsFluidTypes;
import net.dshbwlto.createbionics.fluid.BionicsFluids;
import net.dshbwlto.createbionics.item.BionicsCreativeModeTabs;
import net.dshbwlto.createbionics.item.BionicsItems;
import net.dshbwlto.createbionics.screen.BionicsMenuTypes;
import net.dshbwlto.createbionics.sound.BionicsSounds;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.slf4j.Logger;

@Mod(value="createbionics")
public class CreateBionics {
    public static final String MOD_ID = "createbionics";
    public static final Logger LOGGER = LogUtils.getLogger();

    public CreateBionics(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        BionicsItems.register(modEventBus);
        BionicsBlocks.register(modEventBus);
        BionicsCreativeModeTabs.register(modEventBus);
        BionicsSounds.register(modEventBus);
        BionicsFluidTypes.register(modEventBus);
        BionicsFluids.register(modEventBus);
        BionicsEntities.register(modEventBus);
        BionicsMenuTypes.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)Blocks.DIRT));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @EventBusSubscriber(modid="createbionics", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                EntityRenderers.register(BionicsEntities.ANOLE.get(), AnoleRenderer::new);
                EntityRenderers.register(BionicsEntities.OXHAULER.get(), OxhaulerRenderer::new);
                EntityRenderers.register(BionicsEntities.REPLETE.get(), RepleteRenderer::new);
            });
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
        }

        @SubscribeEvent
        public static void onClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerFluidType(((BaseFluidType)BionicsFluidTypes.MOLTEN_ANDESITE_ALLOY_FLUID_TYPE.get()).getClientFluidTypeExtensions(), new FluidType[]{BionicsFluidTypes.MOLTEN_ANDESITE_ALLOY_FLUID_TYPE.get()});
            event.registerFluidType(((BaseFluidType)BionicsFluidTypes.MOLTEN_INDUSTRIAL_IRON_FLUID_TYPE.get()).getClientFluidTypeExtensions(), new FluidType[]{BionicsFluidTypes.MOLTEN_INDUSTRIAL_IRON_FLUID_TYPE.get()});
            event.registerFluidType(((BaseFluidType)BionicsFluidTypes.MOLTEN_BRASS_FLUID_TYPE.get()).getClientFluidTypeExtensions(), new FluidType[]{BionicsFluidTypes.MOLTEN_BRASS_FLUID_TYPE.get()});
            event.registerFluidType(((BaseFluidType)BionicsFluidTypes.MOLTEN_NETHERITE_FLUID_TYPE.get()).getClientFluidTypeExtensions(), new FluidType[]{BionicsFluidTypes.MOLTEN_NETHERITE_FLUID_TYPE.get()});
        }

        @SubscribeEvent
        public static void registerColoredItems(RegisterColorHandlersEvent.Item event) {
        }
    }
}

