/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.Optional;
import java.util.UUID;
import java.util.function.IntConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackSettingsHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;

public interface IBackpackWrapper
extends IStorageWrapper {
    public IBackpackWrapper setBackpackStack(ItemStack var1);

    public BackpackSettingsHandler getSettingsHandler();

    public ItemStack getBackpack();

    public ItemStack cloneBackpack();

    public void copyDataTo(IStorageWrapper var1);

    public void setSlotNumbers(int var1, int var2);

    public void setLoot(ResourceLocation var1, float var2);

    public void setTemplate(ResourceLocation var1);

    public void fillFromTemplate();

    default public void fillWithLootAndExtraItems(Level level, BlockPos pos) {
    }

    public void setContentsUuid(UUID var1);

    default public void removeContentsUuid() {
    }

    default public void removeContentsUUIDTag() {
    }

    default public void registerOnSlotsChangeListener(IntConsumer onSlotsChange) {
    }

    default public void unregisterOnSlotsChangeListener() {
    }

    default public void registerOnInventoryHandlerRefreshListener(Runnable onInventoryHandlerRefresh) {
    }

    default public void unregisterOnInventoryHandlerRefreshListener() {
    }

    default public Optional<IFluidHandlerItem> getItemFluidHandler() {
        return Optional.empty();
    }

    public static class Noop
    extends NoopStorageWrapper
    implements IBackpackWrapper {
        public static final Noop INSTANCE = new Noop();
        private final ItemStack backpack = new ItemStack((ItemLike)ModItems.BACKPACK.get());
        private final BackpackSettingsHandler settingsHandler = new BackpackSettingsHandler(this, new CompoundTag(), () -> {});

        @Override
        public IBackpackWrapper setBackpackStack(ItemStack backpackStack) {
            return this;
        }

        @Override
        public BackpackSettingsHandler getSettingsHandler() {
            return this.settingsHandler;
        }

        @Override
        public ItemStack getBackpack() {
            return this.backpack;
        }

        @Override
        public ItemStack cloneBackpack() {
            return this.backpack;
        }

        @Override
        public void copyDataTo(IStorageWrapper otherStorageWrapper) {
        }

        @Override
        public void setSlotNumbers(int numberOfInventorySlots, int numberOfUpgradeSlots) {
        }

        @Override
        public void setLoot(ResourceLocation lootTableName, float lootPercentage) {
        }

        @Override
        public void setTemplate(ResourceLocation templateName) {
        }

        @Override
        public void fillFromTemplate() {
        }

        @Override
        public void setContentsUuid(UUID storageUuid) {
        }
    }
}

