/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.copycat;

import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface ISimpleCopycatModel {
    default public void assemblePiece(List<BakedQuad> sourceQuads, List<BakedQuad> destQuads, int angle, boolean flipY, MutableVec3 offset, MutableAABB select, MutableCullFace cull) {
        select.rotate(angle).flipY(flipY);
        offset.rotate(angle).flipY(flipY);
        cull.rotate(angle).flipY(flipY);
        for (BakedQuad quad : sourceQuads) {
            if (cull.isCulled(quad.getDirection())) continue;
            destQuads.add(BakedQuadHelper.cloneWithCustomGeometry((BakedQuad)quad, (int[])BakedModelHelper.cropAndMove((int[])quad.getVertices(), (TextureAtlasSprite)quad.getSprite(), (AABB)select.toAABB(), (Vec3)offset.toVec3().subtract((double)(select.minX / 16.0f), (double)(select.minY / 16.0f), (double)(select.minZ / 16.0f)))));
        }
    }

    default public MutableCullFace cull(int mask) {
        return new MutableCullFace(mask);
    }

    default public MutableVec3 vec3(float x, float y, float z) {
        return new MutableVec3(x, y, z);
    }

    default public MutableAABB aabb(float sizeX, float sizeY, float sizeZ) {
        return new MutableAABB(sizeX, sizeY, sizeZ);
    }

    public static class MutableAABB {
        public float minX;
        public float minY;
        public float minZ;
        public float maxX;
        public float maxY;
        public float maxZ;

        private MutableAABB(float sizeX, float sizeY, float sizeZ) {
            this.set(0.0f, 0.0f, 0.0f, sizeX, sizeY, sizeZ);
        }

        public MutableAABB move(float dX, float dY, float dZ) {
            this.minX += dX;
            this.maxX += dX;
            this.minY += dY;
            this.maxY += dY;
            this.minZ += dZ;
            this.maxZ += dZ;
            return this;
        }

        public MutableAABB rotate(int angle) {
            if ((angle %= 360) < 0) {
                angle += 360;
            }
            return switch (angle) {
                case 90 -> this.set(16.0f - this.minZ, this.minY, this.minX, 16.0f - this.maxZ, this.maxY, this.maxX);
                case 180 -> this.set(16.0f - this.minX, this.minY, 16.0f - this.minZ, 16.0f - this.maxX, this.maxY, 16.0f - this.maxZ);
                case 270 -> this.set(this.minZ, this.minY, 16.0f - this.minX, this.maxZ, this.maxY, 16.0f - this.maxX);
                default -> this;
            };
        }

        public MutableAABB flipY(boolean flip) {
            if (!flip) {
                return this;
            }
            return this.set(this.minX, 16.0f - this.minY, this.minZ, this.maxX, 16.0f - this.maxY, this.maxZ);
        }

        public AABB toAABB() {
            return new AABB((double)(this.minX / 16.0f), (double)(this.minY / 16.0f), (double)(this.minZ / 16.0f), (double)(this.maxX / 16.0f), (double)(this.maxY / 16.0f), (double)(this.maxZ / 16.0f));
        }

        public MutableAABB set(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
            return this;
        }
    }

    public static class MutableVec3 {
        public float x;
        public float y;
        public float z;

        private MutableVec3(float x, float y, float z) {
            this.set(x, y, z);
        }

        public MutableVec3 rotate(int angle) {
            if ((angle %= 360) < 0) {
                angle += 360;
            }
            return switch (angle) {
                case 90 -> this.set(16.0f - this.z, this.y, this.x);
                case 180 -> this.set(16.0f - this.x, this.y, 16.0f - this.z);
                case 270 -> this.set(this.z, this.y, 16.0f - this.x);
                default -> this;
            };
        }

        public MutableVec3 flipY(boolean flip) {
            if (!flip) {
                return this;
            }
            return this.set(this.x, 16.0f - this.y, this.z);
        }

        public Vec3 toVec3() {
            return new Vec3((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        }

        public MutableVec3 set(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }
    }

    public static class MutableCullFace {
        public static final int UP = 2 << Direction.UP.get3DDataValue();
        public static final int DOWN = 2 << Direction.DOWN.get3DDataValue();
        public static final int NORTH = 2 << Direction.NORTH.get3DDataValue();
        public static final int EAST = 2 << Direction.EAST.get3DDataValue();
        public static final int SOUTH = 2 << Direction.SOUTH.get3DDataValue();
        public static final int WEST = 2 << Direction.WEST.get3DDataValue();
        public boolean up;
        public boolean down;
        public boolean north;
        public boolean south;
        public boolean east;
        public boolean west;

        private MutableCullFace(int mask) {
            this.set((mask & UP) > 0, (mask & DOWN) > 0, (mask & NORTH) > 0, (mask & SOUTH) > 0, (mask & EAST) > 0, (mask & WEST) > 0);
        }

        public MutableCullFace rotate(int angle) {
            if ((angle %= 360) < 0) {
                angle += 360;
            }
            return switch (angle) {
                case 90 -> this.set(this.up, this.down, this.west, this.east, this.north, this.south);
                case 180 -> this.set(this.up, this.down, this.south, this.north, this.west, this.east);
                case 270 -> this.set(this.up, this.down, this.east, this.west, this.south, this.north);
                default -> this;
            };
        }

        public MutableCullFace flipY(boolean flip) {
            if (!flip) {
                return this;
            }
            return this.set(this.down, this.up, this.north, this.south, this.east, this.west);
        }

        public boolean isCulled(Direction direction) {
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> this.down;
                case Direction.UP -> this.up;
                case Direction.NORTH -> this.north;
                case Direction.SOUTH -> this.south;
                case Direction.WEST -> this.west;
                case Direction.EAST -> this.east;
            };
        }

        public MutableCullFace set(boolean up, boolean down, boolean north, boolean south, boolean east, boolean west) {
            this.up = up;
            this.down = down;
            this.north = north;
            this.south = south;
            this.east = east;
            this.west = west;
            return this;
        }
    }
}

