/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapLike;
import dev.latvian.mods.kubejs.util.JsonSerializable;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public interface JsonUtils {
    @HideFromJS
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().serializeNulls().create();
    public static final MapLike<JsonElement> MAP_LIKE = MapLike.forMap(Map.of(), (DynamicOps)JsonOps.INSTANCE);

    public static JsonElement copy(@Nullable JsonElement element) {
        JsonElement jsonElement = element;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonNull.class, JsonArray.class, JsonObject.class}, (Object)jsonElement, n)) {
            case -1 -> JsonNull.INSTANCE;
            case 0 -> {
                JsonNull jsonNull = (JsonNull)jsonElement;
                yield JsonNull.INSTANCE;
            }
            case 1 -> {
                JsonArray jsonElements = (JsonArray)jsonElement;
                JsonArray a = new JsonArray();
                for (JsonElement e : jsonElements) {
                    a.add(JsonUtils.copy(e));
                }
                yield a;
            }
            case 2 -> {
                JsonObject jsonObject = (JsonObject)jsonElement;
                JsonObject o = new JsonObject();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    o.add((String)entry.getKey(), JsonUtils.copy((JsonElement)entry.getValue()));
                }
                yield o;
            }
            default -> element;
        };
    }

    public static JsonElement of(Context cx, @Nullable Object o) {
        Object object = o;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonElement.class, JsonSerializable.class, CharSequence.class, Boolean.class, Number.class, Character.class}, (Object)object, n)) {
            case 0 -> {
                JsonElement e = (JsonElement)object;
                yield e;
            }
            case 1 -> {
                JsonSerializable s = (JsonSerializable)object;
                yield s.toJson(cx);
            }
            case 2 -> {
                CharSequence ignore = (CharSequence)object;
                yield new JsonPrimitive(o.toString());
            }
            case 3 -> {
                Boolean b = (Boolean)object;
                yield new JsonPrimitive(b);
            }
            case 4 -> {
                Number n = (Number)object;
                yield new JsonPrimitive(n);
            }
            case 5 -> {
                Character c = (Character)object;
                yield new JsonPrimitive(c);
            }
            case -1 -> JsonNull.INSTANCE;
            default -> cx.isMapLike(o) ? JsonUtils.objectOf(cx, o) : (cx.isListLike(o) ? JsonUtils.arrayOf(cx, o) : JsonNull.INSTANCE);
        };
    }

    public static JsonPrimitive primitiveOf(Context cx, @Nullable Object o) {
        JsonPrimitive p;
        JsonElement jsonElement = JsonUtils.of(cx, o);
        return jsonElement instanceof JsonPrimitive ? (p = (JsonPrimitive)jsonElement) : null;
    }

    @Nullable
    public static JsonObject objectOf(Context cx, @Nullable Object map) {
        if (map instanceof JsonObject) {
            JsonObject json = (JsonObject)map;
            return json;
        }
        if (map instanceof CharSequence) {
            try {
                return (JsonObject)GSON.fromJson(map.toString(), JsonObject.class);
            }
            catch (Exception ex) {
                return null;
            }
        }
        Map m = (Map)cx.jsToJava(map, TypeInfo.RAW_MAP);
        if (m != null) {
            JsonObject json = new JsonObject();
            for (Map.Entry entry : m.entrySet()) {
                Double d;
                Number number;
                JsonPrimitive p;
                JsonElement e = JsonUtils.of(cx, entry.getValue());
                if (e instanceof JsonPrimitive && (p = (JsonPrimitive)e).isNumber() && (number = p.getAsNumber()) instanceof Double && (d = (Double)number) <= 9.223372036854776E18 && d >= -9.223372036854776E18 && d == (double)d.longValue()) {
                    long l = d.longValue();
                    if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                        json.add(String.valueOf(entry.getKey()), (JsonElement)new JsonPrimitive((Number)((int)l)));
                        continue;
                    }
                    json.add(String.valueOf(entry.getKey()), (JsonElement)new JsonPrimitive((Number)l));
                    continue;
                }
                json.add(String.valueOf(entry.getKey()), e);
            }
            return json;
        }
        return null;
    }

    @Nullable
    public static JsonArray arrayOf(Context cx, @Nullable Object array) {
        Object object = array;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonArray.class, CharSequence.class, Iterable.class}, (Object)object, n)) {
            case 0 -> {
                JsonArray arr;
                JsonArray var4_5;
                yield var4_5 = (arr = (JsonArray)object);
            }
            case 1 -> {
                CharSequence cs = (CharSequence)object;
                try {
                    JsonArray var4_6;
                    yield var4_6 = (JsonArray)GSON.fromJson(cs.toString(), JsonArray.class);
                }
                catch (Exception ex) {
                    Object var4_7 = null;
                    yield var4_7;
                }
            }
            case 2 -> {
                JsonArray var4_8;
                Iterable itr = (Iterable)object;
                JsonArray json = new JsonArray();
                for (Object o1 : itr) {
                    json.add(JsonUtils.of(cx, o1));
                }
                yield var4_8 = json;
            }
            default -> {
                JsonArray var4_9;
                yield var4_9 = null;
            }
        };
    }

    @Nullable
    public static Object toObject(@Nullable JsonElement json) {
        JsonElement jsonElement = json;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonNull.class, JsonObject.class, JsonArray.class}, (Object)jsonElement, n)) {
            case -1 -> null;
            case 0 -> {
                JsonNull jsonNull = (JsonNull)jsonElement;
                yield null;
            }
            case 1 -> {
                JsonObject o = (JsonObject)jsonElement;
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (Map.Entry entry : o.entrySet()) {
                    map.put((String)entry.getKey(), JsonUtils.toObject((JsonElement)entry.getValue()));
                }
                yield map;
            }
            case 2 -> {
                JsonArray a = (JsonArray)jsonElement;
                ArrayList<Object> objects = new ArrayList<Object>(a.size());
                for (JsonElement e : a) {
                    objects.add(JsonUtils.toObject(e));
                }
                yield objects;
            }
            default -> JsonUtils.toPrimitive(json);
        };
    }

    public static String toString(JsonElement json) {
        return GSON.toJson(json);
    }

    public static String toPrettyString(JsonElement json) {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)writer);
        jsonWriter.setIndent("\t");
        GSON.toJson(json, jsonWriter);
        return writer.toString();
    }

    public static JsonElement fromString(@Nullable String string) {
        if (string == null || string.isEmpty() || string.equals("null")) {
            return JsonNull.INSTANCE;
        }
        try {
            return (JsonElement)GSON.fromJson(string, JsonElement.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return JsonNull.INSTANCE;
        }
    }

    @Nullable
    public static Object toPrimitive(@Nullable JsonElement element) {
        JsonElement jsonElement = element;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonPrimitive.class}, (Object)jsonElement, n)) {
            case 0 -> {
                JsonPrimitive p = (JsonPrimitive)jsonElement;
                if (p.isBoolean()) {
                    Boolean var3_4 = p.getAsBoolean();
                    yield var3_4;
                }
                if (p.isNumber()) {
                    Number var3_5 = p.getAsNumber();
                    yield var3_5;
                }
                try {
                    Double.parseDouble(p.getAsString());
                    Number var3_6 = p.getAsNumber();
                    yield var3_6;
                }
                catch (Exception ex) {
                    String var3_7 = p.getAsString();
                    yield var3_7;
                }
            }
            default -> {
                Boolean var3_8 = null;
                yield var3_8;
            }
        };
    }
}

