/*
 * Decompiled with CFR 0.152.
 */
package com.aidant.pizzadelight.block;

import com.aidant.pizzadelight.block.custom.PizzaBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class PizzaBlockEvents {
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack heldItem = player.getItemInHand(hand);
        Block block = state.getBlock();
        if (!(block instanceof PizzaBlock)) {
            return;
        }
        PizzaBlock pizzaBlock = (PizzaBlock)block;
        if (heldItem.is(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"tools/knives")))) {
            int bites = (Integer)state.getValue((Property)PizzaBlock.BITES);
            ItemStack dropStack = new ItemStack(pizzaBlock.getSliceItem(), 2);
            PizzaBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)dropStack);
            heldItem.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            if (bites < 3) {
                level.setBlock(pos, (BlockState)state.setValue((Property)PizzaBlock.BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
            } else {
                level.removeBlock(pos, false);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }
}

