/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.p3pp3rf1y.sophisticatedcore.settings.MainSetting;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class SettingsManager {
    private static final Map<String, MainSetting<?>> settings = new HashMap();
    public static final MainSetting<Boolean> SHIFT_CLICK_INTO_OPEN_TAB_FIRST = new MainSetting<Boolean>("shiftClickOpenTab", NBTHelper::getBoolean, CompoundTag::putBoolean, false);
    public static final MainSetting<Boolean> KEEP_TAB_OPEN = new MainSetting<Boolean>("keepTabOpen", NBTHelper::getBoolean, CompoundTag::putBoolean, true);
    public static final MainSetting<Boolean> KEEP_SEARCH_PHRASE = new MainSetting<Boolean>("keepSearchPhrase", NBTHelper::getBoolean, CompoundTag::putBoolean, true);
    public static final MainSetting<String> SEARCH_PHRASE = new MainSetting<String>("searchPhrase", NBTHelper::getString, CompoundTag::putString, "");

    private SettingsManager() {
    }

    public static void addSetting(MainSetting<?> setting) {
        settings.put(setting.getName(), setting);
    }

    public static Optional<MainSetting<?>> getSetting(String settingName) {
        return Optional.ofNullable(settings.get(settingName));
    }

    public static <T> T getPlayerSettingOrDefault(Player player, String playerSettingsTagName, MainSetting<T> setting) {
        return SettingsManager.getPlayerSetting(player, playerSettingsTagName, setting).orElse(setting.getDefaultValue());
    }

    public static <T> Optional<T> getPlayerSetting(Player player, String playerSettingsTagName, MainSetting<T> setting) {
        return setting.getValue(SettingsManager.getPlayerSettingsTag(player, playerSettingsTagName));
    }

    public static CompoundTag getPlayerSettingsTag(Player player, String playerSettingsTagName) {
        return player.getPersistentData().getCompound(playerSettingsTagName);
    }

    public static void setPlayerSettingsTag(Player player, String playerSettingsTagName, CompoundTag settingsNbt) {
        player.getPersistentData().put(playerSettingsTagName, (Tag)settingsNbt);
    }

    public static <T> void setPlayerSetting(Player player, String playerSettingsTagName, MainSetting<T> setting, T value) {
        if (!player.getPersistentData().contains(playerSettingsTagName)) {
            player.getPersistentData().put(playerSettingsTagName, (Tag)new CompoundTag());
        }
        if (value != setting.getDefaultValue()) {
            setting.setValue(SettingsManager.getPlayerSettingsTag(player, playerSettingsTagName), value);
        } else {
            setting.removeFrom(SettingsManager.getPlayerSettingsTag(player, playerSettingsTagName));
        }
    }

    public static <T> void setSetting(Player player, String playerSettingsTagName, MainSettingsCategory<?> category, MainSetting<T> setting, T value) {
        T playerSettingValue = SettingsManager.getPlayerSetting(player, playerSettingsTagName, setting).orElse(setting.getDefaultValue());
        if (playerSettingValue != value) {
            category.setSettingValue(setting, value);
        } else {
            category.removeSetting(setting);
        }
    }

    public static <T> T getSettingValue(Player player, String playerSettingsTagName, MainSettingsCategory<?> category, MainSetting<T> setting) {
        return category.getSettingValue(setting).orElse(SettingsManager.getPlayerSetting(player, playerSettingsTagName, setting).orElse(setting.getDefaultValue()));
    }

    static {
        settings.put(SHIFT_CLICK_INTO_OPEN_TAB_FIRST.getName(), SHIFT_CLICK_INTO_OPEN_TAB_FIRST);
        settings.put(KEEP_TAB_OPEN.getName(), KEEP_TAB_OPEN);
        settings.put(KEEP_SEARCH_PHRASE.getName(), KEEP_SEARCH_PHRASE);
        settings.put(SEARCH_PHRASE.getName(), SEARCH_PHRASE);
    }
}

