/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.color.KubeColor;
import dev.latvian.mods.kubejs.color.SimpleColor;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.ColorWrapper;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.type.TypeInfo;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ItemTintFunction {
    public static final TypeInfo TYPE_INFO = TypeInfo.of(ItemTintFunction.class);
    public static final ItemTintFunction BLOCK = (stack, index) -> {
        BlockItem block;
        BlockState s;
        BlockBuilder internal;
        Item patt0$temp = stack.getItem();
        if (patt0$temp instanceof BlockItem && (internal = (s = (block = (BlockItem)patt0$temp).getBlock().defaultBlockState()).getBlock().kjs$getBlockBuilder()) != null && internal.tint != null) {
            return internal.tint.getColor(s, null, null, index);
        }
        return null;
    };
    public static final ItemTintFunction POTION = (stack, index) -> {
        PotionContents potion = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potion != null) {
            return new SimpleColor(potion.getColor());
        }
        return null;
    };
    public static final ItemTintFunction MAP = (stack, index) -> {
        MapItemColor map = (MapItemColor)stack.get(DataComponents.MAP_COLOR);
        if (map != null) {
            return new SimpleColor(map.rgb());
        }
        return null;
    };
    public static final ItemTintFunction DISPLAY_COLOR_NBT = (stack, index) -> {
        DyedItemColor color = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        if (color != null) {
            return new SimpleColor(color.rgb());
        }
        return null;
    };

    public KubeColor getColor(ItemStack var1, int var2);

    @Nullable
    public static ItemTintFunction wrap(Context cx, Object o) {
        ItemTintFunction itemTintFunction;
        Object object = o;
        int n = 0;
        block21: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Undefined.class, Scriptable.class, ItemTintFunction.class, List.class, CharSequence.class, BaseFunction.class}, (Object)object, n)) {
                case -1: {
                    itemTintFunction = null;
                    break block21;
                }
                case 0: {
                    Undefined undefined = (Undefined)object;
                    itemTintFunction = null;
                    break block21;
                }
                case 1: {
                    Scriptable s = (Scriptable)object;
                    if (!Undefined.isUndefined((Object)s)) {
                        n = 2;
                        continue block21;
                    }
                    itemTintFunction = null;
                    break block21;
                }
                case 2: {
                    ItemTintFunction f = (ItemTintFunction)object;
                    itemTintFunction = f;
                    break block21;
                }
                case 3: {
                    List list = (List)object;
                    Mapped map = new Mapped();
                    for (int i = 0; i < list.size(); ++i) {
                        ItemTintFunction f = ItemTintFunction.wrap(cx, list.get(i));
                        if (f == null) continue;
                        map.map.put(i, (Object)f);
                    }
                    itemTintFunction = map;
                    break block21;
                }
                case 4: {
                    CharSequence cs = (CharSequence)object;
                    switch (cs.toString()) {
                        case "block": {
                            itemTintFunction = BLOCK;
                            break block21;
                        }
                        case "potion": {
                            itemTintFunction = POTION;
                            break block21;
                        }
                        case "map": {
                            itemTintFunction = MAP;
                            break block21;
                        }
                        case "display_color_nbt": {
                            itemTintFunction = DISPLAY_COLOR_NBT;
                            break block21;
                        }
                    }
                    itemTintFunction = new Fixed(ColorWrapper.wrap(o));
                    break block21;
                }
                case 5: {
                    BaseFunction function = (BaseFunction)object;
                    itemTintFunction = (ItemTintFunction)cx.createInterfaceAdapter(TYPE_INFO, (ScriptableObject)function);
                    break block21;
                }
                default: {
                    itemTintFunction = new Fixed(ColorWrapper.wrap(o));
                    break block21;
                }
            }
            break;
        }
        return itemTintFunction;
    }

    public static class Mapped
    implements ItemTintFunction {
        public final Int2ObjectMap<ItemTintFunction> map = new Int2ObjectArrayMap(1);

        @Override
        public KubeColor getColor(ItemStack stack, int index) {
            ItemTintFunction f = (ItemTintFunction)this.map.get(index);
            return f == null ? null : f.getColor(stack, index);
        }
    }

    public record Fixed(KubeColor color) implements ItemTintFunction
    {
        @Override
        public KubeColor getColor(ItemStack stack, int index) {
            return this.color;
        }
    }
}

