/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.crossconnector;

import com.hlysine.create_connected.CCShapes;
import com.hlysine.create_connected.content.IConnectionForwardingBlock;
import com.hlysine.create_connected.content.KineticHelper;
import com.simibubi.create.content.decoration.encasing.EncasableBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CrossConnectorBlock
extends Block
implements IWrenchable,
IConnectionForwardingBlock,
IRotate,
EncasableBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;

    public CrossConnectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.Y));
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case X: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public static Direction.Axis getPreferredAxis(BlockPlaceContext context) {
        Direction.Axis prefferedAxis = null;
        for (Direction side : Iterate.directions) {
            BlockState blockState = context.getLevel().getBlockState(context.getClickedPos().relative(side));
            if (!(blockState.getBlock() instanceof IRotate) || !((IRotate)blockState.getBlock()).hasShaftTowards((LevelReader)context.getLevel(), context.getClickedPos().relative(side), blockState, side.getOpposite())) continue;
            if (prefferedAxis != null && prefferedAxis != side.getAxis()) {
                prefferedAxis = null;
                break;
            }
            prefferedAxis = side.getAxis();
        }
        return prefferedAxis;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Direction.Axis preferredAxis = CrossConnectorBlock.getPreferredAxis(context);
        if (!(preferredAxis == null || context.getPlayer() != null && context.getPlayer().isShiftKeyDown())) {
            Direction.Axis lookingAxis = context.getNearestLookingDirection().getAxis();
            if (lookingAxis == preferredAxis) {
                return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)(preferredAxis.isVertical() ? Direction.Axis.X : Direction.Axis.Y));
            }
            return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)lookingAxis);
        }
        return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)(preferredAxis != null && context.getPlayer().isShiftKeyDown() ? context.getClickedFace().getAxis() : context.getNearestLookingDirection().getAxis()));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return this.tryEncase(state, level, pos, stack, player, hand, hitResult);
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return CCShapes.CROSS_CONNECTOR.get((Direction.Axis)state.getValue(AXIS));
    }

    public void updateConnections(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
            for (Direction direction : Iterate.directions) {
                Block block;
                if (direction.getAxis() == axis) continue;
                BlockPos sourcePos = pos;
                BlockPos neighborPos = pos.relative(direction);
                while (sourcePos != neighborPos && (block = level.getBlockState(neighborPos).getBlock()) instanceof IConnectionForwardingBlock) {
                    IConnectionForwardingBlock forwardingBlock = (IConnectionForwardingBlock)block;
                    BlockPos tempSource = sourcePos;
                    sourcePos = neighborPos;
                    neighborPos = forwardingBlock.forwardConnection(level, tempSource, tempSource.equals((Object)pos) ? state : level.getBlockState(tempSource), neighborPos);
                }
                BlockEntity neighbourTE = level.getBlockEntity(neighborPos);
                if (!(neighbourTE instanceof KineticBlockEntity)) continue;
                KineticBlockEntity kineticTE = (KineticBlockEntity)neighbourTE;
                KineticHelper.updateKineticBlock(kineticTE);
            }
        }
    }

    protected void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        this.updateConnections(level, pos, state);
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        this.updateConnections(level, pos, state);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Override
    public BlockPos forwardConnection(Level level, BlockPos sourcePos, BlockState sourceState, BlockPos neighbourPos) {
        BlockState state = level.getBlockState(neighbourPos);
        if (state.getBlock() != this) {
            return neighbourPos;
        }
        BlockPos offset = neighbourPos.subtract((Vec3i)sourcePos);
        Block block = sourceState.getBlock();
        if (!(block instanceof IRotate)) {
            return neighbourPos;
        }
        IRotate rotatingBlock = (IRotate)block;
        Direction offsetDirection = Direction.fromDelta((int)offset.getX(), (int)offset.getY(), (int)offset.getZ());
        if (offsetDirection == null) {
            return neighbourPos;
        }
        if (!rotatingBlock.hasShaftTowards((LevelReader)level, sourcePos, sourceState, offsetDirection)) {
            return neighbourPos;
        }
        if (offsetDirection.getAxis() == state.getValue(AXIS)) {
            return neighbourPos;
        }
        return neighbourPos.offset((Vec3i)offset);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() != state.getValue(AXIS);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue(AXIS);
    }
}

