/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import dev.latvian.mods.rhino.type.TypeInfoBase;
import dev.latvian.mods.rhino.type.TypeStringContext;
import java.util.Set;

public abstract class ClassTypeInfo
extends TypeInfoBase {
    private final Class<?> type;
    private Set<Class<?>> typeSet;

    ClassTypeInfo(Class<?> type) {
        this.type = type;
    }

    @Override
    public Class<?> asClass() {
        return this.type;
    }

    @Override
    public boolean shouldConvert() {
        return this.type != Object.class;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (o == this) return true;
        if (!(o instanceof ClassTypeInfo)) return false;
        ClassTypeInfo t = (ClassTypeInfo)o;
        if (this.type != t.type) return false;
        return true;
    }

    public String toString() {
        return this.type.getName();
    }

    @Override
    public void append(TypeStringContext ctx, StringBuilder sb) {
        ctx.appendClassName(sb, this);
    }

    @Override
    public boolean isVoid() {
        return this.type == Void.class || this.type == Void.TYPE;
    }

    @Override
    public boolean isBoolean() {
        return this.type == Boolean.class || this.type == Boolean.TYPE;
    }

    @Override
    public boolean isByte() {
        return this.type == Byte.class || this.type == Byte.TYPE;
    }

    @Override
    public boolean isShort() {
        return this.type == Short.class || this.type == Short.TYPE;
    }

    @Override
    public boolean isInt() {
        return this.type == Integer.class || this.type == Integer.TYPE;
    }

    @Override
    public boolean isLong() {
        return this.type == Long.class || this.type == Long.TYPE;
    }

    @Override
    public boolean isFloat() {
        return this.type == Float.class || this.type == Float.TYPE;
    }

    @Override
    public boolean isDouble() {
        return this.type == Double.class || this.type == Double.TYPE;
    }

    @Override
    public boolean isCharacter() {
        return this.type == Character.class || this.type == Character.TYPE;
    }

    @Override
    public Set<Class<?>> getContainedComponentClasses() {
        if (this.typeSet == null) {
            this.typeSet = Set.of(this.type);
        }
        return this.typeSet;
    }
}

