/*
 * Decompiled with CFR 0.152.
 */
package net.dshbwlto.createbionics.block.custom.stalker;

import net.dshbwlto.createbionics.Util.BionicsTags;
import net.dshbwlto.createbionics.block.BionicsBlocks;
import net.dshbwlto.createbionics.item.BionicsItems;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class StalkerEngineMoldBlock
extends Block {
    public static final BooleanProperty STALKER_ENGINE_FILLED = BooleanProperty.create((String)"stalker_engine_filled");

    public StalkerEngineMoldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)STALKER_ENGINE_FILLED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return super.propagatesSkylightDown(state, level, pos);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!itemStack.is(BionicsTags.Items.MOLD_ITEMS)) {
            return super.useItemOn(itemStack, blockState, level, pos, player, hand, hitResult);
        }
        if (level.isClientSide) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (itemStack.is((Item)BionicsItems.MOLTEN_ANDESITE_ALLOY_CRUCIBLE.get()) && !((Boolean)blockState.getValue((Property)STALKER_ENGINE_FILLED)).booleanValue()) {
            level.playSound((Player)null, pos, SoundEvents.BUCKET_FILL_LAVA, SoundSource.BLOCKS, 1.0f, 0.8f);
            boolean currentState = (Boolean)blockState.getValue((Property)STALKER_ENGINE_FILLED);
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            level.setBlock(pos, (BlockState)blockState.setValue((Property)STALKER_ENGINE_FILLED, (Comparable)Boolean.valueOf(!currentState)), 11);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (itemStack.is(Items.BRUSH) && ((Boolean)blockState.getValue((Property)STALKER_ENGINE_FILLED)).booleanValue()) {
            level.playSound((Player)null, pos, SoundEvents.SOUL_SAND_BREAK, SoundSource.BLOCKS, 1.0f, 0.8f);
            level.setBlock(pos, ((Block)BionicsBlocks.STALKER_ENGINE.get()).defaultBlockState(), 11);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!itemStack.is((Item)BionicsItems.MOLTEN_ANDESITE_ALLOY_CRUCIBLE.get()) && !((Boolean)blockState.getValue((Property)STALKER_ENGINE_FILLED)).booleanValue()) {
            player.sendSystemMessage((Component)Component.literal((String)"This part requires molten industrial iron"));
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STALKER_ENGINE_FILLED});
    }
}

