/*
 * Decompiled with CFR 0.152.
 */
package com.aidant.pizzadelight.block;

import com.aidant.pizzadelight.block.custom.PizzaBlock;
import com.aidant.pizzadelight.item.ModItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"pizzadelight");
    public static final DeferredBlock<Block> CHEESE_BLOCK = ModBlocks.registerBlock("cheese_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BANJO).strength(1.5f).sound(SoundType.WOOD).pushReaction(PushReaction.NORMAL)));
    public static final DeferredBlock<Block> CHEESE_BRICKS = ModBlocks.registerBlock("cheese_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CHEESE_BLOCK.get()))));
    public static final DeferredBlock<Block> POLISHED_CHEESE = ModBlocks.registerBlock("polished_cheese", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CHEESE_BLOCK.get()))));
    public static final DeferredBlock<Block> PIZZA = ModBlocks.registerBlock("pizza", () -> new PizzaBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE).mapColor(MapColor.COLOR_ORANGE).noOcclusion().noLootTable(), () -> ModItems.PIZZA_SLICE.get()));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

