/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.veinminerClient.network;

import de.miraculixx.veinminer.config.network.BlockHighlighting;
import de.miraculixx.veinminer.config.network.JoinInformation;
import de.miraculixx.veinminer.config.network.KeyPress;
import de.miraculixx.veinminer.config.network.RequestBlockVein;
import de.miraculixx.veinminer.config.network.ServerConfiguration;
import de.miraculixx.veinminer.config.pattern.Pattern;
import de.miraculixx.veinminer.networking.FabricNetworking;
import de.miraculixx.veinminerClient.VeinminerClient;
import de.miraculixx.veinminerClient.constants.PacketsKt;
import de.miraculixx.veinminerClient.render.BlockHighlightingRenderer;
import de.miraculixx.veinminerClient.render.HUDRenderer;
import de.miraculixx.veinminerClient.utils.NMSConversionKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.impl.networking.RegistrationPayload;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.silkmc.silk.network.packet.ClientPacketContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u001d\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0003J\u000f\u0010\u001e\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR$\u0010!\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00198\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b!\u0010\u001fR\"\u0010$\u001a\u00020#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R$\u0010*\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00198\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b*\u0010\"\u001a\u0004\b+\u0010\u001fR$\u0010-\u001a\u00020,2\u0006\u0010 \u001a\u00020,8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R$\u00101\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00198\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b1\u0010\"\u001a\u0004\b2\u0010\u001fR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00103R\u0014\u0010\f\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u00103\u00a8\u00064"}, d2={"Lde/miraculixx/veinminerClient/network/NetworkManager;", "", "<init>", "()V", "Lde/miraculixx/veinminer/config/network/ServerConfiguration;", "packet", "Lnet/minecraft/class_310;", "client", "", "onConfiguration", "(Lde/miraculixx/veinminer/config/network/ServerConfiguration;Lnet/minecraft/class_310;)V", "Lde/miraculixx/veinminer/config/network/BlockHighlighting;", "onHighlight", "(Lde/miraculixx/veinminer/config/network/BlockHighlighting;)V", "onDisconnect", "Lnet/minecraft/class_2338;", "position", "Lnet/minecraft/class_2350;", "direction", "sendBlockRequest", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_2350;)V", "", "version", "sendJoin", "(Ljava/lang/String;)V", "", "pressed", "sendKeyPress", "(Z)V", "notConnected", "shouldSendInternal", "()Z", "value", "isVeinminerActive", "Z", "Lde/miraculixx/veinminer/config/pattern/Pattern;", "selectedPattern", "Lde/miraculixx/veinminer/config/pattern/Pattern;", "getSelectedPattern", "()Lde/miraculixx/veinminer/config/pattern/Pattern;", "setSelectedPattern", "(Lde/miraculixx/veinminer/config/pattern/Pattern;)V", "mustSneak", "getMustSneak", "", "cooldown", "I", "getCooldown", "()I", "translucentBlockHighlight", "getTranslucentBlockHighlight", "Lkotlin/Unit;", "veinminer-client"})
public final class NetworkManager {
    @NotNull
    public static final NetworkManager INSTANCE = new NetworkManager();
    private static boolean isVeinminerActive;
    @NotNull
    private static Pattern selectedPattern;
    private static boolean mustSneak;
    private static int cooldown;
    private static boolean translucentBlockHighlight;
    @NotNull
    private static final Unit onConfiguration;
    @NotNull
    private static final Unit onHighlight;

    private NetworkManager() {
    }

    public final boolean isVeinminerActive() {
        return isVeinminerActive;
    }

    @NotNull
    public final Pattern getSelectedPattern() {
        return selectedPattern;
    }

    public final void setSelectedPattern(@NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"<set-?>");
        selectedPattern = pattern;
    }

    public final boolean getMustSneak() {
        return mustSneak;
    }

    public final int getCooldown() {
        return cooldown;
    }

    public final boolean getTranslucentBlockHighlight() {
        return translucentBlockHighlight;
    }

    public final void onConfiguration(@NotNull ServerConfiguration packet, @NotNull class_310 client) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        VeinminerClient.Companion.getLOGGER().info("Server configuration: " + packet);
        if (packet.getOutdated()) {
            client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43470((String)"Veinminer Outdated"), (class_2561)class_2561.method_43470((String)"Please update Veinminer")));
        }
        isVeinminerActive = true;
        mustSneak = packet.getMustSneak();
        cooldown = packet.getCooldown();
        translucentBlockHighlight = packet.getTranslucentBlockHighlight();
    }

    public final void onHighlight(@NotNull BlockHighlighting packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        VeinminerClient.Companion.getLOGGER().info("Received block highlight: " + packet);
        if (!packet.getAllowed()) {
            HUDRenderer.INSTANCE.updateTarget("forbidden");
            BlockHighlightingRenderer.INSTANCE.setShape(CollectionsKt.emptyList());
            return;
        }
        HUDRenderer.INSTANCE.updateTarget(packet.getIcon());
        BlockHighlightingRenderer.INSTANCE.setShape(packet.getBlocks());
    }

    public final void onDisconnect() {
        isVeinminerActive = false;
    }

    public final void sendBlockRequest(@NotNull class_2338 position, @NotNull class_2350 direction) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        VeinminerClient.Companion.getLOGGER().info("Sending veinmine request: (" + position + ", " + direction + ")");
        class_310 instance = class_310.method_1551();
        if (instance.method_1562() == null) {
            this.notConnected();
            return;
        }
        RequestBlockVein packet = new RequestBlockVein(NMSConversionKt.toVeinminer(position), NMSConversionKt.toVeinminer(direction), selectedPattern);
        if (this.shouldSendInternal()) {
            class_746 class_7462 = instance.field_1724;
            FabricNetworking.INSTANCE.onMine(null, packet, class_7462 != null ? class_7462.method_5667() : null);
        } else {
            PacketsKt.getPACKET_MINE().send((Object)packet);
        }
    }

    public final void sendJoin(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        VeinminerClient.Companion.getLOGGER().info("Sending join: (" + version + ")");
        class_310 instance = class_310.method_1551();
        class_634 class_6342 = instance.method_1562();
        if (class_6342 == null) {
            this.notConnected();
            return;
        }
        class_634 con = class_6342;
        Object[] objectArray = new class_2960[]{PacketsKt.getPACKET_CONFIGURATION().getId(), PacketsKt.getPACKET_HIGHLIGHT().getId()};
        con.method_52787((class_2596)new class_2817((class_8710)new RegistrationPayload(RegistrationPayload.REGISTER, CollectionsKt.listOf((Object[])objectArray))));
        if (this.shouldSendInternal()) {
            class_746 class_7462 = instance.field_1724;
            FabricNetworking.INSTANCE.onJoin(null, new JoinInformation(version), class_7462 != null ? class_7462.method_5667() : null);
        } else {
            PacketsKt.getPACKET_JOIN().send((Object)new JoinInformation(version));
        }
    }

    public final void sendKeyPress(boolean pressed) {
        VeinminerClient.Companion.getLOGGER().info("Sending key press: " + pressed);
        class_310 instance = class_310.method_1551();
        if (instance.method_1562() == null) {
            this.notConnected();
            return;
        }
        if (this.shouldSendInternal()) {
            class_746 class_7462 = instance.field_1724;
            FabricNetworking.INSTANCE.onPress(class_7462 != null ? class_7462.method_5667() : null, new KeyPress(pressed));
        } else {
            PacketsKt.getPACKET_KEY_PRESS().send((Object)new KeyPress(pressed));
        }
    }

    private final void notConnected() {
        VeinminerClient.Companion.getLOGGER().warn("Can not send packet without server connection!");
    }

    private final boolean shouldSendInternal() {
        return VeinminerClient.Companion.isSinglePlayer() && VeinminerClient.Companion.getVeinminerAvailable();
    }

    static {
        selectedPattern = Pattern.DEFAULT;
        translucentBlockHighlight = true;
        PacketsKt.getPACKET_CONFIGURATION().receiveOnClient((Function3)new Function3<ServerConfiguration, ClientPacketContext, Continuation<? super Unit>, Object>(null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ServerConfiguration packet = (ServerConfiguration)this.L$0;
                        ClientPacketContext context = (ClientPacketContext)this.L$1;
                        NetworkManager.INSTANCE.onConfiguration(packet, context.getClient());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ServerConfiguration p1, ClientPacketContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        });
        onConfiguration = Unit.INSTANCE;
        PacketsKt.getPACKET_HIGHLIGHT().receiveOnClient((Function3)new Function3<BlockHighlighting, ClientPacketContext, Continuation<? super Unit>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        BlockHighlighting packet = (BlockHighlighting)this.L$0;
                        NetworkManager.INSTANCE.onHighlight(packet);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(BlockHighlighting p1, ClientPacketContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        });
        onHighlight = Unit.INSTANCE;
    }
}

