/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.wizardsoflua.WizardsOfLuaMod;

public class WolDirectories {
    private final Path fabricConfigDir = FabricLoader.getInstance().getConfigDir();
    private final Path wolConfigDir;
    private final Path luaSrcDir = this.wolConfigDir = this.createDirectory(this.fabricConfigDir, "wizards-of-lua");
    private Path luaApiDir;
    private Path examplesDir;

    public Path getFabricConfigDir() {
        return this.fabricConfigDir;
    }

    public Path getWolConfigDir() {
        return this.wolConfigDir;
    }

    public Path getLuaSrcDir() {
        return this.luaSrcDir;
    }

    public Path getLuaApiDir() {
        if (this.luaApiDir == null) {
            this.luaApiDir = this.createDirectory(this.wolConfigDir, "api");
        }
        return this.luaApiDir;
    }

    public Path getExamplesDir() {
        if (this.examplesDir == null) {
            this.examplesDir = this.createDirectory(this.wolConfigDir, "examples");
        }
        return this.examplesDir;
    }

    public String getLuaSearchPath(FileSystem fileSystem) {
        return this.luaSrcDir.toString() + fileSystem.getSeparator() + "?.lua;";
    }

    private Path createDirectory(Path parent, String dir) {
        Path result = parent.resolve(dir).toAbsolutePath().normalize();
        this.createDirectory(result);
        return result;
    }

    private void createDirectory(Path path) {
        WizardsOfLuaMod.LOGGER.info("Creating " + path.toString());
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

