/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.wizardsoflua.command.CommandRegisterer;
import net.wizardsoflua.spell.Spell;
import net.wizardsoflua.spell.SpellRegistry;

public class WolSpellBreakCommand
implements CommandRegisterer {
    private static final String WOL_PERMISSION = "wizardsoflua.wol";
    private static final String WOL_SPELL_PERMISSION = "wizardsoflua.wol.spell";
    private static final String WOL_SPELL_BREAK_PERMISSION = "wizardsoflua.wol.spell.break";
    private static final String SID_ARG = "sid";
    private static final String NAME_ARG = "name";
    private static final String OWNER_ARG = "owner";
    private final SpellRegistry spellRegistry;

    public WolSpellBreakCommand(SpellRegistry spellRegistry) {
        this.spellRegistry = Objects.requireNonNull(spellRegistry, "spellRegistry");
    }

    @Override
    public void register(CommandDispatcher<class_2168> d, class_7157 registryAccess, class_2170.class_5364 environment) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"wol").requires(source -> source.method_9228() == null || Permissions.check((class_2172)source, (String)WOL_PERMISSION, (int)2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"spell").requires(source -> source.method_9228() == null || Permissions.check((class_2172)source, (String)WOL_SPELL_PERMISSION, (int)2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"break").requires(source -> source.method_9228() == null || Permissions.check((class_2172)source, (String)WOL_SPELL_BREAK_PERMISSION, (int)2))).executes(this::breakByCaller)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").requires(source -> source.method_9228() == null || Permissions.check((class_2172)source, (String)"wizardsoflua.wol.spell.break.all", (int)2))).executes(this::breakAll))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bySid").requires(source -> source.method_9228() == null || Permissions.check((class_2172)source, (String)"wizardsoflua.wol.spell.break.bySid", (int)2))).then(class_2170.method_9244((String)SID_ARG, (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::breakBySid)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"byName").requires(source -> source.method_9228() == null || Permissions.check((class_2172)source, (String)"wizardsoflua.wol.spell.break.byName", (int)2))).then(class_2170.method_9244((String)NAME_ARG, (ArgumentType)StringArgumentType.string()).executes(this::breakByName)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"byOwner").requires(source -> source.method_9228() == null || Permissions.check((class_2172)source, (String)"wizardsoflua.wol.spell.break.byOwner", (int)2))).then(class_2170.method_9244((String)OWNER_ARG, (ArgumentType)class_2186.method_9305()).executes(this::breakByOwner))))));
    }

    public int breakByCaller(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1297 entity = source.method_9228();
        return this.breakSpells(source, (Spell spell) -> Objects.equals(entity, spell.getOwner()));
    }

    public int breakAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        Collection<Spell> spells = this.spellRegistry.getAll();
        return this.breakSpells(source, spells);
    }

    public int breakBySid(CommandContext<class_2168> context) throws CommandSyntaxException {
        int sid = IntegerArgumentType.getInteger(context, (String)SID_ARG);
        class_2168 source = (class_2168)context.getSource();
        return this.breakSpells(source, (Spell spell) -> (long)sid == spell.getSid());
    }

    public int breakByName(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)NAME_ARG);
        class_2168 source = (class_2168)context.getSource();
        return this.breakSpells(source, (Spell spell) -> name.equals(spell.getName()));
    }

    public int breakByOwner(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 owner = class_2186.method_9315(context, (String)OWNER_ARG);
        class_2168 source = (class_2168)context.getSource();
        return this.breakSpells(source, (Spell spell) -> owner.equals((Object)spell.getOwner()));
    }

    private int breakSpells(class_2168 source, Predicate<Spell> predicate) {
        Collection<Spell> spells = this.spellRegistry.get(predicate);
        return this.breakSpells(source, spells);
    }

    private int breakSpells(class_2168 source, Iterable<Spell> spells) {
        int count = this.spellRegistry.breakSpells(spells);
        if (count == 0) {
            source.method_9226(() -> class_2561.method_30163((String)"No spells found"), false);
        } else if (count == 1) {
            source.method_9226(() -> class_2561.method_30163((String)"Broke 1 spell"), false);
        } else {
            int i = count;
            source.method_9226(() -> class_2561.method_30163((String)("Broke " + i + " spells")), false);
        }
        return count;
    }
}

