/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class BadArgumentException
extends IllegalArgumentException {
    private static final long serialVersionUID = 1L;
    private String detailMessage;
    @Nullable
    private Integer argumentIndex;
    @Nullable
    private String argumentName;
    @Nullable
    private String functionOrPropertyName;

    public BadArgumentException(String expected, String actual) {
        this("expected " + expected + " but got " + actual);
    }

    public BadArgumentException(String detailMessage) {
        this.setDetailMessage(detailMessage);
    }

    public BadArgumentException(String detailMessage, int argumentIndex, String functionOrPropertyName) {
        this.setDetailMessage(detailMessage);
        this.setArgumentIndex(argumentIndex);
        this.setFunctionOrPropertyName(functionOrPropertyName);
    }

    public BadArgumentException(String detailMessage, int argumentIndex, String argumentName, String functionOrPropertyName) {
        this.setDetailMessage(detailMessage);
        this.setArgumentIndex(argumentIndex);
        this.setArgumentName(argumentName);
        this.setFunctionOrPropertyName(functionOrPropertyName);
    }

    public String getDetailMessage() {
        return this.detailMessage;
    }

    public void setDetailMessage(String detailMessage) {
        this.detailMessage = Objects.requireNonNull(detailMessage, "detailMessage == null!");
    }

    public void setArgumentIndex(int argumentIndex) {
        this.argumentIndex = argumentIndex;
    }

    public void setArgumentName(String argumentName) {
        this.argumentName = Objects.requireNonNull(argumentName, "argumentName == null!");
    }

    public void setFunctionOrPropertyName(String functionOrPropertyName) {
        this.functionOrPropertyName = Objects.requireNonNull(functionOrPropertyName, "functionOrPropertyName == null!");
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("bad argument");
        if (this.argumentIndex != null) {
            sb.append(" #").append(this.argumentIndex);
        }
        if (this.argumentName != null) {
            sb.append(" (").append(this.argumentName).append(')');
        }
        if (this.functionOrPropertyName != null) {
            sb.append(" to '").append(this.functionOrPropertyName).append('\'');
        }
        sb.append(": ").append(this.detailMessage);
        return sb.toString();
    }
}

