/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.classes;

import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1275;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.WizardsOfLuaMod;
import net.wizardsoflua.lua.classes.AbstractLuaClass;
import net.wizardsoflua.lua.classes.AbstractLuaInstance;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.spell.SpellScope;

public class LuaBlockEntity<J extends class_2586, LC extends AbstractLuaClass<?, ?>>
extends AbstractLuaInstance<J, LC> {
    public LuaBlockEntity(LC luaClass, J javaInstance) {
        super(luaClass, javaInstance, true);
        this.addReadOnly("world", this::getWorld);
        if (javaInstance instanceof class_1275) {
            this.addReadOnly("name", this::getName);
        }
        this.addReadOnly("pos", this::getPos);
        this.addReadOnly("type", this::getType);
        this.add("nbt", this::getNbt, this::setNbt);
    }

    private Object getWorld() {
        return this.getConverters().toLua(((class_2586)this.getDelegate()).method_10997());
    }

    private Object getName() {
        return this.getConverters().toLua(((class_1275)this.getDelegate()).method_5477());
    }

    private Object getPos() {
        return this.getConverters().toLua(((class_2586)this.getDelegate()).method_11016());
    }

    private Object getType() {
        return this.getConverters().toLua(((class_2586)this.getDelegate()).method_11017());
    }

    private Object getNbt() {
        class_2586 blockEntity = (class_2586)this.getDelegate();
        class_5455 registryManager = blockEntity.method_10997().method_30349();
        class_2487 result = blockEntity.method_38244((class_7225.class_7874)registryManager);
        return NbtConverter.toLua(result);
    }

    public void putNbt(Table nbt) {
        class_2586 blockEntity = (class_2586)this.getDelegate();
        class_2680 oldState = blockEntity.method_11010();
        class_5455 registryManager = blockEntity.method_10997().method_30349();
        class_2487 oldNbt = blockEntity.method_38244((class_7225.class_7874)registryManager);
        class_2487 newNbt = ((AbstractLuaClass)((Object)this.getLuaClass())).getNbtConverter().merge(oldNbt, nbt);
        try (class_8942.class_11340 logging = new class_8942.class_11340(WizardsOfLuaMod.LOGGER);){
            class_11368 view = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)registryManager, (class_2487)newNbt);
            blockEntity.method_58690(view);
        }
        this.updateListeners(oldState);
    }

    private void setNbt(Object luaObject) {
        class_2586 blockEntity = (class_2586)this.getDelegate();
        class_2680 oldState = blockEntity.method_11010();
        Table data = this.getConverters().toJava(Table.class, luaObject, "nbt");
        class_2487 newNbt = ((AbstractLuaClass)((Object)this.getLuaClass())).getNbtConverter().merge(new class_2487(), data);
        try (class_8942.class_11340 logging = new class_8942.class_11340(WizardsOfLuaMod.LOGGER);){
            class_5455 registries = blockEntity.method_10997().method_30349();
            class_11368 view = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)registries, (class_2487)newNbt);
            blockEntity.method_58690(view);
        }
        this.updateListeners(oldState);
    }

    private void updateListeners(class_2680 oldState) {
        class_2586 blockEntity = (class_2586)this.getDelegate();
        blockEntity.method_5431();
        class_1937 world = blockEntity.method_10997();
        class_2338 pos = blockEntity.method_11016();
        class_2680 newState = blockEntity.method_11010();
        world.method_8413(pos, oldState, newState, 3);
    }

    public static class Class
    extends AbstractLuaClass<class_2586, LuaBlockEntity<class_2586, Class>> {
        public Class(SpellScope spellScope) {
            super("BlockEntity", spellScope, null);
            this.addFunction(new PutNbtFunction());
        }

        @Override
        protected final LuaBlockEntity<class_2586, Class> createNewLuaInstance(class_2586 javaInstance) {
            return new LuaBlockEntity<class_2586, Class>(this, javaInstance);
        }

        class PutNbtFunction
        extends NamedFunction2 {
            PutNbtFunction() {
            }

            @Override
            public String getName() {
                return "putNbt";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2) throws ResolvedControlThrowable {
                LuaBlockEntity self = Class.this.getConverters().toJava(LuaBlockEntity.class, arg1, 1, "self", this.getName());
                Table nbt = Class.this.getConverters().toJava(Table.class, arg2, 2, "nbt", this.getName());
                self.putNbt(nbt);
                context.getReturnBuffer().setTo();
            }
        }
    }
}

