/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.module.searcher;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sandius.rembulan.ByteString;
import net.sandius.rembulan.ByteStringBuilder;
import net.sandius.rembulan.Conversions;
import net.sandius.rembulan.LuaRuntimeException;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.Variable;
import net.sandius.rembulan.lib.AbstractLibFunction;
import net.sandius.rembulan.lib.ArgumentIterator;
import net.sandius.rembulan.load.LoaderException;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.LuaFunction;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.sandius.rembulan.util.ByteIterator;
import net.wizardsoflua.lua.compiler.ExtendedChunkLoader;
import net.wizardsoflua.lua.compiler.LuaFunctionBinary;
import net.wizardsoflua.lua.module.searcher.LuaFunctionBinaryByPathCache;

public class PatchedChunkLoadPathSearcher
extends AbstractLibFunction {
    static final ByteString DEFAULT_MODE = ByteString.constOf((String)"bt");
    private final FileSystem fileSystem;
    private final ExtendedChunkLoader loader;
    private final LuaFunctionBinaryByPathCache cache;
    private final Object env;
    private final Context context;

    public static void installInto(Table env, ExtendedChunkLoader loader, LuaFunctionBinaryByPathCache cache, ClassLoader classloader, FileSystem fileSystem, Context context) {
        PatchedChunkLoadPathSearcher function = new PatchedChunkLoadPathSearcher(fileSystem, loader, cache, env, context);
        Table pkg = (Table)env.rawget((Object)"package");
        Table searchers = (Table)pkg.rawget((Object)"searchers");
        long len = searchers.rawlen();
        searchers.rawset(len + 1L, (Object)function);
    }

    public PatchedChunkLoadPathSearcher(FileSystem fileSystem, ExtendedChunkLoader loader, LuaFunctionBinaryByPathCache cache, Object env, Context context) {
        this.fileSystem = Objects.requireNonNull(fileSystem);
        this.loader = Objects.requireNonNull(loader);
        this.cache = Objects.requireNonNull(cache);
        this.env = env;
        this.context = context;
    }

    protected String name() {
        return "(path searcher)";
    }

    private LuaFunction loaderForPath(ByteString path) throws LoaderException {
        return this.loadTextChunkFromFile(path.toString(), DEFAULT_MODE);
    }

    protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
        ByteString modName = args.nextString();
        ByteString path = Conversions.stringValueOf((Object)this.context.getLuaSearchPath());
        if (path == null) {
            throw new IllegalStateException("Missing 'path'");
        }
        List<ByteString> paths = SearchPath.getPaths(modName, path, SearchPath.DEFAULT_SEP, ByteString.of((String)this.fileSystem.getSeparator()));
        ByteStringBuilder msgBuilder = new ByteStringBuilder();
        for (ByteString s : paths) {
            Path p = this.fileSystem.getPath(s.toString(), new String[0]);
            if (Files.isReadable(p)) {
                LuaFunction fn;
                try {
                    fn = this.loaderForPath(s);
                }
                catch (LoaderException ex) {
                    throw new LuaRuntimeException((Object)("error loading module '" + String.valueOf(modName) + "' from file '" + String.valueOf(s) + "'\n\t" + ex.getLuaStyleErrorMessage()));
                }
                context.getReturnBuffer().setTo((Object)fn, (Object)s);
                return;
            }
            msgBuilder.append((CharSequence)"\n\tno file '").append(s).append((byte)39);
        }
        context.getReturnBuffer().setTo((Object)msgBuilder.toByteString());
    }

    private LuaFunction loadTextChunkFromFile(String fileName, ByteString modeString) throws LoaderException {
        LuaFunction fn;
        try {
            if (!modeString.contains((byte)116)) {
                throw new LuaRuntimeException((Object)("attempt to load a text chunk (mode is '" + String.valueOf(modeString) + "')"));
            }
            Path p = this.fileSystem.getPath(fileName, new String[0]);
            LuaFunctionBinary fnBin = this.cache.get(p);
            if (fnBin == null) {
                byte[] bytes = Files.readAllBytes(p);
                ByteString chunkText = ByteString.copyOf((byte[])bytes);
                fnBin = this.loader.compile(fileName, chunkText.toString());
                this.cache.put(p, fnBin);
            }
            fn = fnBin.loadInto(new Variable(this.env));
        }
        catch (IOException | InvalidPathException ex) {
            throw new LoaderException((Throwable)ex, fileName);
        }
        if (fn == null) {
            throw new LuaRuntimeException((Object)"loader returned nil");
        }
        return fn;
    }

    public static interface Context {
        public String getLuaSearchPath();
    }

    static class SearchPath
    extends AbstractLibFunction {
        private static final ByteString DEFAULT_SEP = ByteString.constOf((String)".");
        private final FileSystem fileSystem;
        private final ByteString defaultDirSeparator;
        static final byte PATH_SEPARATOR = 59;
        static final byte PATH_TEMPLATE_PLACEHOLDER = 63;

        SearchPath(FileSystem fileSystem) {
            this.fileSystem = Objects.requireNonNull(fileSystem);
            this.defaultDirSeparator = ByteString.of((String)fileSystem.getSeparator());
        }

        protected String name() {
            return "searchpath";
        }

        static List<ByteString> getPaths(ByteString name, ByteString path, ByteString sep, ByteString rep) {
            ArrayList<ByteString> result = new ArrayList<ByteString>();
            name = name.replace(sep, rep);
            ByteStringBuilder builder = new ByteStringBuilder();
            ByteIterator it = path.byteIterator();
            block4: while (it.hasNext()) {
                byte b = it.nextByte();
                switch (b) {
                    case 63: {
                        builder.append(name);
                        continue block4;
                    }
                    case 59: {
                        result.add(builder.toByteString());
                        builder.setLength(0);
                        continue block4;
                    }
                }
                builder.append(b);
            }
            if (builder.length() > 0) {
                result.add(builder.toByteString());
            }
            return result;
        }

        protected void invoke(ExecutionContext context, ArgumentIterator args) throws ResolvedControlThrowable {
            ByteString name = args.nextString();
            ByteString path = args.nextString();
            ByteString sep = args.nextOptionalString(DEFAULT_SEP);
            ByteString rep = args.nextOptionalString(this.defaultDirSeparator);
            ByteStringBuilder msgBuilder = new ByteStringBuilder();
            for (ByteString s : SearchPath.getPaths(name, path, sep, rep)) {
                Path p = this.fileSystem.getPath(s.toString(), new String[0]);
                if (Files.isReadable(p)) {
                    context.getReturnBuffer().setTo((Object)s);
                    return;
                }
                msgBuilder.append((CharSequence)"\n\tno file '").append(s).append((byte)39);
            }
            context.getReturnBuffer().setTo(null, (Object)msgBuilder.toString());
        }
    }
}

