/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.module.types;

import java.util.Objects;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.TableFactory;
import net.wizardsoflua.extension.spell.api.resource.LuaTypes;
import net.wizardsoflua.lua.BadArgumentException;

public class TypesModule {
    private final LuaTypes types;
    private final Table env;
    private final TableFactory tableFactory;
    private final Table objectClassMetaTable;

    public TypesModule(LuaTypes types, Table env, TableFactory tableFactory) {
        this.types = Objects.requireNonNull(types, "types");
        this.env = Objects.requireNonNull(env, "env");
        this.tableFactory = Objects.requireNonNull(tableFactory, "tableFactory");
        this.objectClassMetaTable = tableFactory.newTable();
    }

    public LuaTypes getTypes() {
        return this.types;
    }

    public Table declare(String className, Table metatable) {
        if (this.env.rawget((Object)className) != null) {
            throw new BadArgumentException("a global variable with name '" + className + "' is already defined", 1, "className", "declare");
        }
        if (metatable == null) {
            metatable = this.objectClassMetaTable;
        }
        Table classTable = this.tableFactory.newTable();
        classTable.rawset((Object)"__index", (Object)classTable);
        classTable.setMetatable(metatable);
        this.getTypes().registerLuaClass(className, classTable);
        this.env.rawset((Object)className, (Object)classTable);
        return classTable;
    }

    public boolean instanceOf(Table classTable, Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Table)) {
            return false;
        }
        Table metatable = ((Table)object).getMetatable();
        return classTable.equals(metatable) || this.instanceOf(classTable, metatable);
    }

    public String type(Object luaObject) {
        return this.getTypes().getLuaTypeNameOfLuaObject(luaObject);
    }
}

