/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.nbt;

import com.google.common.base.Preconditions;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.sandius.rembulan.Table;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.lua.nbt.NbtListMergeStrategy;
import net.wizardsoflua.lua.table.TableIterable;
import org.jetbrains.annotations.Nullable;

public class ValueBasedNbtListMergeStrategy
implements NbtListMergeStrategy {
    private final String key;
    private final NbtConverter converter;

    public ValueBasedNbtListMergeStrategy(String key, NbtConverter converter) {
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key == null!");
        this.converter = (NbtConverter)Preconditions.checkNotNull((Object)converter, (Object)"converter == null!");
    }

    @Override
    public class_2499 merge(class_2499 nbt, Table data, String path) {
        class_2499 result = nbt.method_10612();
        for (Map.Entry<Object, Object> entry : new TableIterable(data)) {
            class_2487 newValue;
            Table luaValue = (Table)entry.getValue();
            Object keyValue = luaValue.rawget((Object)this.key);
            Preconditions.checkNotNull((Object)keyValue, (Object)("Expected each value to contain the key: '" + this.key + "'"));
            class_2487 oldValue = this.getCompoundByValueKey(nbt, keyValue);
            String entryPath = path + "[" + String.valueOf(keyValue) + "]";
            if (oldValue != null) {
                newValue = this.converter.merge(oldValue, luaValue, entryPath);
                result.add((Object)newValue);
                continue;
            }
            newValue = this.converter.toNbtCompound(luaValue, entryPath);
            result.add((Object)newValue);
        }
        return result;
    }

    @Nullable
    private class_2487 getCompoundByValueKey(class_2499 compoundList, Object keyValue) {
        Preconditions.checkNotNull((Object)keyValue, (Object)"keyValue == null!");
        for (int i = 0; i < compoundList.size(); ++i) {
            class_2487 compound = (class_2487)compoundList.method_10602(i).orElseThrow();
            class_2520 nbtKeyValue = compound.method_10580(this.key);
            Preconditions.checkNotNull((Object)nbtKeyValue, (Object)("Expected each NBT value to contain the key: '" + this.key + "'"));
            if (!nbtKeyValue.equals(keyValue)) continue;
            return compound;
        }
        return null;
    }
}

