/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.table;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.sandius.rembulan.runtime.IllegalOperationAttemptException;
import org.jetbrains.annotations.Nullable;

class TableProperty<T> {
    @Nullable
    private final Supplier<T> get;
    @Nullable
    private final Consumer<Object> set;

    public TableProperty(@Nullable Supplier<T> get, @Nullable Consumer<Object> set) {
        Preconditions.checkArgument((get != null || set != null ? 1 : 0) != 0, (Object)"Property must be writeable or readable");
        this.get = get;
        this.set = set;
    }

    public T get() {
        if (this.get == null) {
            throw new IllegalOperationAttemptException("attempt to access write-only table index");
        }
        return this.get.get();
    }

    public void set(Object value) {
        if (this.set == null) {
            throw new IllegalOperationAttemptException("attempt to modify read-only table index");
        }
        this.set.accept(value);
    }
}

