/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.spell;

import com.google.common.primitives.Ints;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.sandius.rembulan.ByteString;
import net.sandius.rembulan.Conversions;
import net.sandius.rembulan.Table;
import net.wizardsoflua.WolDirectories;
import net.wizardsoflua.chunk.ChunkForceManager;
import net.wizardsoflua.extension.spell.api.resource.LuaConverters;
import net.wizardsoflua.extension.spell.spi.JavaToLuaConverter;
import net.wizardsoflua.extension.spell.spi.LuaConverter;
import net.wizardsoflua.extension.spell.spi.LuaToJavaConverter;
import net.wizardsoflua.filesystem.WolServerFileSystem;
import net.wizardsoflua.lua.Converters;
import net.wizardsoflua.lua.classes.AbstractLuaClass;
import net.wizardsoflua.lua.classes.AbstractLuaInstance;
import net.wizardsoflua.lua.classes.LuaAfterLivingEntityDamageEvent;
import net.wizardsoflua.lua.classes.LuaAfterLivingEntityDeathEvent;
import net.wizardsoflua.lua.classes.LuaAfterPlayerBlockBreakEvent;
import net.wizardsoflua.lua.classes.LuaAfterPlayerRespawnEvent;
import net.wizardsoflua.lua.classes.LuaBeforeLivingEntityDamageEvent;
import net.wizardsoflua.lua.classes.LuaBeforeLivingEntityDeathEvent;
import net.wizardsoflua.lua.classes.LuaBeforePlayerBlockBreakEvent;
import net.wizardsoflua.lua.classes.LuaBlock;
import net.wizardsoflua.lua.classes.LuaBlockEntity;
import net.wizardsoflua.lua.classes.LuaBlockEntityType;
import net.wizardsoflua.lua.classes.LuaBlockHitResult;
import net.wizardsoflua.lua.classes.LuaBlockType;
import net.wizardsoflua.lua.classes.LuaChatMessageEvent;
import net.wizardsoflua.lua.classes.LuaChunkLoadEvent;
import net.wizardsoflua.lua.classes.LuaChunkUnloadEvent;
import net.wizardsoflua.lua.classes.LuaCustomEvent;
import net.wizardsoflua.lua.classes.LuaDamageSource;
import net.wizardsoflua.lua.classes.LuaEntity;
import net.wizardsoflua.lua.classes.LuaEntityDespawnEvent;
import net.wizardsoflua.lua.classes.LuaEntityHitResult;
import net.wizardsoflua.lua.classes.LuaEntitySpawnEvent;
import net.wizardsoflua.lua.classes.LuaEntityType;
import net.wizardsoflua.lua.classes.LuaEventInterceptor;
import net.wizardsoflua.lua.classes.LuaEventQueue;
import net.wizardsoflua.lua.classes.LuaFilesystem;
import net.wizardsoflua.lua.classes.LuaHitResult;
import net.wizardsoflua.lua.classes.LuaInstanceCache;
import net.wizardsoflua.lua.classes.LuaItem;
import net.wizardsoflua.lua.classes.LuaItemEntity;
import net.wizardsoflua.lua.classes.LuaItemType;
import net.wizardsoflua.lua.classes.LuaLivingEntity;
import net.wizardsoflua.lua.classes.LuaMobEntity;
import net.wizardsoflua.lua.classes.LuaPermissioCheckEvent;
import net.wizardsoflua.lua.classes.LuaPlayer;
import net.wizardsoflua.lua.classes.LuaPlayerAttackBlockEvent;
import net.wizardsoflua.lua.classes.LuaPlayerAttackEntityEvent;
import net.wizardsoflua.lua.classes.LuaPlayerChangeWorldEvent;
import net.wizardsoflua.lua.classes.LuaPlayerDisconnectedEvent;
import net.wizardsoflua.lua.classes.LuaPlayerDropItemEvent;
import net.wizardsoflua.lua.classes.LuaPlayerDropSelectedItemEvent;
import net.wizardsoflua.lua.classes.LuaPlayerHandSwingEvent;
import net.wizardsoflua.lua.classes.LuaPlayerInventory;
import net.wizardsoflua.lua.classes.LuaPlayerJoinedEvent;
import net.wizardsoflua.lua.classes.LuaPlayerUseBlockEvent;
import net.wizardsoflua.lua.classes.LuaPlayerUseEntityEvent;
import net.wizardsoflua.lua.classes.LuaPlayerUseItemEvent;
import net.wizardsoflua.lua.classes.LuaServer;
import net.wizardsoflua.lua.classes.LuaSpell;
import net.wizardsoflua.lua.classes.LuaSpellFinishEvent;
import net.wizardsoflua.lua.classes.LuaStructure;
import net.wizardsoflua.lua.classes.LuaTrace;
import net.wizardsoflua.lua.classes.LuaWorld;
import net.wizardsoflua.lua.classes.TypesModuleLuaTable;
import net.wizardsoflua.lua.classes.WolModuleLuaTable;
import net.wizardsoflua.lua.module.types.Types;
import net.wizardsoflua.lua.module.types.TypesModule;
import net.wizardsoflua.lua.module.wol.WolModule;
import net.wizardsoflua.lua.nbt.NbtConverter;
import net.wizardsoflua.lua.table.DefaultTableBuilder;
import net.wizardsoflua.lua.table.DelegatingLuaTable;
import net.wizardsoflua.spell.Spell;
import net.wizardsoflua.spell.SpellRegistry;
import net.wizardsoflua.spell.SpellServerCommandSource;
import net.wizardsoflua.world.WorldChunkTracker;
import org.jetbrains.annotations.Nullable;

public class SpellScope {
    private final SpellRegistry spellRegistry;
    private final class_3218 world;
    private final ChunkForceManager chunkForceManager;
    private final WolDirectories directories;
    private final WolModule wolModule;
    private final WorldChunkTracker worldChunkTracker;
    private final class_2168 commandSource;
    private final WolServerFileSystem wolServerFileSystem;
    private final Types types;
    private final Converters converters;
    private final NbtConverter nbtConverter;
    private final LuaInstanceCache instanceCache = new LuaInstanceCache();
    private Spell spell;

    public SpellScope(SpellRegistry spellRegistry, ChunkForceManager chunkForceManager, WolDirectories directories, WolModule wolModule, WorldChunkTracker worldChunkTracker, class_2168 commandSource) {
        this.spellRegistry = Objects.requireNonNull(spellRegistry, "spellRegistry");
        this.chunkForceManager = Objects.requireNonNull(chunkForceManager, "chunkForceManager");
        this.directories = Objects.requireNonNull(directories, "directories");
        this.wolModule = Objects.requireNonNull(wolModule, "wolModule");
        this.worldChunkTracker = Objects.requireNonNull(worldChunkTracker, "worldChunkTracker");
        this.commandSource = Objects.requireNonNull(commandSource, "commandSource");
        this.world = Objects.requireNonNull(commandSource.method_9225(), "world");
        this.wolServerFileSystem = new WolServerFileSystem(this.world.method_8503().method_27050(class_5218.field_24188).normalize());
        this.types = new Types(this::getConverters);
        this.converters = new Converters(this::getTypes);
        this.nbtConverter = new NbtConverter(this.types);
        this.addClasses();
        this.addAdditionalConverters();
    }

    void setSpell(Spell spell) {
        this.spell = Objects.requireNonNull(spell, "spell");
    }

    public Spell getSpell() {
        return Objects.requireNonNull(this.spell, "spell");
    }

    public class_3218 getWorld() {
        return this.world;
    }

    public WorldChunkTracker getWorldChunkTracker() {
        return this.worldChunkTracker;
    }

    public class_2168 getCommandSource() {
        return this.commandSource;
    }

    public class_2168 getTopmostCommandSource() {
        class_2168 result = this.commandSource;
        while (result instanceof SpellServerCommandSource) {
            SpellServerCommandSource scs = (SpellServerCommandSource)result;
            result = scs.getSpell().getSpellScope().getCommandSource();
        }
        return result;
    }

    @Nullable
    public class_1297 getOwner() {
        class_2168 class_21682 = this.commandSource;
        if (class_21682 instanceof SpellServerCommandSource) {
            SpellServerCommandSource spellSource = (SpellServerCommandSource)class_21682;
            return spellSource.getSpell().getOwner();
        }
        return this.commandSource.method_9228();
    }

    public ChunkForceManager getChunkForceManager() {
        return this.chunkForceManager;
    }

    public WolServerFileSystem getWolServerFileSystem() {
        return this.wolServerFileSystem;
    }

    public WolDirectories getDirectories() {
        return this.directories;
    }

    public WolModule getWolModule() {
        return this.wolModule;
    }

    public Converters getConverters() {
        return this.converters;
    }

    public Types getTypes() {
        return this.types;
    }

    public NbtConverter getNbtConverter() {
        return this.nbtConverter;
    }

    public SpellRegistry getSpellRegistry() {
        return this.spellRegistry;
    }

    public LuaInstanceCache getInstanceCache() {
        return this.instanceCache;
    }

    private void addClasses() {
        LuaEntity.Class entityLuaClass = this.add(new LuaEntity.Class(this));
        LuaLivingEntity.Class livingEntityLuaClass = this.add(new LuaLivingEntity.Class(this, entityLuaClass));
        this.add(new LuaMobEntity.Class(this, livingEntityLuaClass));
        LuaHitResult.Class luaHitResultClass = this.add(new LuaHitResult.Class(this));
        this.add(new LuaAfterLivingEntityDamageEvent.Class(this));
        this.add(new LuaAfterLivingEntityDeathEvent.Class(this));
        this.add(new LuaAfterPlayerBlockBreakEvent.Class(this));
        this.add(new LuaAfterPlayerRespawnEvent.Class(this));
        this.add(new LuaBeforeLivingEntityDamageEvent.Class(this));
        this.add(new LuaBeforeLivingEntityDeathEvent.Class(this));
        this.add(new LuaBeforePlayerBlockBreakEvent.Class(this));
        this.add(new LuaBlock.Class(this));
        this.add(new LuaBlockEntity.Class(this));
        this.add(new LuaBlockEntityType.Class(this));
        this.add(new LuaBlockHitResult.Class(this, luaHitResultClass));
        this.add(new LuaBlockType.Class(this));
        this.add(new LuaChatMessageEvent.Class(this));
        this.add(new LuaChunkLoadEvent.Class(this));
        this.add(new LuaChunkUnloadEvent.Class(this));
        this.add(new LuaCustomEvent.Class(this));
        this.add(new LuaDamageSource.Class(this));
        this.add(new LuaEntityDespawnEvent.Class(this));
        this.add(new LuaEntityHitResult.Class(this, luaHitResultClass));
        this.add(new LuaEntityType.Class(this));
        this.add(new LuaEntitySpawnEvent.Class(this));
        this.add(new LuaEventInterceptor.Class(this));
        this.add(new LuaEventQueue.Class(this));
        this.add(new LuaFilesystem.Class(this));
        this.add(new LuaTrace.Class(this));
        this.add(new LuaItemType.Class(this));
        this.add(new LuaItemEntity.Class(this, entityLuaClass));
        this.add(new LuaItem.Class(this));
        this.add(new LuaPermissioCheckEvent.Class(this));
        this.add(new LuaPlayer.Class(this, livingEntityLuaClass));
        this.add(new LuaPlayerAttackBlockEvent.Class(this));
        this.add(new LuaPlayerAttackEntityEvent.Class(this));
        this.add(new LuaPlayerChangeWorldEvent.Class(this));
        this.add(new LuaPlayerDisconnectedEvent.Class(this));
        this.add(new LuaPlayerDropItemEvent.Class(this));
        this.add(new LuaPlayerDropSelectedItemEvent.Class(this));
        this.add(new LuaPlayerHandSwingEvent.Class(this));
        this.add(new LuaPlayerInventory.Class(this));
        this.add(new LuaPlayerUseBlockEvent.Class(this));
        this.add(new LuaPlayerUseEntityEvent.Class(this));
        this.add(new LuaPlayerUseItemEvent.Class(this));
        this.add(new LuaPlayerJoinedEvent.Class(this));
        this.add(new LuaServer.Class(this));
        this.add(new LuaSpell.Class(this));
        this.add(new LuaSpellFinishEvent.Class(this));
        this.add(new LuaStructure.Class(this));
        this.add(new LuaWorld.Class(this));
    }

    private void addAdditionalConverters() {
        this.converters.registerLuaConverter("Types", TypesModule.class, TypesModuleLuaTable.class, DelegatingLuaTable::getDelegate, it -> new TypesModuleLuaTable((TypesModule)it, this.converters));
        this.converters.registerLuaConverter("WizardsOfLua", WolModule.class, WolModuleLuaTable.class, DelegatingLuaTable::getDelegate, it -> new WolModuleLuaTable((WolModule)it, (LuaConverters)this.converters, this));
        this.converters.registerLuaConverter("Vec3", class_243.class, Table.class, luaObj -> {
            double x = Conversions.floatValueOf((Object)luaObj.rawget((Object)"x"));
            double y = Conversions.floatValueOf((Object)luaObj.rawget((Object)"y"));
            double z = Conversions.floatValueOf((Object)luaObj.rawget((Object)"z"));
            return new class_243(x, y, z);
        }, javaObj -> {
            DefaultTableBuilder builder = new DefaultTableBuilder();
            builder.add("x", javaObj.field_1352);
            builder.add("y", javaObj.field_1351);
            builder.add("z", javaObj.field_1350);
            Table classTable = this.types.getLuaClassTableForName("Vec3");
            builder.setMetatable(classTable);
            return builder.build();
        });
        this.converters.registerJavaToLuaConverter(new JavaToLuaConverter<class_2382>(){

            @Override
            public Class<class_2382> getJavaClass() {
                return class_2382.class;
            }

            @Override
            public Object getLuaInstance(class_2382 javaInstance) {
                class_243 vec3d = class_243.method_24954((class_2382)javaInstance);
                return SpellScope.this.converters.toLua(vec3d);
            }
        });
        this.converters.registerLuaToJavaConverter(new LuaToJavaConverter<class_2338, Table>(this){

            @Override
            public Class<class_2338> getJavaClass() {
                return class_2338.class;
            }

            @Override
            public Class<Table> getLuaClass() {
                return Table.class;
            }

            @Override
            public class_2338 getJavaInstance(Table luaObj) {
                int x = Ints.saturatedCast((long)Conversions.integerValueOf((Object)luaObj.rawget((Object)"x")));
                int y = Ints.saturatedCast((long)Conversions.integerValueOf((Object)luaObj.rawget((Object)"y")));
                int z = Ints.saturatedCast((long)Conversions.integerValueOf((Object)luaObj.rawget((Object)"z")));
                return new class_2338(x, y, z);
            }
        });
        this.converters.registerLuaConverter(new LuaConverter<class_1304, ByteString>(this){

            @Override
            public Class<class_1304> getJavaClass() {
                return class_1304.class;
            }

            @Override
            public Class<ByteString> getLuaClass() {
                return ByteString.class;
            }

            @Override
            public class_1304 getJavaInstance(ByteString luaInstance) {
                String name = luaInstance.toString();
                return class_1304.method_5924((String)name);
            }

            @Override
            public ByteString getLuaInstance(class_1304 javaInstance) {
                return ByteString.of((String)javaInstance.method_15434());
            }
        });
    }

    private <J, L extends AbstractLuaInstance<J, C>, C extends AbstractLuaClass<J, L>> C add(C luaClass) {
        String name = luaClass.getName();
        final Class<J> classJ = luaClass.getJavaClass();
        final Class<L> classL = luaClass.getLuaInstanceClass();
        final Function<Object, Object> toLua = luaClass::toLua;
        final Function<AbstractLuaInstance, Object> toJava = luaClass::toJava;
        this.types.registerLuaClass(name, luaClass);
        this.converters.registerJavaToLuaConverter(new JavaToLuaConverter<J>(){

            @Override
            public Class<J> getJavaClass() {
                return classJ;
            }

            @Override
            public Object getLuaInstance(J javaInstance) {
                return toLua.apply(javaInstance);
            }
        });
        this.converters.registerLuaToJavaConverter(new LuaToJavaConverter<J, L>(){

            @Override
            public Class<J> getJavaClass() {
                return classJ;
            }

            @Override
            public Class<L> getLuaClass() {
                return classL;
            }

            @Override
            public J getJavaInstance(L luaInstance) {
                return toJava.apply(luaInstance);
            }
        });
        return luaClass;
    }
}

