-- Prevent duplicate spells from running
local name = 'towelPathsSpell'
spell:executeSilent("wol spell break byName " .. name)
spell.name = name


local portal1min = Vec3(-311,56,-230)
local portal1max = Vec3(-311,60,-229)
local portal2min = Vec3(-321,65,-434)
local portal2max = Vec3(-321,69,-433)

function tableLength(table)
	-- Lua has a method to check the length of a table:
	--    local table = {1,2,3}
	--    print(#table)
	-- Unfortunately it only works if the table has consecutive numberic keys.  Which means it's totally useless for looking at player.nbt.equipment et al
	
	if not table then return 0; end
	local length = 0
	for a,b in pairs(table) do
		length = length + 1
	end
	return length
end

function isInsideRegion(pos, regionMin, regionMax)
	if pos.x <= regionMin.x then return false; end
	if pos.y <= regionMin.y then return false; end
	if pos.z <= regionMin.z then return false; end
	if pos.x > regionMax.x + 1 then return false; end
	if pos.y > regionMax.y + 1 then return false; end
	if pos.z > regionMax.z + 1 then return false; end
	return true
end

function getPlayersInRegion(regionMin, regionMax)
	local x = regionMin.x - 1
	local y = regionMin.y - 1
	local z = regionMin.z - 1
	local dx = regionMax.x - regionMin.x
	local dy = regionMax.y - regionMin.y
	local dz = regionMax.z - regionMin.z
	local searchstring = "@a[x="..str(x)..",y="..str(y)..",z="..str(z)..",dx="..str(dx)..",dy="..str(dy)..",dz="..str(dz).."]"
	return spell:findEntities(searchstring)
end

function doesPlayerHaveSecretKey(player)
	local helditem = player.mainHandItem
	if not helditem then return false; end
	if helditem.count ~= 7 then return false; end
	return true
end

function decrementPlayerSecretKey(player)
	local helditem = player.mainHandItem
	if not helditem then return; end -- Should never happen
	helditem.count = helditem.count - 1
	player.mainHandItem = helditem -- have to write it back as player.mainHandItem returns a copy not a ref
end

function playMysterySfx(location)
	-- hack - fix lag issue
	sleep(5)
	spell.pos = location
	spell:executeSilent("/playsound minecraft:block.fire.extinguish player @a ~ ~ ~ 2 0.5")
end

while true do 

	local portal1Players = getPlayersInRegion(portal1min, portal1max)
	local portal2Players = getPlayersInRegion(portal2min, portal2max)
	local offset = portal1min - portal2min
	
	for _,p in pairs(portal1Players) do
		
		local portalstatus = p.extra.towelPathsPortalStatus
		local secretkeyheld = doesPlayerHaveSecretKey(p)
		
		if  portalstatus == nil or portalstatus == "2visit" or secretkeyheld then
			p.pos = p.pos - offset
			p:putExtra({towelPathsPortalStatus = "2exit"})
			if secretkeyheld then 
				decrementPlayerSecretKey(p)
				playMysterySfx(p.pos)
			end
		elseif portalstatus == "2exit" then
			p:putExtra({towelPathsPortalStatus = "1visit"})
		end
		--print(p.extra.towelPathsPortalStatus)
	end
	for _,p in pairs(portal2Players) do
	
		local portalstatus = p.extra.towelPathsPortalStatus
		local secretkeyheld = doesPlayerHaveSecretKey(p)
	
		local portalstatus = p.extra.towelPathsPortalStatus
		if  portalstatus == nil or portalstatus == "1visit" or secretkeyheld then
			p.pos = p.pos + offset
			p:putExtra({towelPathsPortalStatus = "1exit"})
			if secretkeyheld then 
				decrementPlayerSecretKey(p)
				playMysterySfx(p.pos)
			end
		elseif portalstatus == "1exit" then
			p:putExtra({towelPathsPortalStatus = "2visit"})
		end
		--print(p.extra.towelPathsPortalStatus)
	end
	
	sleep(10) 
end 


