/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.mixin.entity.IMixinSkeletonEntity;
import fi.dy.masa.minihud.mixin.entity.IMixinZombieEntity;
import fi.dy.masa.minihud.mixin.entity.IMixinZombieVillagerEntity;
import fi.dy.masa.minihud.util.MiscUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1613;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.apache.commons.lang3.tuple.Pair;

public class InfoLineZombieConversion
extends InfoLine {
    private static final String ZOMBIE_KEY = "minihud.info_line.zombie_conversion";

    public InfoLineZombieConversion(InfoToggle type) {
        super(type);
    }

    public InfoLineZombieConversion() {
        this(InfoToggle.ZOMBIE_CONVERSION);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasNbt()) {
            class_1299 entityType = NbtEntityUtils.getEntityTypeFromNbt((class_2487)ctx.nbt());
            if (entityType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), entityType, ctx.nbt());
        }
        return ctx.ent() != null ? this.parseEnt(ctx.world(), ctx.ent()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@Nonnull class_1937 world, @Nonnull class_1299<?> entityType, @Nonnull class_2487 nbt) {
        String zombieType = entityType.method_5897().getString();
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        int conversionTimer = -1;
        if (entityType.equals((Object)class_1299.field_6054)) {
            Pair zombieDoctor = NbtEntityUtils.getZombieConversionTimerFromNbt((class_2487)nbt);
            conversionTimer = (Integer)zombieDoctor.getLeft();
        } else if (entityType.equals((Object)class_1299.field_6051)) {
            Pair zombieDoctor = NbtEntityUtils.getDrownedConversionTimerFromNbt((class_2487)nbt);
            conversionTimer = (Integer)zombieDoctor.getLeft();
        } else if (entityType.equals((Object)class_1299.field_6137)) {
            conversionTimer = NbtEntityUtils.getStrayConversionTimeFromNbt((class_2487)nbt);
        }
        if (conversionTimer > 0) {
            list.add(this.translate(ZOMBIE_KEY, zombieType, MiscUtils.formatDuration((long)(conversionTimer / 20) * 1000L)));
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@Nonnull class_1937 world, @Nonnull class_1297 ent) {
        String zombieType = ent.method_5864().method_5897().getString();
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        class_1297 class_12972 = ent;
        Objects.requireNonNull(class_12972);
        class_1297 class_12973 = class_12972;
        int n = 0;
        int conversionTimer = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1641.class, class_1642.class, class_1613.class}, (Object)class_12973, n)) {
            case 0 -> {
                class_1641 zombie = (class_1641)class_12973;
                yield ((IMixinZombieVillagerEntity)zombie).minihud_conversionTimer();
            }
            case 1 -> {
                class_1642 zombert = (class_1642)class_12973;
                yield ((IMixinZombieEntity)zombert).minihud_ticksUntilWaterConversion();
            }
            case 2 -> {
                class_1613 skeleton = (class_1613)class_12973;
                yield ((IMixinSkeletonEntity)skeleton).minihud_conversionTime();
            }
            default -> -1;
        };
        if (conversionTimer > 0) {
            list.add(this.translate(ZOMBIE_KEY, zombieType, MiscUtils.formatDuration((long)(conversionTimer / 20) * 1000L)));
        }
        return list;
    }
}

