/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.quad;

import java.nio.ByteBuffer;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.quad.RegularTQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FullTQuad
extends RegularTQuad {
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private int sameVertexMap;
    private boolean normalIsVeryAccurate = false;
    private boolean hasUpdatedVertices = false;
    private static final int NO_WRITE = -1;
    private int writeToIndex = -1;

    FullTQuad(ModelQuadFacing facing, int packedNormal) {
        super(facing, packedNormal);
    }

    public static FullTQuad fromVertices(ChunkVertexEncoder.Vertex[] vertices, ModelQuadFacing facing, int packedNormal) {
        FullTQuad quad = new FullTQuad(facing, packedNormal);
        quad.sameVertexMap = quad.initExtentsAndCenter(vertices);
        if (quad.isInvalid()) {
            return null;
        }
        quad.initDotProduct();
        quad.initVertices(vertices);
        return quad;
    }

    private void initVertices(ChunkVertexEncoder.Vertex[] vertices) {
        for (int i = 0; i < 4; ++i) {
            ChunkVertexEncoder.Vertex newVertex = this.vertices[i];
            ChunkVertexEncoder.Vertex oldVertex = vertices[i];
            ChunkVertexEncoder.Vertex.copyVertexTo(oldVertex, newVertex);
        }
    }

    public static FullTQuad splittingCopy(FullTQuad quad) {
        FullTQuad newQuad = new FullTQuad(quad.facing, quad.packedNormal);
        newQuad.initVertices(quad.vertices);
        newQuad.extents = quad.extents;
        newQuad.accurateDotProduct = quad.accurateDotProduct;
        newQuad.quantizedDotProduct = quad.quantizedDotProduct;
        newQuad.center = quad.center;
        newQuad.quantizedNormal = quad.quantizedNormal;
        newQuad.accurateNormal = quad.accurateNormal;
        newQuad.normalIsVeryAccurate = quad.normalIsVeryAccurate;
        return newQuad;
    }

    public void updateSplitQuadAfterVertexModification() {
        this.sameVertexMap = this.initExtentsAndCenter(this.vertices);
        this.vertexPositions = null;
    }

    public boolean isInvalid() {
        return FullTQuad.isInvalid(this.sameVertexMap);
    }

    public int getUniqueVertexMap() {
        return ~this.sameVertexMap & 0xF;
    }

    public int getSameVertexMap() {
        return this.sameVertexMap;
    }

    public boolean triggerAndSetUpdatedVertices() {
        if (this.hasUpdatedVertices) {
            return false;
        }
        this.hasUpdatedVertices = true;
        return true;
    }

    public void setWriteToIndex(int writeToIndex) {
        this.writeToIndex = writeToIndex;
    }

    public void setNoWrite() {
        this.writeToIndex = -1;
    }

    public void writeToBuffer(ChunkMeshBufferBuilder bufferBuilder, ByteBuffer buffer) {
        if (this.writeToIndex != -1) {
            bufferBuilder.writeExternal(buffer, TranslucentData.quadCountToVertexCount(this.writeToIndex), this.vertices, DefaultMaterials.TRANSLUCENT);
        }
    }

    @Override
    public float[] getVertexPositions() {
        if (this.vertexPositions == null) {
            this.vertexPositions = new float[12];
            for (int i = 0; i < 4; ++i) {
                this.vertexPositions[i * 3] = this.vertices[i].x;
                this.vertexPositions[i * 3 + 1] = this.vertices[i].y;
                this.vertexPositions[i * 3 + 2] = this.vertices[i].z;
            }
        }
        return this.vertexPositions;
    }

    public Vector3fc getVeryAccurateNormal() {
        if (this.facing.isAligned()) {
            return this.facing.getAlignedNormal();
        }
        if (!this.normalIsVeryAccurate) {
            float y2 = this.vertices[2].y;
            float y0 = this.vertices[0].y;
            float dy0 = y2 - y0;
            float z3 = this.vertices[3].z;
            float z1 = this.vertices[1].z;
            float dz1 = z3 - z1;
            float z2 = this.vertices[2].z;
            float z0 = this.vertices[0].z;
            float dz0 = z2 - z0;
            float y3 = this.vertices[3].y;
            float y1 = this.vertices[1].y;
            float dy1 = y3 - y1;
            float normX = dy0 * dz1 - dz0 * dy1;
            float x3 = this.vertices[3].x;
            float x1 = this.vertices[1].x;
            float dx1 = x3 - x1;
            float x2 = this.vertices[2].x;
            float x0 = this.vertices[0].x;
            float dx0 = x2 - x0;
            float normY = dz0 * dx1 - dx0 * dz1;
            float normZ = dx0 * dy1 - dy0 * dx1;
            float length = (float)Math.sqrt(normX * normX + normY * normY + normZ * normZ);
            if ((double)length != 0.0 && (double)length != 1.0) {
                normX /= length;
                normY /= length;
                normZ /= length;
            }
            this.accurateNormal = new Vector3f(normX, normY, normZ);
            this.accurateDotProduct = this.accurateNormal.dot(this.center);
            this.normalIsVeryAccurate = true;
        }
        return this.accurateNormal;
    }

    public ChunkVertexEncoder.Vertex[] getVertices() {
        return this.vertices;
    }
}

