/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.entity.shadows;

import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.EntityVertex;
import net.caffeinemc.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.minecraft.class_10017;
import net.minecraft.class_11661;
import net.minecraft.class_11690;
import net.minecraft.class_11788;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_11690.class})
public class ShadowFeatureRendererMixin {
    @Unique
    private static final int DEFAULT_NORMAL = NormI8.pack(0.0f, 1.0f, 0.0f);
    @Shadow
    @Final
    private static class_1921 field_61847;
    @Unique
    private static final int SHADOW_COLOR;

    @Inject(method={"method_73015(Lnet/minecraft/class_11788;Lnet/minecraft/class_4597$class_4598;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderShadowPartFast(class_11788 submitNodeCollection, class_4597.class_4598 bufferSource, CallbackInfo ci) {
        class_4588 vertices = bufferSource.method_73477(field_61847);
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertices);
        if (writer == null) {
            return;
        }
        ci.cancel();
        for (class_11661.class_11673 shadows : submitNodeCollection.method_73505()) {
            Matrix4f matrices = shadows.comp_4522();
            for (int i = 0; i < shadows.comp_4524().size(); ++i) {
                class_10017.class_11680 shadowPiece = (class_10017.class_11680)shadows.comp_4524().get(i);
                float alpha = shadowPiece.comp_4550();
                if (!(alpha >= 0.0f)) continue;
                if (alpha > 1.0f) {
                    alpha = 1.0f;
                }
                class_238 box = shadowPiece.comp_4549().method_1107();
                float minX = (float)((double)shadowPiece.comp_4546() + box.field_1323);
                float maxX = (float)((double)shadowPiece.comp_4546() + box.field_1320);
                float minY = (float)((double)shadowPiece.comp_4547() + box.field_1322);
                float minZ = (float)((double)shadowPiece.comp_4548() + box.field_1321);
                float maxZ = (float)((double)shadowPiece.comp_4548() + box.field_1324);
                ShadowFeatureRendererMixin.renderShadowPart(matrices, writer, shadows.comp_4523(), alpha, minX, maxX, minY, minZ, maxZ);
            }
        }
    }

    @Unique
    private static void renderShadowPart(Matrix4f matPosition, VertexBufferWriter writer, float radius, float alpha, float minX, float maxX, float minY, float minZ, float maxZ) {
        float size = 0.5f * (1.0f / radius);
        float u1 = -minX * size + 0.5f;
        float u2 = -maxX * size + 0.5f;
        float v1 = -minZ * size + 0.5f;
        float v2 = -maxZ * size + 0.5f;
        int color = ColorABGR.withAlpha(SHADOW_COLOR, alpha);
        int normal = DEFAULT_NORMAL;
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(144);
            ShadowFeatureRendererMixin.writeShadowVertex(ptr, matPosition, minX, minY, minZ, u1, v1, color, normal);
            ShadowFeatureRendererMixin.writeShadowVertex(ptr += 36L, matPosition, minX, minY, maxZ, u1, v2, color, normal);
            ShadowFeatureRendererMixin.writeShadowVertex(ptr += 36L, matPosition, maxX, minY, maxZ, u2, v2, color, normal);
            ShadowFeatureRendererMixin.writeShadowVertex(ptr += 36L, matPosition, maxX, minY, minZ, u2, v1, color, normal);
            ptr += 36L;
            writer.push(stack, buffer, 4, EntityVertex.FORMAT);
        }
    }

    @Unique
    private static void writeShadowVertex(long ptr, Matrix4f matPosition, float x, float y, float z, float u, float v, int color, int normal) {
        float xt = MatrixHelper.transformPositionX((Matrix4fc)matPosition, x, y, z);
        float yt = MatrixHelper.transformPositionY((Matrix4fc)matPosition, x, y, z);
        float zt = MatrixHelper.transformPositionZ((Matrix4fc)matPosition, x, y, z);
        EntityVertex.write(ptr, xt, yt, zt, color, u, v, 0xF000F0, class_4608.field_21444, normal);
    }

    static {
        SHADOW_COLOR = ColorABGR.pack(1.0f, 1.0f, 1.0f);
    }
}

