/*
 * Decompiled with CFR 0.152.
 */
package me.jarco.lefthandtrick.mixin.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1306;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_759.class})
public class HeldItemRendererMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LeftHandTrick");
    private static final String CONFIG_PATH = "config/lefthandtrick.properties";
    private static boolean enabled = true;
    private static float mainHandOffsetX = 0.1f;
    private static float offHandOffsetX = 0.1f;
    private static float mainHandOffsetY = 0.0f;
    private static float offHandOffsetY = 0.0f;
    private static float mainHandOffsetZ = 0.0f;
    private static float offHandOffsetZ = 0.0f;
    private static float mainHandRotationX = 0.0f;
    private static float offHandRotationX = 0.0f;
    private static float mainHandRotationY = 0.0f;
    private static float offHandRotationY = 0.0f;
    private static float mainHandRotationZ = 0.0f;
    private static float offHandRotationZ = 0.0f;
    private static float mainHandScaleX = 1.0f;
    private static float mainHandScaleY = 1.0f;
    private static float mainHandScaleZ = 1.0f;
    private static float offHandScaleX = 1.0f;
    private static float offHandScaleY = 1.0f;
    private static float offHandScaleZ = 1.0f;
    private static boolean debugMode = false;

    private static void loadConfig() {
        Properties props = new Properties();
        try {
            File configFile = new File(CONFIG_PATH);
            if (configFile.exists()) {
                props.load(Files.newInputStream(Paths.get(CONFIG_PATH, new String[0]), new OpenOption[0]));
                enabled = Boolean.parseBoolean(props.getProperty("enabled", "true"));
                mainHandOffsetX = Float.parseFloat(props.getProperty("mainHandOffsetX", "0.1"));
                offHandOffsetX = Float.parseFloat(props.getProperty("offHandOffsetX", "0.7"));
                mainHandOffsetY = Float.parseFloat(props.getProperty("mainHandOffsetY", "0.0"));
                offHandOffsetY = Float.parseFloat(props.getProperty("offHandOffsetY", "0.0"));
                mainHandOffsetZ = Float.parseFloat(props.getProperty("mainHandOffsetZ", "0.0"));
                offHandOffsetZ = Float.parseFloat(props.getProperty("offHandOffsetZ", "0.0"));
                mainHandRotationX = Float.parseFloat(props.getProperty("mainHandRotationX", "0.0"));
                offHandRotationX = Float.parseFloat(props.getProperty("offHandRotationX", "0.0"));
                mainHandRotationY = Float.parseFloat(props.getProperty("mainHandRotationY", "0.0"));
                offHandRotationY = Float.parseFloat(props.getProperty("offHandRotationY", "0.0"));
                mainHandRotationZ = Float.parseFloat(props.getProperty("mainHandRotationZ", "0.0"));
                offHandRotationZ = Float.parseFloat(props.getProperty("offHandRotationZ", "0.0"));
                mainHandScaleX = Float.parseFloat(props.getProperty("mainHandScaleX", "1.0"));
                mainHandScaleY = Float.parseFloat(props.getProperty("mainHandScaleY", "1.0"));
                mainHandScaleZ = Float.parseFloat(props.getProperty("mainHandScaleZ", "1.0"));
                offHandScaleX = Float.parseFloat(props.getProperty("offHandScaleX", "1.0"));
                offHandScaleY = Float.parseFloat(props.getProperty("offHandScaleY", "1.0"));
                offHandScaleZ = Float.parseFloat(props.getProperty("offHandScaleZ", "1.0"));
                debugMode = Boolean.parseBoolean(props.getProperty("debugMode", "false"));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error loading config", (Throwable)e);
        }
    }

    private static void saveConfig() {
        Properties props = new Properties();
        props.setProperty("enabled", String.valueOf(enabled));
        props.setProperty("mainHandOffsetX", String.valueOf(mainHandOffsetX));
        props.setProperty("offHandOffsetX", String.valueOf(offHandOffsetX));
        props.setProperty("mainHandOffsetY", String.valueOf(mainHandOffsetY));
        props.setProperty("offHandOffsetY", String.valueOf(offHandOffsetY));
        props.setProperty("mainHandOffsetZ", String.valueOf(mainHandOffsetZ));
        props.setProperty("offHandOffsetZ", String.valueOf(offHandOffsetZ));
        props.setProperty("mainHandRotationX", String.valueOf(mainHandRotationX));
        props.setProperty("offHandRotationX", String.valueOf(offHandRotationX));
        props.setProperty("mainHandRotationY", String.valueOf(mainHandRotationY));
        props.setProperty("offHandRotationY", String.valueOf(offHandRotationY));
        props.setProperty("mainHandRotationZ", String.valueOf(mainHandRotationZ));
        props.setProperty("offHandRotationZ", String.valueOf(offHandRotationZ));
        props.setProperty("mainHandScaleX", String.valueOf(mainHandScaleX));
        props.setProperty("mainHandScaleY", String.valueOf(mainHandScaleY));
        props.setProperty("mainHandScaleZ", String.valueOf(mainHandScaleZ));
        props.setProperty("offHandScaleX", String.valueOf(offHandScaleX));
        props.setProperty("offHandScaleY", String.valueOf(offHandScaleY));
        props.setProperty("offHandScaleZ", String.valueOf(offHandScaleZ));
        props.setProperty("debugMode", String.valueOf(debugMode));
        try {
            new File("config").mkdirs();
            props.store(Files.newOutputStream(Paths.get(CONFIG_PATH, new String[0]), new OpenOption[0]), "Left Hand Trick Configuration");
        }
        catch (IOException e) {
            LOGGER.error("Error saving config", (Throwable)e);
        }
    }

    private static int toggleDebug(CommandContext<FabricClientCommandSource> context) {
        debugMode = !debugMode;
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Debug Mode " + (debugMode ? "Enabled" : "Disabled"))));
        if (debugMode) {
            LOGGER.info("Main Hand Offset: X=" + mainHandOffsetX + " Y=" + mainHandOffsetY + " Z=" + mainHandOffsetZ);
            LOGGER.info("Off Hand Offset: X=" + offHandOffsetX + " Y=" + offHandOffsetY + " Z=" + offHandOffsetZ);
        }
        return 1;
    }

    private static int supportInfo(CommandContext<FabricClientCommandSource> context) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76=================================="));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76Left Hand Trick - Support"));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76=================================="));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)""));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7bDiscord: \u00a7nhttps://discord.gg/dJRSNSSHQP"));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)""));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76=================================="));
        return 1;
    }

    private static int resetConfig(CommandContext<FabricClientCommandSource> context) {
        mainHandOffsetX = 0.1f;
        offHandOffsetX = 0.1f;
        mainHandOffsetY = 0.0f;
        offHandOffsetY = 0.0f;
        mainHandOffsetZ = 0.0f;
        offHandOffsetZ = 0.0f;
        mainHandRotationX = 0.0f;
        mainHandRotationY = 0.0f;
        mainHandRotationZ = 0.0f;
        offHandRotationX = 0.0f;
        offHandRotationY = 0.0f;
        offHandRotationZ = 0.0f;
        mainHandScaleX = 1.0f;
        mainHandScaleY = 1.0f;
        mainHandScaleZ = 1.0f;
        offHandScaleX = 1.0f;
        offHandScaleY = 1.0f;
        offHandScaleZ = 1.0f;
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7aConfiguration reset to defaults!"));
        return 1;
    }

    private static int statusConfig(CommandContext<FabricClientCommandSource> context) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76=== Left Hand Trick Status ==="));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7bEnabled: " + (enabled ? "\u00a7aYes" : "\u00a7cNo"))));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7bDebug Mode: " + (debugMode ? "\u00a7aYes" : "\u00a7cNo"))));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77--- Main Hand ---"));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7bOffset: X=" + String.format("%.2f", Float.valueOf(mainHandOffsetX)) + " Y=" + String.format("%.2f", Float.valueOf(mainHandOffsetY)) + " Z=" + String.format("%.2f", Float.valueOf(mainHandOffsetZ)))));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7bRotation: X=" + String.format("%.2f", Float.valueOf(mainHandRotationX)) + " Y=" + String.format("%.2f", Float.valueOf(mainHandRotationY)) + " Z=" + String.format("%.2f", Float.valueOf(mainHandRotationZ)))));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7bScale: X=" + String.format("%.2f", Float.valueOf(mainHandScaleX)) + " Y=" + String.format("%.2f", Float.valueOf(mainHandScaleY)) + " Z=" + String.format("%.2f", Float.valueOf(mainHandScaleZ)))));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77--- Off Hand ---"));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7bOffset: X=" + String.format("%.2f", Float.valueOf(offHandOffsetX)) + " Y=" + String.format("%.2f", Float.valueOf(offHandOffsetY)) + " Z=" + String.format("%.2f", Float.valueOf(offHandOffsetZ)))));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7bRotation: X=" + String.format("%.2f", Float.valueOf(offHandRotationX)) + " Y=" + String.format("%.2f", Float.valueOf(offHandRotationY)) + " Z=" + String.format("%.2f", Float.valueOf(offHandRotationZ)))));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7bScale: X=" + String.format("%.2f", Float.valueOf(offHandScaleX)) + " Y=" + String.format("%.2f", Float.valueOf(offHandScaleY)) + " Z=" + String.format("%.2f", Float.valueOf(offHandScaleZ)))));
        return 1;
    }

    private static int setMainHandOffsetX(CommandContext<FabricClientCommandSource> context) {
        float value;
        mainHandOffsetX = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aMain Hand X Offset set to: " + String.format("%.2f", Float.valueOf(mainHandOffsetX)))));
        if (debugMode) {
            LOGGER.info("Main Hand X Offset: " + mainHandOffsetX);
        }
        return 1;
    }

    private static int setOffHandOffsetX(CommandContext<FabricClientCommandSource> context) {
        float value;
        offHandOffsetX = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aOff Hand X Offset set to: " + String.format("%.2f", Float.valueOf(offHandOffsetX)))));
        if (debugMode) {
            LOGGER.info("Off Hand X Offset: " + offHandOffsetX);
        }
        return 1;
    }

    private static int setMainHandOffsetY(CommandContext<FabricClientCommandSource> context) {
        float value;
        mainHandOffsetY = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aMain Hand Y Offset set to: " + String.format("%.2f", Float.valueOf(mainHandOffsetY)))));
        if (debugMode) {
            LOGGER.info("Main Hand Y Offset: " + mainHandOffsetY);
        }
        return 1;
    }

    private static int setOffHandOffsetY(CommandContext<FabricClientCommandSource> context) {
        float value;
        offHandOffsetY = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aOff Hand Y Offset set to: " + String.format("%.2f", Float.valueOf(offHandOffsetY)))));
        if (debugMode) {
            LOGGER.info("Off Hand Y Offset: " + offHandOffsetY);
        }
        return 1;
    }

    private static int setMainHandOffsetZ(CommandContext<FabricClientCommandSource> context) {
        float value;
        mainHandOffsetZ = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aMain Hand Z Offset set to: " + String.format("%.2f", Float.valueOf(mainHandOffsetZ)))));
        if (debugMode) {
            LOGGER.info("Main Hand Z Offset: " + mainHandOffsetZ);
        }
        return 1;
    }

    private static int setOffHandOffsetZ(CommandContext<FabricClientCommandSource> context) {
        float value;
        offHandOffsetZ = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aOff Hand Z Offset set to: " + String.format("%.2f", Float.valueOf(offHandOffsetZ)))));
        if (debugMode) {
            LOGGER.info("Off Hand Z Offset: " + offHandOffsetZ);
        }
        return 1;
    }

    private static int setMainHandRotationX(CommandContext<FabricClientCommandSource> context) {
        float value;
        mainHandRotationX = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aMain Hand X Rotation set to: " + String.format("%.2f", Float.valueOf(mainHandRotationX)))));
        if (debugMode) {
            LOGGER.info("Main Hand X Rotation: " + mainHandRotationX);
        }
        return 1;
    }

    private static int setOffHandRotationX(CommandContext<FabricClientCommandSource> context) {
        float value;
        offHandRotationX = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aOff Hand X Rotation set to: " + String.format("%.2f", Float.valueOf(offHandRotationX)))));
        if (debugMode) {
            LOGGER.info("Off Hand X Rotation: " + offHandRotationX);
        }
        return 1;
    }

    private static int setMainHandRotationY(CommandContext<FabricClientCommandSource> context) {
        float value;
        mainHandRotationY = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aMain Hand Y Rotation set to: " + String.format("%.2f", Float.valueOf(mainHandRotationY)))));
        if (debugMode) {
            LOGGER.info("Main Hand Y Rotation: " + mainHandRotationY);
        }
        return 1;
    }

    private static int setOffHandRotationY(CommandContext<FabricClientCommandSource> context) {
        float value;
        offHandRotationY = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aOff Hand Y Rotation set to: " + String.format("%.2f", Float.valueOf(offHandRotationY)))));
        if (debugMode) {
            LOGGER.info("Off Hand Y Rotation: " + offHandRotationY);
        }
        return 1;
    }

    private static int setMainHandRotationZ(CommandContext<FabricClientCommandSource> context) {
        float value;
        mainHandRotationZ = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aMain Hand Z Rotation set to: " + String.format("%.2f", Float.valueOf(mainHandRotationZ)))));
        if (debugMode) {
            LOGGER.info("Main Hand Z Rotation: " + mainHandRotationZ);
        }
        return 1;
    }

    private static int setOffHandRotationZ(CommandContext<FabricClientCommandSource> context) {
        float value;
        offHandRotationZ = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aOff Hand Z Rotation set to: " + String.format("%.2f", Float.valueOf(offHandRotationZ)))));
        if (debugMode) {
            LOGGER.info("Off Hand Z Rotation: " + offHandRotationZ);
        }
        return 1;
    }

    private static int setMainHandScaleX(CommandContext<FabricClientCommandSource> context) {
        float value;
        mainHandScaleX = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aMain Hand Scale X set to: " + String.format("%.2f", Float.valueOf(value)))));
        if (debugMode) {
            LOGGER.info("Main Hand Scale X: " + value);
        }
        return 1;
    }

    private static int setMainHandScaleY(CommandContext<FabricClientCommandSource> context) {
        float value;
        mainHandScaleY = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aMain Hand Scale Y set to: " + String.format("%.2f", Float.valueOf(value)))));
        if (debugMode) {
            LOGGER.info("Main Hand Scale Y: " + value);
        }
        return 1;
    }

    private static int setMainHandScaleZ(CommandContext<FabricClientCommandSource> context) {
        float value;
        mainHandScaleZ = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aMain Hand Scale Z set to: " + String.format("%.2f", Float.valueOf(value)))));
        if (debugMode) {
            LOGGER.info("Main Hand Scale Z: " + value);
        }
        return 1;
    }

    private static int setMainHandScaleAll(CommandContext<FabricClientCommandSource> context) {
        float value;
        mainHandScaleX = value = FloatArgumentType.getFloat(context, (String)"value");
        mainHandScaleY = value;
        mainHandScaleZ = value;
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aMain Hand Scale (All) set to: " + String.format("%.2f", Float.valueOf(value)))));
        if (debugMode) {
            LOGGER.info("Main Hand Scale All: " + value);
        }
        return 1;
    }

    private static int setOffHandScaleX(CommandContext<FabricClientCommandSource> context) {
        float value;
        offHandScaleX = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aOff Hand Scale X set to: " + String.format("%.2f", Float.valueOf(value)))));
        if (debugMode) {
            LOGGER.info("Off Hand Scale X: " + value);
        }
        return 1;
    }

    private static int setOffHandScaleY(CommandContext<FabricClientCommandSource> context) {
        float value;
        offHandScaleY = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aOff Hand Scale Y set to: " + String.format("%.2f", Float.valueOf(value)))));
        if (debugMode) {
            LOGGER.info("Off Hand Scale Y: " + value);
        }
        return 1;
    }

    private static int setOffHandScaleZ(CommandContext<FabricClientCommandSource> context) {
        float value;
        offHandScaleZ = value = FloatArgumentType.getFloat(context, (String)"value");
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aOff Hand Scale Z set to: " + String.format("%.2f", Float.valueOf(value)))));
        if (debugMode) {
            LOGGER.info("Off Hand Scale Z: " + value);
        }
        return 1;
    }

    private static int setOffHandScaleAll(CommandContext<FabricClientCommandSource> context) {
        float value;
        offHandScaleX = value = FloatArgumentType.getFloat(context, (String)"value");
        offHandScaleY = value;
        offHandScaleZ = value;
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aOff Hand Scale (All) set to: " + String.format("%.2f", Float.valueOf(value)))));
        if (debugMode) {
            LOGGER.info("Off Hand Scale All: " + value);
        }
        return 1;
    }

    private static int toggleMod(CommandContext<FabricClientCommandSource> context) {
        enabled = !enabled;
        HeldItemRendererMixin.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a76Left Hand Trick " + (enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))));
        return 1;
    }

    private boolean shouldModify() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        return enabled;
    }

    @ModifyVariable(method={"method_3224(Lnet/minecraft/class_4587;Lnet/minecraft/class_1306;F)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private class_1306 swapArmsEquip(class_1306 arm) {
        if (this.shouldModify()) {
            return arm == class_1306.field_6182 ? class_1306.field_6183 : class_1306.field_6182;
        }
        return arm;
    }

    @ModifyVariable(method={"method_3217(Lnet/minecraft/class_4587;Lnet/minecraft/class_1306;F)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private class_1306 swapArmsSwing(class_1306 arm) {
        if (this.shouldModify()) {
            return arm == class_1306.field_6182 ? class_1306.field_6183 : class_1306.field_6182;
        }
        return arm;
    }

    @ModifyVariable(method={"method_3219(Lnet/minecraft/class_4587;Lnet/minecraft/class_11659;IFFLnet/minecraft/class_1306;)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private class_1306 swapArmsRender(class_1306 arm) {
        if (this.shouldModify()) {
            return arm == class_1306.field_6182 ? class_1306.field_6183 : class_1306.field_6182;
        }
        return arm;
    }

    @Inject(method={"method_3224(Lnet/minecraft/class_4587;Lnet/minecraft/class_1306;F)V"}, at={@At(value="TAIL")})
    private void adjustPosition(class_4587 matrices, class_1306 arm, float equipProgress, CallbackInfo ci) {
        if (this.shouldModify()) {
            if (arm == class_1306.field_6183) {
                matrices.method_46416(mainHandOffsetX, mainHandOffsetY, mainHandOffsetZ);
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(mainHandRotationX));
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(mainHandRotationY));
                matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(mainHandRotationZ));
                matrices.method_22905(mainHandScaleX, mainHandScaleY, mainHandScaleZ);
            } else if (arm == class_1306.field_6182) {
                matrices.method_46416(-offHandOffsetX, offHandOffsetY, offHandOffsetZ);
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(offHandRotationX));
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(offHandRotationY));
                matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(offHandRotationZ));
                matrices.method_22905(offHandScaleX, offHandScaleY, offHandScaleZ);
            }
        }
    }

    @Inject(method={"method_3217(Lnet/minecraft/class_4587;Lnet/minecraft/class_1306;F)V"}, at={@At(value="TAIL")})
    private void adjustSwing(class_4587 matrices, class_1306 arm, float swingProgress, CallbackInfo ci) {
        if (this.shouldModify()) {
            if (arm == class_1306.field_6183) {
                matrices.method_46416(mainHandOffsetX, mainHandOffsetY, mainHandOffsetZ);
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(mainHandRotationX));
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(mainHandRotationY));
                matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(mainHandRotationZ));
                matrices.method_22905(mainHandScaleX, mainHandScaleY, mainHandScaleZ);
            } else if (arm == class_1306.field_6182) {
                matrices.method_46416(-offHandOffsetX, offHandOffsetY, offHandOffsetZ);
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(offHandRotationX));
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(offHandRotationY));
                matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(offHandRotationZ));
                matrices.method_22905(offHandScaleX, offHandScaleY, offHandScaleZ);
            }
        }
    }

    static {
        HeldItemRendererMixin.loadConfig();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> {
            LiteralArgumentBuilder commandNode = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lefthandtrick").then(ClientCommandManager.literal((String)"toggle").executes(HeldItemRendererMixin::toggleMod))).then(ClientCommandManager.literal((String)"debug").executes(HeldItemRendererMixin::toggleDebug))).then(ClientCommandManager.literal((String)"reset").executes(HeldItemRendererMixin::resetConfig))).then(ClientCommandManager.literal((String)"status").executes(HeldItemRendererMixin::statusConfig))).then(ClientCommandManager.literal((String)"support").executes(HeldItemRendererMixin::supportInfo))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"offsetx").then(ClientCommandManager.literal((String)"mainhand").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(HeldItemRendererMixin::setMainHandOffsetX)))).then(ClientCommandManager.literal((String)"offhand").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(HeldItemRendererMixin::setOffHandOffsetX))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"offsety").then(ClientCommandManager.literal((String)"mainhand").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(HeldItemRendererMixin::setMainHandOffsetY)))).then(ClientCommandManager.literal((String)"offhand").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(HeldItemRendererMixin::setOffHandOffsetY))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"offsetz").then(ClientCommandManager.literal((String)"mainhand").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(HeldItemRendererMixin::setMainHandOffsetZ)))).then(ClientCommandManager.literal((String)"offhand").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(HeldItemRendererMixin::setOffHandOffsetZ))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"rotationx").then(ClientCommandManager.literal((String)"mainhand").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(HeldItemRendererMixin::setMainHandRotationX)))).then(ClientCommandManager.literal((String)"offhand").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(HeldItemRendererMixin::setOffHandRotationX))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"rotationy").then(ClientCommandManager.literal((String)"mainhand").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(HeldItemRendererMixin::setMainHandRotationY)))).then(ClientCommandManager.literal((String)"offhand").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(HeldItemRendererMixin::setOffHandRotationY))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"rotationz").then(ClientCommandManager.literal((String)"mainhand").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(HeldItemRendererMixin::setMainHandRotationZ)))).then(ClientCommandManager.literal((String)"offhand").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(HeldItemRendererMixin::setOffHandRotationZ))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"scale").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mainhand").then(ClientCommandManager.literal((String)"x").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)5.0f)).executes(HeldItemRendererMixin::setMainHandScaleX)))).then(ClientCommandManager.literal((String)"y").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)5.0f)).executes(HeldItemRendererMixin::setMainHandScaleY)))).then(ClientCommandManager.literal((String)"z").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)5.0f)).executes(HeldItemRendererMixin::setMainHandScaleZ)))).then(ClientCommandManager.literal((String)"all").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)5.0f)).executes(HeldItemRendererMixin::setMainHandScaleAll))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"offhand").then(ClientCommandManager.literal((String)"x").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)5.0f)).executes(HeldItemRendererMixin::setOffHandScaleX)))).then(ClientCommandManager.literal((String)"y").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)5.0f)).executes(HeldItemRendererMixin::setOffHandScaleY)))).then(ClientCommandManager.literal((String)"z").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)5.0f)).executes(HeldItemRendererMixin::setOffHandScaleZ)))).then(ClientCommandManager.literal((String)"all").then(ClientCommandManager.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)5.0f)).executes(HeldItemRendererMixin::setOffHandScaleAll)))));
            dispatcher.register(commandNode);
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lht").redirect((CommandNode)commandNode.build()));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lth").redirect((CommandNode)commandNode.build()));
        });
    }
}

