/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.block;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import net.minecraft.class_3542;
import net.sandius.rembulan.Conversions;
import org.jetbrains.annotations.Nullable;

public class BlockPropertyConverter {
    public static Object toLua(Comparable<?> obj) {
        if (obj instanceof class_3542) {
            class_3542 s = (class_3542)obj;
            return s.method_15434();
        }
        if (obj instanceof Enum) {
            Enum e = (Enum)((Object)obj);
            return e.name();
        }
        if (obj instanceof String) {
            String str = (String)((Object)obj);
            if ("true".equals(obj)) {
                return true;
            }
            if ("false".equals(obj)) {
                return false;
            }
            Number result = Ints.tryParse((String)str);
            if (result != null) {
                return result;
            }
            result = Doubles.tryParse((String)str);
            if (result != null) {
                return result;
            }
        }
        return Conversions.canonicalRepresentationOf(obj);
    }

    @Nullable
    public static <T extends Comparable<T>> T toJava(Class<T> valueClass, @Nullable Object luaValue) {
        if (luaValue == null) {
            return null;
        }
        if (valueClass.equals(Boolean.class)) {
            if (luaValue == Boolean.TRUE) {
                return (T)Boolean.TRUE;
            }
            if (luaValue == Boolean.FALSE) {
                return (T)Boolean.FALSE;
            }
            throw new IllegalArgumentException(String.format("Unexpected value '%s' for valueClass %s", luaValue, valueClass));
        }
        if (class_3542.class.isAssignableFrom(valueClass)) {
            if (Enum.class.isAssignableFrom(valueClass)) {
                Enum[] values;
                String enumValueName = String.valueOf(luaValue);
                Class<T> eClass = valueClass;
                for (Enum value : values = (Enum[])eClass.getEnumConstants()) {
                    class_3542 sObj = (class_3542)value;
                    if (!sObj.method_15434().equals(enumValueName)) continue;
                    return (T)value;
                }
                throw new IllegalArgumentException(String.format("Unexpected name '%s' for element of valueClass %s", enumValueName, valueClass));
            }
            throw new IllegalArgumentException(String.format("Unexpected valueClass %s", valueClass));
        }
        if (Enum.class.isAssignableFrom(valueClass)) {
            Enum[] values;
            String enumValueName = String.valueOf(luaValue);
            Class<T> eClass = valueClass;
            for (Enum value : values = (Enum[])eClass.getEnumConstants()) {
                if (!value.name().equals(enumValueName)) continue;
                return (T)value;
            }
            throw new IllegalArgumentException(String.format("Unexpected name '%s' for element of valueClass %s", enumValueName, valueClass));
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            Number num = Conversions.numericalValueOf((Object)luaValue);
            if (valueClass.equals(Integer.class)) {
                return (T)Integer.valueOf(num.intValue());
            }
            if (valueClass.equals(Double.class)) {
                return (T)Double.valueOf(num.doubleValue());
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected valueClass %s", valueClass));
    }
}

