/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.chunk;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.wizardsoflua.chunk.ChunkForce;
import net.wizardsoflua.chunk.Ticket;

public class ChunkForceManager {
    private final Map<class_1937, WorldManager> managers = new HashMap<class_1937, WorldManager>();

    public void forceChunk(Ticket ticket, class_1923 chunkPos) {
        WorldManager m = this.getManager(ticket.getWorld());
        ChunkForce chunkForce = m.getChunkForce(chunkPos);
        if (chunkForce.add(ticket)) {
            ticket.add(chunkForce);
        }
    }

    public void unforceChunk(Ticket ticket, class_1923 chunkPos) {
        WorldManager m = this.getManager(ticket.getWorld());
        ChunkForce chunkForce = m.getChunkForce(chunkPos);
        if (chunkForce.remove(ticket)) {
            ticket.remove(chunkForce);
        }
    }

    private WorldManager getManager(class_3218 world) {
        return this.managers.computeIfAbsent((class_1937)world, key -> new WorldManager(this, world));
    }

    private class WorldManager {
        private final class_3218 world;
        private final Map<class_1923, ChunkForce> chunkForces = new HashMap<class_1923, ChunkForce>();

        public WorldManager(ChunkForceManager chunkForceManager, class_3218 world) {
            this.world = (class_3218)Preconditions.checkNotNull((Object)world, (Object)"world == null!");
        }

        public ChunkForce getChunkForce(class_1923 chunkPos) {
            return this.chunkForces.computeIfAbsent(chunkPos, key -> new ChunkForce(this.world, chunkPos));
        }
    }
}

