/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.event;

import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.wizardsoflua.event.AfterLivingEntityDamageEvent;
import net.wizardsoflua.event.AfterLivingEntityDeathEvent;
import net.wizardsoflua.event.AfterPlayerBlockBreakEvent;
import net.wizardsoflua.event.AfterPlayerRespawnEvent;
import net.wizardsoflua.event.BeforeLivingEntityDamageEvent;
import net.wizardsoflua.event.BeforeLivingEntityDeathEvent;
import net.wizardsoflua.event.BeforePlayerBlockBreakEvent;
import net.wizardsoflua.event.ChatMessageEvent;
import net.wizardsoflua.event.ChunkLoadEvent;
import net.wizardsoflua.event.ChunkUnloadEvent;
import net.wizardsoflua.event.EntityDespawnEvent;
import net.wizardsoflua.event.EntitySpawnEvent;
import net.wizardsoflua.event.EventHandlerType;
import net.wizardsoflua.event.HandSwingCallback;
import net.wizardsoflua.event.PermissionCheckEvent;
import net.wizardsoflua.event.PlayerAttackBlockEvent;
import net.wizardsoflua.event.PlayerAttackEntityEvent;
import net.wizardsoflua.event.PlayerChangeWorldEvent;
import net.wizardsoflua.event.PlayerDisconnectedEvent;
import net.wizardsoflua.event.PlayerDropItemCallback;
import net.wizardsoflua.event.PlayerDropItemEvent;
import net.wizardsoflua.event.PlayerDropSelectedItemCallback;
import net.wizardsoflua.event.PlayerDropSelectedItemEvent;
import net.wizardsoflua.event.PlayerHandSwingEvent;
import net.wizardsoflua.event.PlayerJoinedEvent;
import net.wizardsoflua.event.PlayerUseBlockEvent;
import net.wizardsoflua.event.PlayerUseEntityEvent;
import net.wizardsoflua.event.PlayerUseItemEvent;
import net.wizardsoflua.event.SpellFinishCallback;
import net.wizardsoflua.event.SpellFinishEvent;
import net.wizardsoflua.event.WolEvent;
import net.wizardsoflua.spell.Spell;
import net.wizardsoflua.spell.SpellRegistry;
import net.wizardsoflua.spell.SpellServerCommandSource;
import net.wizardsoflua.world.WorldChunkTracker;

public class WolEventHandler {
    private final SpellRegistry spellRegistry;
    private final WorldChunkTracker worldChunkTracker;

    public WolEventHandler(SpellRegistry spellRegistry, WorldChunkTracker worldChunkTracker) {
        this.spellRegistry = spellRegistry;
        this.worldChunkTracker = worldChunkTracker;
    }

    public void register() {
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, sender, params) -> this.forwardEventToInterceptors(new ChatMessageEvent(sender, message.method_46291())));
        ServerMessageEvents.CHAT_MESSAGE.register((message, sender, params) -> this.forwardEventToCollectors(new ChatMessageEvent(sender, message.method_46291())));
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            if (!world.method_8608()) {
                boolean result = this.forwardEvent(new BeforePlayerBlockBreakEvent((class_3218)world, player, pos, state, blockEntity));
                return result;
            }
            return true;
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (!world.method_8608()) {
                this.forwardEvent(new AfterPlayerBlockBreakEvent((class_3218)world, player, pos, state, blockEntity));
            }
        });
        UseItemCallback.EVENT.register((Object)new UseItemCallback(){

            public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand) {
                class_1799 itemStack;
                boolean proceed;
                if (!world.method_8608() && !(proceed = WolEventHandler.this.forwardEvent(new PlayerUseItemEvent(player, (class_3218)world, hand, itemStack = player.method_5998(hand))))) {
                    return class_1269.field_5814;
                }
                return class_1269.field_5811;
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> this.forwardEvent(new AfterPlayerRespawnEvent(oldPlayer, newPlayer, alive)));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> this.forwardEvent(new PlayerJoinedEvent(handler.method_32311())));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> this.forwardEvent(new PlayerDisconnectedEvent(handler.method_32311())));
        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, damageSource, damageAmount) -> this.forwardEvent(new BeforeLivingEntityDeathEvent(entity, damageSource, damageAmount)));
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> this.forwardEvent(new AfterLivingEntityDeathEvent(entity, damageSource)));
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_3218 serverWorld;
            boolean proceed;
            if (world instanceof class_3218 && !(proceed = this.forwardEvent(new PlayerUseBlockEvent((class_3222)player, serverWorld = (class_3218)world, hand, hitResult)))) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_3218 serverWorld;
            boolean proceed;
            if (world instanceof class_3218 && !(proceed = this.forwardEvent(new PlayerAttackEntityEvent((class_3222)player, serverWorld = (class_3218)world, hand, entity)))) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        me.lucko.fabric.api.permissions.v0.PermissionCheckEvent.EVENT.register((source, permission) -> {
            class_3218 world = null;
            class_1297 entity = null;
            Spell spell = null;
            AtomicReference<Object> allowed = new AtomicReference<Object>(null);
            if (source instanceof class_2168) {
                class_2168 scs = (class_2168)source;
                world = scs.method_9225();
                entity = scs.method_9228();
                spell = null;
                if (source instanceof SpellServerCommandSource) {
                    SpellServerCommandSource sscs = (SpellServerCommandSource)source;
                    spell = sscs.getSpell();
                    entity = spell.getOwner();
                }
            }
            this.forwardEvent(new PermissionCheckEvent(permission, world, entity, spell, allowed));
            TriState result = TriState.of((Boolean)allowed.get());
            return result;
        });
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            class_1923 pos = chunk.method_12004();
            this.worldChunkTracker.add((class_1937)world, chunk.method_12004());
            this.forwardEvent(new ChunkLoadEvent(world, pos.field_9181, pos.field_9180));
        });
        ServerChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            class_1923 pos = chunk.method_12004();
            this.forwardEvent(new ChunkUnloadEvent(world, pos.field_9181, pos.field_9180));
            this.worldChunkTracker.remove((class_1937)world, chunk.method_12004());
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> this.worldChunkTracker.remove(world));
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> this.worldChunkTracker.clear());
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.forwardEvent(new EntitySpawnEvent(entity)));
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> this.forwardEvent(new EntityDespawnEvent(entity)));
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> this.forwardEvent(new PlayerChangeWorldEvent(player, origin, destination)));
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, damageSource, damageAmount) -> this.forwardEvent(new BeforeLivingEntityDamageEvent(entity, damageSource, damageAmount)));
        ServerLivingEntityEvents.AFTER_DAMAGE.register((entity, source, baseDamageTaken, damageTaken, blocked) -> this.forwardEvent(new AfterLivingEntityDamageEvent(entity, source, baseDamageTaken, damageTaken, blocked)));
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            class_2680 blockState;
            boolean proceed;
            if (!world.method_8608() && !(proceed = this.forwardEvent(new PlayerAttackBlockEvent((class_3222)player, (class_3218)world, blockState = world.method_8320(pos), hand, pos, direction)))) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            boolean proceed;
            if (!world.method_8608() && !(proceed = this.forwardEvent(new PlayerUseEntityEvent((class_3222)player, (class_3218)world, hand, entity, hitResult)))) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        HandSwingCallback.EVENT.register((player, hand) -> this.forwardEvent(new PlayerHandSwingEvent(player, hand)));
        PlayerDropItemCallback.EVENT.register((player, itemEntity) -> this.forwardEvent(new PlayerDropItemEvent(player, itemEntity)));
        PlayerDropSelectedItemCallback.EVENT.register((player, itemStack, entireStack) -> this.forwardEvent(new PlayerDropSelectedItemEvent(player, itemStack, entireStack)));
        SpellFinishCallback.EVENT.register(spell -> this.forwardEvent(new SpellFinishEvent(spell)));
    }

    private boolean forwardEvent(WolEvent event) {
        String eventName = event.getClass().getSimpleName();
        return this.spellRegistry.forwardEvent(eventName, event, EventHandlerType.BOTH);
    }

    private boolean forwardEventToInterceptors(WolEvent event) {
        String eventName = event.getClass().getSimpleName();
        return this.spellRegistry.forwardEvent(eventName, event, EventHandlerType.INTERCEPTORS);
    }

    private boolean forwardEventToCollectors(WolEvent event) {
        String eventName = event.getClass().getSimpleName();
        return this.spellRegistry.forwardEvent(eventName, event, EventHandlerType.COLLECTORS);
    }
}

