/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.classes;

import com.google.common.collect.ImmutableSet;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.sandius.rembulan.runtime.Resumable;
import net.sandius.rembulan.runtime.UnresolvedControlThrowable;
import net.wizardsoflua.event.WolEvent;
import net.wizardsoflua.lua.classes.AbstractLuaClass;
import net.wizardsoflua.lua.classes.AbstractLuaInstance;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.module.event.EventQueue;
import net.wizardsoflua.spell.SpellScope;

public class LuaEventQueue<J extends EventQueue, LC extends AbstractLuaClass<?, ?>>
extends AbstractLuaInstance<J, LC> {
    public LuaEventQueue(LC luaClass, J javaInstance) {
        super(luaClass, javaInstance, true);
        this.addReadOnly("names", this::getNames);
        this.addReadOnly("empty", this::isEmpty);
    }

    private Object getNames() {
        ImmutableSet<String> result = ((EventQueue)this.getDelegate()).getNames();
        return this.getConverters().toLuaNullable(result);
    }

    private Object isEmpty() {
        return this.getConverters().toLua(((EventQueue)this.getDelegate()).isEmpty());
    }

    public static class Class
    extends AbstractLuaClass<EventQueue, LuaEventQueue<EventQueue, Class>> {
        public Class(SpellScope spellScope) {
            super("EventQueue", spellScope, null);
            this.addFunction(new StopFunction());
            this.addFunction(new LatestFunction());
            this.addFunction(new NextFunction());
        }

        @Override
        protected final LuaEventQueue<EventQueue, Class> createNewLuaInstance(EventQueue javaInstance) {
            return new LuaEventQueue<EventQueue, Class>(this, javaInstance);
        }

        private class StopFunction
        extends NamedFunction1 {
            private StopFunction() {
            }

            @Override
            public String getName() {
                return "stop";
            }

            public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
                EventQueue self = Class.this.getConverters().toJava(EventQueue.class, arg1, 1, "self", this.getName());
                self.stop();
                context.getReturnBuffer().setTo();
            }
        }

        private class LatestFunction
        extends NamedFunction1 {
            private LatestFunction() {
            }

            @Override
            public String getName() {
                return "latest";
            }

            public void invoke(ExecutionContext context, Object arg1) throws ResolvedControlThrowable {
                EventQueue self = Class.this.getConverters().toJava(EventQueue.class, arg1, 1, "self", this.getName());
                WolEvent result = self.latest();
                Object luaResult = Class.this.getConverters().toLuaNullable(result);
                context.getReturnBuffer().setTo(luaResult);
            }
        }

        private class NextFunction
        extends NamedFunction2 {
            private NextFunction() {
            }

            @Override
            public String getName() {
                return "next";
            }

            public void invoke(ExecutionContext context, Object arg1, Object arg2) throws ResolvedControlThrowable {
                EventQueue self = Class.this.getConverters().toJava(EventQueue.class, arg1, 1, "self", this.getName());
                Long timeout = Class.this.getConverters().toJavaNullable(Long.class, arg2, 2, "timeout", this.getName());
                self.setTimeout(timeout);
                this.execute(context, self);
            }

            @Override
            public void resume(ExecutionContext context, Object suspendedState) throws ResolvedControlThrowable {
                EventQueue eventQueue = (EventQueue)suspendedState;
                this.execute(context, eventQueue);
            }

            private void execute(ExecutionContext context, EventQueue eventQueue) throws ResolvedControlThrowable {
                try {
                    eventQueue.pauseIfRequested(context);
                }
                catch (UnresolvedControlThrowable e) {
                    throw e.resolve((Resumable)this, (Object)eventQueue);
                }
                if (!eventQueue.isEmpty()) {
                    WolEvent event = eventQueue.pop();
                    Object result = Class.this.getConverters().toLua(event);
                    context.getReturnBuffer().setTo(result);
                } else {
                    context.getReturnBuffer().setTo();
                }
            }
        }
    }
}

