/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.classes;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.sandius.rembulan.LuaRuntimeException;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.filesystem.WolServerFileSystem;
import net.wizardsoflua.lua.classes.AbstractLuaClass;
import net.wizardsoflua.lua.classes.AbstractLuaInstance;
import net.wizardsoflua.lua.function.NamedFunction2;
import net.wizardsoflua.lua.function.NamedFunction3;
import net.wizardsoflua.spell.SpellScope;

public class LuaFilesystem<J extends WolServerFileSystem, LC extends AbstractLuaClass<?, ?>>
extends AbstractLuaInstance<J, LC> {
    public LuaFilesystem(LC luaClass, J javaInstance) {
        super(luaClass, javaInstance, true);
    }

    public static class Class
    extends AbstractLuaClass<WolServerFileSystem, LuaFilesystem<WolServerFileSystem, Class>> {
        public Class(SpellScope spellScope) {
            super("Filesystem", spellScope, null);
            this.addFunction(new ListFunction());
            this.addFunction(new IsDirFunction());
            this.addFunction(new IsFileFunction());
            this.addFunction(new MakeDirFunction());
            this.addFunction(new DeleteFunction());
            this.addFunction(new MoveFunction());
        }

        @Override
        protected final LuaFilesystem<WolServerFileSystem, Class> createNewLuaInstance(WolServerFileSystem javaInstance) {
            return new LuaFilesystem<WolServerFileSystem, Class>(this, javaInstance);
        }

        class ListFunction
        extends NamedFunction2 {
            ListFunction() {
            }

            @Override
            public String getName() {
                return "list";
            }

            public void invoke(ExecutionContext context, Object selfArg, Object pathArg) throws ResolvedControlThrowable {
                Path path;
                LuaFilesystem self = Class.this.getConverters().castTo(LuaFilesystem.class, selfArg, 1, "self", this.getName());
                String pathStr = Class.this.getConverters().toJavaNullable(String.class, pathArg, 2, "path", this.getName());
                WolServerFileSystem fileSystem = (WolServerFileSystem)self.getDelegate();
                Path path2 = path = pathStr == null ? fileSystem.getRootFolder() : fileSystem.getPath(pathStr, new String[0]);
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    throw new LuaRuntimeException((Object)String.format("%s is not a directory!", path));
                }
                try {
                    List<String> result = Files.list(path).map(p -> p.getFileName().toString()).sorted().toList();
                    context.getReturnBuffer().setTo(Class.this.getConverters().toLua(result));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        class IsDirFunction
        extends NamedFunction2 {
            IsDirFunction() {
            }

            @Override
            public String getName() {
                return "isDir";
            }

            public void invoke(ExecutionContext context, Object selfArg, Object pathArg) throws ResolvedControlThrowable {
                LuaFilesystem self = Class.this.getConverters().castTo(LuaFilesystem.class, selfArg, 1, "self", this.getName());
                String pathStr = Class.this.getConverters().toJava(String.class, pathArg, 2, "path", this.getName());
                WolServerFileSystem fileSystem = (WolServerFileSystem)self.getDelegate();
                Path path = fileSystem.getPath(pathStr, new String[0]);
                boolean result = Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
                context.getReturnBuffer().setTo(Class.this.getConverters().toLua(result));
            }
        }

        class IsFileFunction
        extends NamedFunction2 {
            IsFileFunction() {
            }

            @Override
            public String getName() {
                return "isFile";
            }

            public void invoke(ExecutionContext context, Object selfArg, Object pathArg) throws ResolvedControlThrowable {
                LuaFilesystem self = Class.this.getConverters().castTo(LuaFilesystem.class, selfArg, 1, "self", this.getName());
                String pathStr = Class.this.getConverters().toJava(String.class, pathArg, 2, "path", this.getName());
                WolServerFileSystem fileSystem = (WolServerFileSystem)self.getDelegate();
                Path path = fileSystem.getPath(pathStr, new String[0]);
                boolean result = Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]);
                context.getReturnBuffer().setTo(Class.this.getConverters().toLua(result));
            }
        }

        class MakeDirFunction
        extends NamedFunction2 {
            MakeDirFunction() {
            }

            @Override
            public String getName() {
                return "makeDir";
            }

            public void invoke(ExecutionContext context, Object selfArg, Object pathArg) throws ResolvedControlThrowable {
                LuaFilesystem self = Class.this.getConverters().castTo(LuaFilesystem.class, selfArg, 1, "self", this.getName());
                String pathStr = Class.this.getConverters().toJava(String.class, pathArg, 2, "path", this.getName());
                WolServerFileSystem fileSystem = (WolServerFileSystem)self.getDelegate();
                Path path = fileSystem.getPath(pathStr, new String[0]);
                if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
                    context.getReturnBuffer().setTo((Object)false);
                } else {
                    try {
                        Files.createDirectories(path, new FileAttribute[0]);
                        boolean result = Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
                        context.getReturnBuffer().setTo((Object)result);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
            }
        }

        class DeleteFunction
        extends NamedFunction2 {
            DeleteFunction() {
            }

            @Override
            public String getName() {
                return "delete";
            }

            public void invoke(ExecutionContext context, Object selfArg, Object pathArg) throws ResolvedControlThrowable {
                Path path;
                LuaFilesystem self = Class.this.getConverters().castTo(LuaFilesystem.class, selfArg, 1, "self", this.getName());
                String pathStr = Class.this.getConverters().toJava(String.class, pathArg, 2, "path", this.getName());
                WolServerFileSystem fileSystem = (WolServerFileSystem)self.getDelegate();
                if (fileSystem.isRootFolder(path = fileSystem.getPath(pathStr, new String[0]))) {
                    throw new LuaRuntimeException((Object)"Can't delete world root directory");
                }
                try {
                    boolean result = Files.deleteIfExists(path) && !Files.exists(path, new LinkOption[0]);
                    context.getReturnBuffer().setTo((Object)result);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }

        class MoveFunction
        extends NamedFunction3 {
            MoveFunction() {
            }

            @Override
            public String getName() {
                return "move";
            }

            public void invoke(ExecutionContext context, Object selfArg, Object fromPathArg, Object toPathArg) throws ResolvedControlThrowable {
                Path srcPath;
                LuaFilesystem self = Class.this.getConverters().castTo(LuaFilesystem.class, selfArg, 1, "self", this.getName());
                String source = Class.this.getConverters().toJava(String.class, fromPathArg, 2, "fromPath", this.getName());
                String destination = Class.this.getConverters().toJava(String.class, toPathArg, 3, "toPath", this.getName());
                WolServerFileSystem fileSystem = (WolServerFileSystem)self.getDelegate();
                if (fileSystem.isRootFolder(srcPath = fileSystem.getPath(source, new String[0]))) {
                    throw new LuaRuntimeException((Object)"Can't move world root directory");
                }
                if (!Files.exists(srcPath, new LinkOption[0])) {
                    throw new LuaRuntimeException((Object)String.format("%s does not exist!", srcPath));
                }
                Path destPath = fileSystem.getPath(destination, new String[0]);
                if (fileSystem.isRootFolder(destPath)) {
                    throw new LuaRuntimeException((Object)"Can't overwrite world root directory");
                }
                boolean isFile = Files.isRegularFile(srcPath, new LinkOption[0]);
                boolean isDir = Files.isDirectory(srcPath, new LinkOption[0]);
                try {
                    Path target = Files.move(srcPath, destPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    boolean result = Files.exists(target, new LinkOption[0]) && (isFile == Files.isRegularFile(target, new LinkOption[0]) || isDir == Files.isDirectory(target, new LinkOption[0]));
                    context.getReturnBuffer().setTo((Object)result);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }
    }
}

