/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.classes;

import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2168;
import net.sandius.rembulan.LuaRuntimeException;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.impl.DefaultTable;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.ResolvedControlThrowable;
import net.wizardsoflua.command.dynamic.CommandDef;
import net.wizardsoflua.extension.spell.api.resource.LuaConverters;
import net.wizardsoflua.lua.function.NamedFunction0;
import net.wizardsoflua.lua.function.NamedFunction1;
import net.wizardsoflua.lua.module.wol.LogTarget;
import net.wizardsoflua.lua.module.wol.WolModule;
import net.wizardsoflua.lua.table.DelegatingLuaTable;
import net.wizardsoflua.spell.SpellScope;

public class WolModuleLuaTable
extends DelegatingLuaTable<WolModule> {
    private final SpellScope spellScope;

    public WolModuleLuaTable(WolModule delegate, LuaConverters converters, SpellScope spellScope) {
        super(delegate, converters, true);
        this.spellScope = Objects.requireNonNull(spellScope, "spellScope");
        this.addReadOnly("version", this::getVersion);
        this.add("log", this::getLog, this::setLog);
        this.addReadOnly("global", this::getGlobal);
        this.addFunction(new SetCommandFunction());
        this.addFunction(new RemoveCommandFunction());
        this.addFunction(new ListCommandsFunction());
    }

    private Object getVersion() {
        return this.getConverters().toLuaNullable(((WolModule)this.getDelegate()).getVersion());
    }

    private Object getLog() {
        return this.getConverters().toLua(((WolModule)this.getDelegate()).getLog());
    }

    private void setLog(Object luaObject) {
        LogTarget value = this.getConverters().toJava(LogTarget.class, luaObject, "log");
        ((WolModule)this.getDelegate()).setLog(value);
    }

    private Object getGlobal() {
        return this.getConverters().toLua(((WolModule)this.getDelegate()).getGlobal());
    }

    private class SetCommandFunction
    extends NamedFunction1 {
        private SetCommandFunction() {
        }

        @Override
        public String getName() {
            return "setCommand";
        }

        public void invoke(ExecutionContext ctx, Object tableObj) throws ResolvedControlThrowable {
            Table table = WolModuleLuaTable.this.getConverters().castTo(Table.class, tableObj, 1, "command", this.getName());
            String id = WolModuleLuaTable.this.getConverters().toJava(String.class, table.rawget((Object)"id"), 1, "command.id", this.getName());
            int level = WolModuleLuaTable.this.getConverters().toJavaOptional(Integer.TYPE, table.rawget((Object)"level"), 2, "command.level", this.getName()).orElse(0);
            String pattern = WolModuleLuaTable.this.getConverters().toJava(String.class, table.rawget((Object)"pattern"), 3, "command.pattern", this.getName());
            String code = WolModuleLuaTable.this.getConverters().toJava(String.class, table.rawget((Object)"code"), 4, "command.code", this.getName());
            class_2168 src = WolModuleLuaTable.this.spellScope.getCommandSource();
            try {
                ((WolModule)WolModuleLuaTable.this.getDelegate()).getCommandManager().set(id, pattern, code, src, level);
            }
            catch (RuntimeException e) {
                throw new LuaRuntimeException((Throwable)e);
            }
            ctx.getReturnBuffer().setTo();
        }
    }

    private class RemoveCommandFunction
    extends NamedFunction1 {
        private RemoveCommandFunction() {
        }

        @Override
        public String getName() {
            return "removeCommand";
        }

        public void invoke(ExecutionContext ctx, Object idObj) throws ResolvedControlThrowable {
            String id = WolModuleLuaTable.this.getConverters().toJava(String.class, idObj, 1, "id", this.getName());
            class_2168 src = WolModuleLuaTable.this.spellScope.getCommandSource();
            boolean result = ((WolModule)WolModuleLuaTable.this.getDelegate()).getCommandManager().remove(id, src);
            ctx.getReturnBuffer().setTo((Object)result);
        }
    }

    private class ListCommandsFunction
    extends NamedFunction0 {
        private ListCommandsFunction() {
        }

        @Override
        public String getName() {
            return "listCommands";
        }

        public void invoke(ExecutionContext ctx) throws ResolvedControlThrowable {
            Map<String, CommandDef> defs = ((WolModule)WolModuleLuaTable.this.getDelegate()).getCommandManager().getAll();
            Table table = DefaultTable.factory().newTable();
            int index = 0;
            for (Map.Entry<String, CommandDef> e : defs.entrySet()) {
                Table entry = DefaultTable.factory().newTable();
                String key = e.getKey();
                entry.rawset((Object)"id", WolModuleLuaTable.this.getConverters().toLua(key));
                entry.rawset((Object)"level", WolModuleLuaTable.this.getConverters().toLua(e.getValue().getLevel()));
                entry.rawset((Object)"pattern", WolModuleLuaTable.this.getConverters().toLuaNullable(e.getValue().getPattern()));
                entry.rawset((Object)"code", WolModuleLuaTable.this.getConverters().toLua(e.getValue().getCode()));
                table.rawset((long)(++index), (Object)entry);
            }
            ctx.getReturnBuffer().setTo((Object)table);
        }
    }
}

