/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.nbt;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.sandius.rembulan.ByteString;
import net.sandius.rembulan.ConversionException;
import net.sandius.rembulan.Conversions;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.impl.DefaultTable;
import net.wizardsoflua.extension.spell.api.resource.LuaTypes;
import net.wizardsoflua.lua.nbt.NbtByteArrayMerger;
import net.wizardsoflua.lua.nbt.NbtByteMerger;
import net.wizardsoflua.lua.nbt.NbtCompoundMerger;
import net.wizardsoflua.lua.nbt.NbtDoubleMerger;
import net.wizardsoflua.lua.nbt.NbtFloatMerger;
import net.wizardsoflua.lua.nbt.NbtIntArrayMerger;
import net.wizardsoflua.lua.nbt.NbtIntMerger;
import net.wizardsoflua.lua.nbt.NbtListMerger;
import net.wizardsoflua.lua.nbt.NbtLongMerger;
import net.wizardsoflua.lua.nbt.NbtMerger;
import net.wizardsoflua.lua.nbt.NbtShortMerger;
import net.wizardsoflua.lua.nbt.NbtStringMerger;
import net.wizardsoflua.lua.table.TableIterable;
import org.jetbrains.annotations.Nullable;

public class NbtConverter {
    private static final String DEFAULT_PATH = "nbt";
    private final LuaTypes types;
    @Nullable
    private Map<Class<? extends class_2520>, NbtMerger<? extends class_2520>> mergers;

    public NbtConverter(LuaTypes types) {
        this.types = Objects.requireNonNull(types, "types");
    }

    private LuaTypes getTypes() {
        return this.types;
    }

    private Map<Class<? extends class_2520>, NbtMerger<? extends class_2520>> getMergers() {
        if (this.mergers == null) {
            this.mergers = new HashMap<Class<? extends class_2520>, NbtMerger<? extends class_2520>>();
            this.registerMerger(class_2481.class, new NbtByteMerger(this));
            this.registerMerger(class_2487.class, new NbtCompoundMerger(this));
            this.registerMerger(class_2489.class, new NbtDoubleMerger(this));
            this.registerMerger(class_2494.class, new NbtFloatMerger(this));
            this.registerMerger(class_2497.class, new NbtIntMerger(this));
            this.registerMerger(class_2499.class, new NbtListMerger(this));
            this.registerMerger(class_2503.class, new NbtLongMerger(this));
            this.registerMerger(class_2516.class, new NbtShortMerger(this));
            this.registerMerger(class_2519.class, new NbtStringMerger(this));
            this.registerMerger(class_2479.class, new NbtByteArrayMerger(this));
            this.registerMerger(class_2495.class, new NbtIntArrayMerger(this));
        }
        return this.mergers;
    }

    private <NBT extends class_2520> void registerMerger(Class<NBT> cls, NbtMerger<NBT> merger) {
        if (this.getMergers().containsKey(cls)) {
            throw new IllegalArgumentException("Duplicate merger for " + String.valueOf(cls));
        }
        this.getMergers().put(cls, merger);
    }

    private <NBT extends class_2520> NbtMerger<NBT> getMerger(Class<NBT> nbtType) {
        NbtMerger<? extends class_2520> result = this.getMergers().get(nbtType);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"Unsupported NBT type", (Object)nbtType.getSimpleName());
        return result;
    }

    private String keyToString(Object luaKey, int index, String path) {
        ByteString result = Conversions.stringValueOf((Object)luaKey);
        if (result == null) {
            String actualType = this.getTypes().getLuaTypeNameOfLuaObject(luaKey);
            throw new ConversionException("Can't convert key " + index + " in " + path + "! string/number expected, but got " + actualType);
        }
        return result.toString();
    }

    ConversionException conversionException(String path, Object actual, String expected) {
        String actualType = this.getTypes().getLuaTypeNameOfLuaObject(actual);
        return new ConversionException("Can't convert " + path + "! " + expected + " expected, but got " + actualType);
    }

    public class_2487 merge(class_2487 nbt, Table data) {
        return this.merge(nbt, data, DEFAULT_PATH);
    }

    class_2487 merge(class_2487 nbt, Table data, String path) {
        class_2487 result = nbt.method_10553();
        this.insert(result, data, path);
        return result;
    }

    public void insert(class_2487 nbt, Table data) {
        this.insert(nbt, data, DEFAULT_PATH);
    }

    void insert(class_2487 nbt, Table data, String path) {
        int i = 0;
        for (Map.Entry<Object, Object> entry : new TableIterable(data)) {
            String key = this.keyToString(entry.getKey(), ++i, path);
            Object newLuaValue = entry.getValue();
            String entryPath = path + "." + key;
            class_2520 oldNbtValue = nbt.method_10580(key);
            class_2520 newNbtValue = oldNbtValue != null ? this.merge(oldNbtValue, newLuaValue, key, entryPath) : this.toNbt(newLuaValue, entryPath);
            nbt.method_10566(key, newNbtValue);
        }
    }

    <NBT extends class_2520> NBT merge(NBT nbt, Object data, String key, String path) {
        Preconditions.checkNotNull((Object)key, (Object)"key == null!");
        Preconditions.checkNotNull(nbt, (Object)"nbt == null!");
        Preconditions.checkNotNull((Object)data, (Object)"data == null!");
        Class nbtType = nbt.getClass();
        NbtMerger<NBT> converter = this.getMerger(nbtType);
        return converter.merge(nbt, data, key, path);
    }

    public static Object toLua(class_2520 nbt) {
        Preconditions.checkNotNull((Object)nbt, (Object)"nbt == null!");
        if (nbt instanceof class_2514) {
            return NbtConverter.toLua((class_2514)nbt);
        }
        if (nbt instanceof class_2519) {
            return NbtConverter.toLua((class_2519)nbt);
        }
        if (nbt instanceof class_2499) {
            return NbtConverter.toLua((class_2499)nbt);
        }
        if (nbt instanceof class_2487) {
            return NbtConverter.toLua((class_2487)nbt);
        }
        if (nbt instanceof class_2501) {
            return NbtConverter.toLua((class_2501)nbt);
        }
        if (nbt instanceof class_2495) {
            return NbtConverter.toLua((class_2495)nbt);
        }
        if (nbt instanceof class_2479) {
            return NbtConverter.toLua((class_2479)nbt);
        }
        throw new IllegalArgumentException("Unsupported NBT type for conversion: " + nbt.getClass().getName());
    }

    public static Number toLua(class_2514 nbt) {
        Preconditions.checkNotNull((Object)nbt, (Object)"nbt == null!");
        if (nbt instanceof class_2489) {
            return nbt.method_10697();
        }
        if (nbt instanceof class_2494) {
            return nbt.method_10697();
        }
        return nbt.method_10699();
    }

    public static ByteString toLua(class_2519 nbt) {
        Preconditions.checkNotNull((Object)nbt, (Object)"nbt == null!");
        return nbt.method_68658().map(ByteString::of).orElseThrow();
    }

    public static Table toLua(class_2499 nbt) {
        Preconditions.checkNotNull((Object)nbt, (Object)"nbt == null!");
        DefaultTable result = new DefaultTable();
        int luaKey = 1;
        for (class_2520 nbtValue : nbt) {
            Object luaValue = NbtConverter.toLua(nbtValue);
            result.rawset((long)luaKey++, luaValue);
        }
        return result;
    }

    public static Table toLua(class_2487 nbt) {
        Preconditions.checkNotNull((Object)nbt, (Object)"nbt == null!");
        DefaultTable result = new DefaultTable();
        for (String key : nbt.method_10541()) {
            class_2520 nbtValue = nbt.method_10580(key);
            Object luaValue = NbtConverter.toLua(nbtValue);
            result.rawset((Object)key, luaValue);
        }
        return result;
    }

    public static Table toLua(class_2501 nbt) {
        Preconditions.checkNotNull((Object)nbt, (Object)"nbt == null!");
        DefaultTable result = new DefaultTable();
        long[] arr = nbt.method_10615();
        for (int i = 0; i < arr.length; ++i) {
            long key = i + 1;
            Long value = arr[i];
            result.rawset(key, (Object)value);
        }
        return result;
    }

    public static Table toLua(class_2495 nbt) {
        Preconditions.checkNotNull((Object)nbt, (Object)"nbt == null!");
        DefaultTable result = new DefaultTable();
        int[] arr = nbt.method_10588();
        for (int i = 0; i < arr.length; ++i) {
            long key = i + 1;
            Integer value = arr[i];
            result.rawset(key, (Object)value);
        }
        return result;
    }

    public static Table toLua(class_2479 nbt) {
        Preconditions.checkNotNull((Object)nbt, (Object)"nbt == null!");
        DefaultTable result = new DefaultTable();
        byte[] arr = nbt.method_10521();
        for (int i = 0; i < arr.length; ++i) {
            long key = i + 1;
            Byte value = arr[i];
            result.rawset(key, (Object)value);
        }
        return result;
    }

    public class_2520 toNbt(Object data) {
        return this.toNbt(data, DEFAULT_PATH);
    }

    private class_2520 toNbt(Object data, String path) {
        Preconditions.checkNotNull((Object)data, (Object)"data == null!");
        data = this.adjustType(data, path);
        if (data instanceof Boolean) {
            return NbtConverter.toNbt((Boolean)data);
        }
        if (data instanceof Byte) {
            return NbtConverter.toNbt((Byte)data);
        }
        if (data instanceof ByteString) {
            return NbtConverter.toNbt((ByteString)data);
        }
        if (data instanceof Double) {
            return NbtConverter.toNbt((Double)data);
        }
        if (data instanceof Float) {
            return NbtConverter.toNbt((Float)data);
        }
        if (data instanceof Integer) {
            return NbtConverter.toNbt((Integer)data);
        }
        if (data instanceof Long) {
            return NbtConverter.toNbt((Long)data);
        }
        if (data instanceof Short) {
            return NbtConverter.toNbt((Short)data);
        }
        if (data instanceof String) {
            return NbtConverter.toNbt((String)data);
        }
        if (data instanceof Table) {
            return this.toNbt((Table)data, path);
        }
        throw new IllegalArgumentException("Unsupported type for NBT conversion: " + data.getClass().getName());
    }

    private Object adjustType(Object data, String path) {
        switch (path) {
            case "nbt.tag.RepairCost": {
                data = NbtConverter.toIntIfPossible(data);
            }
        }
        return data;
    }

    private static Object toIntIfPossible(Object data) {
        Number number;
        int result;
        if (data instanceof Number && (double)(result = (number = (Number)data).intValue()) == number.doubleValue()) {
            return result;
        }
        return data;
    }

    public static class_2481 toNbt(boolean data) {
        return NbtConverter.toNbt(data ? (byte)1 : 0);
    }

    public static class_2481 toNbt(Boolean data) {
        return NbtConverter.toNbt((boolean)data);
    }

    public static class_2481 toNbt(byte data) {
        return class_2481.method_23233((byte)data);
    }

    public static class_2481 toNbt(Byte data) {
        return NbtConverter.toNbt((byte)data);
    }

    public static class_2519 toNbt(ByteString data) {
        return NbtConverter.toNbt(data.toString());
    }

    public static class_2489 toNbt(double data) {
        return class_2489.method_23241((double)data);
    }

    public static class_2489 toNbt(Double data) {
        return NbtConverter.toNbt((double)data);
    }

    public static class_2494 toNbt(float data) {
        return class_2494.method_23244((float)data);
    }

    public static class_2494 toNbt(Float data) {
        return NbtConverter.toNbt(data.floatValue());
    }

    public static class_2497 toNbt(int data) {
        return class_2497.method_23247((int)data);
    }

    public static class_2497 toNbt(Integer data) {
        return NbtConverter.toNbt((int)data);
    }

    public static class_2503 toNbt(long data) {
        return class_2503.method_23251((long)data);
    }

    public static class_2503 toNbt(Long data) {
        return NbtConverter.toNbt((long)data);
    }

    public static class_2516 toNbt(short data) {
        return class_2516.method_23254((short)data);
    }

    public static class_2516 toNbt(Short data) {
        return NbtConverter.toNbt((short)data);
    }

    public static class_2519 toNbt(String data) {
        return class_2519.method_23256((String)data);
    }

    public class_2520 toNbt(Table data) {
        return this.toNbt(data, DEFAULT_PATH);
    }

    private class_2520 toNbt(Table data, String path) {
        Table table = data;
        if (NbtConverter.isArray(table)) {
            return this.toNbtList(table, path);
        }
        return this.toNbtCompound(table, path);
    }

    public static boolean isArray(Table table) {
        long count = 0L;
        for (Map.Entry<Object, Object> entry : new TableIterable(table)) {
            ++count;
            Object key = entry.getKey();
            Long intValue = Conversions.integerValueOf((Object)key);
            if (intValue == null) {
                return false;
            }
            if (intValue == count) continue;
            return false;
        }
        return count > 0L;
    }

    public class_2499 toNbtList(Table data) {
        return this.toNbtList(data, DEFAULT_PATH);
    }

    class_2499 toNbtList(Table data, String path) {
        class_2499 result = new class_2499();
        int i = 0;
        for (Map.Entry<Object, Object> entry : new TableIterable(data)) {
            Object value = entry.getValue();
            class_2520 nbtValue = this.toNbt(value, path + "[" + ++i + "]");
            result.add((Object)nbtValue);
        }
        return result;
    }

    public class_2487 toNbtCompound(Table data) {
        return this.toNbtCompound(data, DEFAULT_PATH);
    }

    class_2487 toNbtCompound(Table data, String path) {
        class_2487 result = new class_2487();
        int i = 0;
        for (Map.Entry<Object, Object> entry : new TableIterable(data)) {
            String key = this.keyToString(entry.getKey(), ++i, path);
            Object value = entry.getValue();
            class_2520 nbtValue = this.toNbt(value, path + "." + key);
            result.method_10566(key, nbtValue);
        }
        return result;
    }
}

