/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.scheduling;

import com.google.common.base.Preconditions;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashSet;
import java.util.Set;
import net.sandius.rembulan.StateContext;
import net.sandius.rembulan.exec.CallException;
import net.sandius.rembulan.exec.CallPausedException;
import net.sandius.rembulan.exec.Continuation;
import net.sandius.rembulan.exec.DirectCallExecutor;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.IllegalOperationAttemptException;
import net.sandius.rembulan.runtime.LuaFunction;
import net.sandius.rembulan.runtime.SchedulingContextFactory;
import net.sandius.rembulan.runtime.UnresolvedControlThrowable;
import net.wizardsoflua.extension.spell.api.LuaTickListener;
import net.wizardsoflua.extension.spell.api.PauseContext;
import net.wizardsoflua.lua.scheduling.CallFellAsleepException;
import net.wizardsoflua.lua.scheduling.LuaSchedulingContext;
import net.wizardsoflua.lua.scheduling.LuaSchedulingContextFactory;
import net.wizardsoflua.lua.scheduling.PausableSchedulingContextFactory;
import net.wizardsoflua.lua.scheduling.UnpausableSchedulingContextFactory;
import org.jetbrains.annotations.Nullable;

public class LuaScheduler
implements net.wizardsoflua.extension.spell.api.resource.LuaScheduler {
    private final Set<LuaTickListener> tickListeners = new HashSet<LuaTickListener>();
    private final Set<PauseContext> pauseContexts = new HashSet<PauseContext>();
    private final StateContext stateContext;
    private final PausableSchedulingContextFactory.Context context;
    @Nullable
    private LuaSchedulingContext currentSchedulingContext;
    private boolean autosleep = true;

    public LuaScheduler(StateContext stateContext) {
        this.stateContext = (StateContext)Preconditions.checkNotNull((Object)stateContext, (Object)"stateContext == null!");
        this.context = new PausableSchedulingContextFactory.Context(){

            @Override
            public void registerTicks(int ticks) {
                LuaScheduler.this.registerTicks(ticks);
            }

            @Override
            public boolean shouldPause() {
                return LuaScheduler.this.shouldPause();
            }

            @Override
            public void setAutosleep(boolean autosleep) {
                LuaScheduler.this.autosleep = autosleep;
            }

            @Override
            public boolean isAutosleep() {
                return LuaScheduler.this.autosleep;
            }
        };
    }

    private void registerTicks(int ticks) {
        for (LuaTickListener tickListener : this.tickListeners) {
            tickListener.registerTicks(ticks);
        }
    }

    private boolean shouldPause() {
        for (PauseContext context : this.pauseContexts) {
            if (!context.shouldPause()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addTickListener(LuaTickListener tickListener) {
        return this.tickListeners.add(tickListener);
    }

    @Override
    public boolean removeTickListener(LuaTickListener tickListener) {
        return this.tickListeners.remove(tickListener);
    }

    @Override
    public boolean addPauseContext(PauseContext pauseContext) {
        return this.pauseContexts.add(pauseContext);
    }

    @Override
    public boolean removePauseContext(PauseContext pauseContext) {
        return this.pauseContexts.remove(pauseContext);
    }

    @Override
    public Object[] call(long luaTickLimit, LuaFunction function, Object ... args) throws CallException, CallPausedException, InterruptedException {
        return this.callPausable(luaTickLimit, executor -> executor.call(this.stateContext, (Object)function, args));
    }

    @Override
    public Object[] callUnpausable(long luaTickLimit, LuaFunction function, Object ... args) throws CallException, InterruptedException {
        return this.callUnpausable(luaTickLimit, executor -> executor.call(this.stateContext, (Object)function, args));
    }

    @Override
    public Object[] resume(long luaTickLimit, Continuation continuation) throws CallException, CallPausedException, InterruptedException {
        return this.callPausable(luaTickLimit, executor -> executor.resume(continuation));
    }

    @Override
    public Object[] resumeUnpausable(long luaTickLimit, Continuation continuation) throws CallException, InterruptedException {
        return this.callUnpausable(luaTickLimit, executor -> executor.resume(continuation));
    }

    private Object[] callPausable(long luaTickLimit, LuaCallable callable) throws CallException, CallPausedException, InterruptedException {
        DirectCallExecutor executor = DirectCallExecutor.newExecutor((SchedulingContextFactory)this.wrap(new PausableSchedulingContextFactory(luaTickLimit, this.context)));
        return this.call(executor, callable);
    }

    private Object[] callUnpausable(long luaTickLimit, LuaCallable callable) throws CallException, InterruptedException {
        DirectCallExecutor executor = DirectCallExecutor.newExecutor((SchedulingContextFactory)this.wrap(new UnpausableSchedulingContextFactory(luaTickLimit, this::registerTicks)));
        try {
            return this.call(executor, callable);
        }
        catch (CallPausedException ex) {
            ex.printStackTrace();
            throw new UndeclaredThrowableException(ex);
        }
    }

    private Object[] call(DirectCallExecutor executor, LuaCallable callable) throws CallException, CallPausedException, InterruptedException, CallFellAsleepException {
        LuaSchedulingContext previousSchedulingContext = this.currentSchedulingContext;
        try {
            Object[] objectArray = callable.call(executor);
            return objectArray;
        }
        catch (CallPausedException ex) {
            int sleepDuration = this.currentSchedulingContext.getSleepDuration();
            if (sleepDuration > 0) {
                throw new CallFellAsleepException(sleepDuration, ex.getContinuation());
            }
            throw ex;
        }
        finally {
            this.currentSchedulingContext = previousSchedulingContext;
        }
    }

    private LuaSchedulingContextFactory wrap(final LuaSchedulingContextFactory delegate) {
        return new LuaSchedulingContextFactory(){

            @Override
            public LuaSchedulingContext newInstance() {
                LuaScheduler.this.currentSchedulingContext = delegate.newInstance();
                return LuaScheduler.this.currentSchedulingContext;
            }
        };
    }

    @Nullable
    public LuaSchedulingContext getCurrentSchedulingContext() {
        return this.currentSchedulingContext;
    }

    private LuaSchedulingContext getCurrentSchedulingContextNonNull() {
        Preconditions.checkState((this.currentSchedulingContext != null ? 1 : 0) != 0, (Object)"This method can only be called through Lua");
        return this.currentSchedulingContext;
    }

    @Override
    public void pause(ExecutionContext context) throws UnresolvedControlThrowable, IllegalOperationAttemptException {
        this.getCurrentSchedulingContextNonNull().pause(context);
    }

    @Override
    public void pauseIfRequested(ExecutionContext context) throws UnresolvedControlThrowable, IllegalOperationAttemptException {
        this.getCurrentSchedulingContextNonNull().pauseIfRequested(context);
    }

    @Override
    public void sleep(ExecutionContext context, int ticks) throws UnresolvedControlThrowable {
        if (ticks > 0) {
            LuaSchedulingContext schedulingContext = this.getCurrentSchedulingContextNonNull();
            schedulingContext.setSleepDuration(ticks);
            schedulingContext.pause(context);
        }
    }

    @Override
    public long getAllowance() {
        return this.getCurrentSchedulingContextNonNull().getAllowance();
    }

    @Override
    public boolean isAutosleep() {
        return this.getCurrentSchedulingContextNonNull().isAutosleep();
    }

    @Override
    public void setAutosleep(boolean autosleep) {
        this.getCurrentSchedulingContextNonNull().setAutosleep(autosleep);
    }

    private static interface LuaCallable {
        public Object[] call(DirectCallExecutor var1) throws CallException, CallPausedException, InterruptedException;
    }
}

