/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.scheduling;

import com.google.common.base.Preconditions;
import net.sandius.rembulan.LuaRuntimeException;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.IllegalOperationAttemptException;
import net.sandius.rembulan.runtime.SchedulingContext;
import net.sandius.rembulan.runtime.UnresolvedControlThrowable;

public abstract class LuaSchedulingContext
implements SchedulingContext {
    private final Context context;
    private long allowance;
    private int sleepDuration;

    public LuaSchedulingContext(long luaTickLimit, Context context) {
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context == null!");
        this.allowance = luaTickLimit;
    }

    public void registerTicks(int ticks) {
        this.allowance -= (long)ticks;
        this.context.registerTicks(ticks);
    }

    public boolean shouldPause() {
        if (this.allowance <= 0L) {
            if (this.isAutosleep()) {
                return true;
            }
            throw new LuaRuntimeException((Object)"Spell has been terminated automatically since it has exceeded its tick allowance!");
        }
        return false;
    }

    public long getAllowance() {
        return this.allowance;
    }

    public int getSleepDuration() {
        return this.sleepDuration;
    }

    public void setSleepDuration(int sleepDuration) {
        Preconditions.checkArgument((sleepDuration >= 0 ? 1 : 0) != 0, (Object)"Can't sleep a negative amount of time");
        this.sleepDuration = sleepDuration;
    }

    public abstract boolean isAutosleep();

    public abstract void setAutosleep(boolean var1) throws IllegalOperationAttemptException;

    public abstract void pause(ExecutionContext var1) throws UnresolvedControlThrowable, IllegalOperationAttemptException;

    public abstract void pauseIfRequested(ExecutionContext var1) throws UnresolvedControlThrowable, IllegalOperationAttemptException;

    public static interface Context {
        public void registerTicks(int var1);
    }
}

