/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.startup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class StartupModuleFinder {
    public List<String> findStartupModulesIn(Path dir) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        List<Path> startupFiles = this.findFiles(dir, "startup.lua");
        for (Path startupFile : startupFiles) {
            if (!Files.exists(startupFile, new LinkOption[0])) continue;
            String module = this.toModule(dir, startupFile);
            result.add(module);
        }
        return result;
    }

    private List<Path> findFiles(Path dir, String name) throws IOException {
        ArrayList<Path> dirs = new ArrayList<Path>();
        dirs.add(dir);
        return this.findFiles(name, dirs, new ArrayList<Path>());
    }

    private List<Path> findFiles(String name, List<Path> dirs, List<Path> result) throws IOException {
        if (!dirs.isEmpty()) {
            ArrayList<Path> nextDirs = new ArrayList<Path>();
            for (Path dir : dirs) {
                for (Path p : Files.list(dir).collect(Collectors.toList())) {
                    if (Files.isDirectory(p, new LinkOption[0])) {
                        nextDirs.add(p);
                        continue;
                    }
                    if (!p.getFileName().toString().equals(name)) continue;
                    result.add(p);
                }
            }
            this.findFiles(name, nextDirs, result);
        }
        return result;
    }

    private String toModule(Path dir, Path modulePath) {
        Path relativeModulePath = dir.relativize(modulePath);
        if (relativeModulePath.getFileName().toString().endsWith(".lua")) {
            String result = relativeModulePath.toString();
            result = result.substring(0, result.length() - 4);
            result = result.replace(dir.getFileSystem().getSeparator(), ".");
            return result;
        }
        throw new IllegalArgumentException(String.format("Missing '.lua' extension on file %s", relativeModulePath));
    }
}

