/*
 * Decompiled with CFR 0.152.
 */
package shadow.hypherionmc.mcdiscordformatter.minecraft;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import shadow.hypherionmc.mcdiscordformatter.minecraft.MinecraftSerializerOptions;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.Node;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.TextNode;
import shadow.hypherionmc.mcdiscordformatter.renderer.NodeRenderer;
import shadow.hypherionmc.mcdiscordformatter.renderer.implementation.DefaultDiscordEscapingRenderer;
import shadow.hypherionmc.mcdiscordformatter.renderer.implementation.DefaultMinecraftRenderer;

public class MinecraftSerializer {
    public static final MinecraftSerializer INSTANCE = new MinecraftSerializer(){

        @Override
        public void setDefaultOptions(MinecraftSerializerOptions<class_5250> defaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        public void setMarkdownDefaultOptions(MinecraftSerializerOptions<String> markdownDefaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }
    };
    private MinecraftSerializerOptions<class_5250> defaultOptions;
    private MinecraftSerializerOptions<String> markdownDefaultOptions;

    public MinecraftSerializer() {
        this(MinecraftSerializerOptions.defaults(), MinecraftSerializerOptions.escapeDefaults());
    }

    public MinecraftSerializer(@NotNull MinecraftSerializerOptions<class_5250> defaultOptions, @NotNull MinecraftSerializerOptions<String> markdownDefaultOptions) {
        this.defaultOptions = defaultOptions;
        this.markdownDefaultOptions = markdownDefaultOptions;
    }

    public class_5250 serialize(@NotNull String discordMessage) {
        MinecraftSerializerOptions<class_5250> options = this.getDefaultOptions();
        return this.serialize(discordMessage, options);
    }

    public class_5250 serialize(@NotNull String discordMessage, @NotNull MinecraftSerializerOptions<class_5250> serializerOptions) {
        ArrayList<class_5250> components = new ArrayList<class_5250>();
        List<Node<Object>> nodes = serializerOptions.getParser().parse(discordMessage, null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled());
        nodes = this.flattenTextNodes(nodes);
        for (Node<Object> node : nodes) {
            components.add(this.addChild(node, class_2561.method_43473(), serializerOptions));
        }
        class_5250 text = class_2561.method_43473();
        components.forEach(arg_0 -> ((class_5250)text).method_10852(arg_0));
        return text;
    }

    public String escapeMarkdown(@NotNull String discordMessage) {
        return this.escapeMarkdown(discordMessage, this.getMarkdownDefaultOptions());
    }

    public String escapeMarkdown(@NotNull String discordMessage, @NotNull MinecraftSerializerOptions<String> serializerOptions) {
        String output = "";
        List<Node<Object>> nodes = serializerOptions.getParser().parse(discordMessage, null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled());
        nodes = this.flattenTextNodes(nodes);
        for (Node<Object> node : nodes) {
            output = this.addChild(node, output, serializerOptions);
        }
        return output;
    }

    private class_5250 addChild(Node<Object> node, class_5250 styleNode, MinecraftSerializerOptions<class_5250> serializerOptions) {
        class_5250 newOutput;
        List<Node<Object>> children;
        class_5250 component = class_2561.method_43473().method_10862(styleNode.method_10866());
        Function<Node, class_5250> renderWithChildren = otherNode -> this.addChild((Node<Object>)otherNode, component, serializerOptions);
        class_5250 output = null;
        Object render = null;
        for (NodeRenderer<class_5250> renderer : serializerOptions.getRenderers()) {
            output = renderer.render(component, node, serializerOptions, renderWithChildren);
            if (output == null) continue;
            render = renderer;
            break;
        }
        if (output == null) {
            render = DefaultMinecraftRenderer.INSTANCE;
            output = render.render(component, node, serializerOptions, renderWithChildren);
        }
        if ((children = node.getChildren()) != null) {
            for (Node node2 : children) {
                output = output.method_10852((class_2561)this.addChild((Node<Object>)node2, output, serializerOptions));
            }
        }
        if ((newOutput = render.renderAfterChildren(output, node, serializerOptions, renderWithChildren)) != null) {
            output = newOutput;
        }
        return output;
    }

    private String addChild(Node<Object> node, String input, MinecraftSerializerOptions<String> serializerOptions) {
        String newOutput;
        List<Node<Object>> children;
        Function<Node, String> renderWithChildren = otherNode -> this.addChild((Node<Object>)otherNode, input, serializerOptions);
        String output = null;
        Object render = null;
        for (NodeRenderer<String> renderer : serializerOptions.getRenderers()) {
            output = renderer.render(output, node, serializerOptions, renderWithChildren);
            if (output == null) continue;
            render = renderer;
            break;
        }
        if (output == null) {
            render = DefaultDiscordEscapingRenderer.INSTANCE;
            output = render.render(input, node, serializerOptions, renderWithChildren);
        }
        if ((children = node.getChildren()) != null) {
            for (Node node2 : children) {
                output = this.addChild((Node<Object>)node2, output, serializerOptions);
            }
        }
        if ((newOutput = render.renderAfterChildren(output, node, serializerOptions, renderWithChildren)) != null) {
            output = newOutput;
        }
        return output;
    }

    private <R, T extends Node<R>> List<T> flattenTextNodes(List<T> nodes) {
        ArrayList<Node> newNodes = new ArrayList<Node>();
        TextNode previousNode = null;
        for (Node node : nodes) {
            List children = node.getChildren();
            if (!children.isEmpty()) {
                if (previousNode != null) {
                    newNodes.add(previousNode);
                    previousNode = null;
                }
                List childNodes = this.flattenTextNodes(children);
                node.getChildren().clear();
                node.getChildren().addAll(childNodes);
                newNodes.add(node);
                continue;
            }
            if (!(node instanceof TextNode)) {
                if (previousNode != null) {
                    newNodes.add(previousNode);
                    previousNode = null;
                }
                newNodes.add(node);
                continue;
            }
            if (previousNode == null) {
                previousNode = (TextNode)node;
                continue;
            }
            previousNode = new TextNode(previousNode.getContent() + ((TextNode)node).getContent());
        }
        if (previousNode != null) {
            newNodes.add(previousNode);
        }
        return newNodes;
    }

    public MinecraftSerializerOptions<class_5250> getDefaultOptions() {
        return this.defaultOptions;
    }

    public MinecraftSerializerOptions<String> getMarkdownDefaultOptions() {
        return this.markdownDefaultOptions;
    }

    public void setDefaultOptions(MinecraftSerializerOptions<class_5250> defaultOptions) {
        this.defaultOptions = defaultOptions;
    }

    public void setMarkdownDefaultOptions(MinecraftSerializerOptions<String> markdownDefaultOptions) {
        this.markdownDefaultOptions = markdownDefaultOptions;
    }
}

