/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.magnet;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetWidget;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class MagnetUpgrade
extends FilterUpgradeBase<MagnetUpgrade, MagnetFilterSettings>
implements IEnable,
ITickableUpgrade {
    public MagnetUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, new Point(66, 49), TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.filterSlotCount, TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.slotsInRow, filter, filterTags);
    }

    @Override
    public MagnetFilterSettings createFilterSettings(UpgradeManager manager, class_2371<class_1799> filter, List<String> filterTags) {
        return new MagnetFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(this.getFilterSlotCount()).filter(stack -> !stack.method_7960()).toList(), this.getFilter(), filterTags);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new MagnetWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public int getTickRate() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.tickRate;
    }

    @Override
    public void tick(@Nullable class_1657 player, class_1937 level, class_2338 pos, int currentTick) {
        if (this.getCooldown() == 0) {
            return;
        }
        if (currentTick % this.getCooldown() != 0) {
            return;
        }
        this.teleportNearbyItems(player, level);
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    public void teleportNearbyItems(class_1657 player, class_1937 level) {
        if (level.method_8608()) {
            return;
        }
        int radius = TravelersBackpackConfig.getConfig().backpackUpgrades.magnetUpgradeSettings.pullRange;
        class_238 area = new class_238(player.method_73189().method_1031((double)(-radius), (double)(-radius), (double)(-radius)), player.method_73189().method_1031((double)radius, (double)radius, (double)radius));
        List items = level.method_18023((class_5575)class_1299.field_6052, area, item -> !(!item.method_5805() || level.method_8608() && item.field_6012 <= 1 || item.method_24921() != null && item.method_24921().equals((Object)player) && item.field_6012 <= 80 || item.method_6983().method_7960() || !((MagnetFilterSettings)this.getFilterSettings()).matchesFilter(player, item.method_6983())));
        items.forEach(item -> {
            item.method_5814(player.method_23317(), player.method_23318(), player.method_23321());
            item.method_6975();
        });
    }

    @Override
    protected FilterHandler createFilter(class_2371<class_1799> stacks, final int size) {
        return new FilterHandler(stacks, size){

            @Override
            protected void onContentsChanged(int slot) {
                MagnetUpgrade.this.updateDataHolderUnchecked(ModDataComponents.BACKPACK_CONTAINER, InventoryHelper.itemsToList(size, MagnetUpgrade.this.filter));
                ((MagnetFilterSettings)MagnetUpgrade.this.getFilterSettings()).updateFilter((List<class_1799>)((BackpackContainerContents)MagnetUpgrade.this.getDataHolderStack().method_58694(ModDataComponents.BACKPACK_CONTAINER)).getItems());
                ((MagnetFilterSettings)MagnetUpgrade.this.getFilterSettings()).updateFilterTags((List)MagnetUpgrade.this.getDataHolderStack().method_58694(ModDataComponents.FILTER_TAGS));
                MagnetUpgrade.this.changeListeners.forEach(Runnable::run);
            }
        };
    }
}

