/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.impl;

import com.google.common.collect.ImmutableSet;
import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionEventListener;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.StateManager;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ActionController;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ButtonOptionImpl
implements ButtonOption {
    private final class_2561 name;
    private final OptionDescription description;
    private final StateManager<BiConsumer<YACLScreen, ButtonOption>> stateManager;
    private boolean available;
    private final Controller<BiConsumer<YACLScreen, ButtonOption>> controller;

    public ButtonOptionImpl(@NotNull class_2561 name, @Nullable OptionDescription description, @NotNull BiConsumer<YACLScreen, ButtonOption> action, @Nullable class_2561 text, boolean available) {
        this.name = name;
        this.description = description;
        this.stateManager = StateManager.createImmutable(action);
        this.available = available;
        this.controller = text != null ? new ActionController(this, text) : new ActionController(this);
    }

    @Override
    @NotNull
    public class_2561 name() {
        return this.name;
    }

    @Override
    @NotNull
    public OptionDescription description() {
        return this.description;
    }

    @Override
    @NotNull
    public class_2561 tooltip() {
        return this.description().text();
    }

    @Override
    public BiConsumer<YACLScreen, ButtonOption> action() {
        return this.stateManager().get();
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    @NotNull
    public Controller<BiConsumer<YACLScreen, ButtonOption>> controller() {
        return this.controller;
    }

    @Override
    @NotNull
    public StateManager<BiConsumer<YACLScreen, ButtonOption>> stateManager() {
        return this.stateManager;
    }

    @Override
    @NotNull
    public Binding<BiConsumer<YACLScreen, ButtonOption>> binding() {
        return new EmptyBinderImpl();
    }

    @Override
    @NotNull
    public ImmutableSet<OptionFlag> flags() {
        return ImmutableSet.of();
    }

    @Override
    public boolean changed() {
        return false;
    }

    @Override
    @NotNull
    public BiConsumer<YACLScreen, ButtonOption> pendingValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void requestSet(@NotNull BiConsumer<YACLScreen, ButtonOption> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean applyValue() {
        return false;
    }

    @Override
    public void forgetPendingValue() {
    }

    @Override
    public void requestSetDefault() {
    }

    @Override
    public boolean isPendingValueDefault() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addEventListener(OptionEventListener<BiConsumer<YACLScreen, ButtonOption>> listener) {
    }

    @Override
    public void addListener(BiConsumer<Option<BiConsumer<YACLScreen, ButtonOption>>, BiConsumer<YACLScreen, ButtonOption>> changedListener) {
    }

    private static class EmptyBinderImpl
    implements Binding<BiConsumer<YACLScreen, ButtonOption>> {
        private EmptyBinderImpl() {
        }

        @Override
        public void setValue(BiConsumer<YACLScreen, ButtonOption> value) {
        }

        @Override
        public BiConsumer<YACLScreen, ButtonOption> getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BiConsumer<YACLScreen, ButtonOption> defaultValue() {
            throw new UnsupportedOperationException();
        }
    }

    @ApiStatus.Internal
    public static final class BuilderImpl
    implements ButtonOption.Builder {
        private class_2561 name;
        private class_2561 text = null;
        private OptionDescription description = OptionDescription.EMPTY;
        private boolean available = true;
        private BiConsumer<YACLScreen, ButtonOption> action;

        @Override
        public ButtonOption.Builder name(@NotNull class_2561 name) {
            Validate.notNull((Object)name, (String)"`name` cannot be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        @Override
        public ButtonOption.Builder text(@NotNull class_2561 text) {
            Validate.notNull((Object)text, (String)"`text` cannot be null", (Object[])new Object[0]);
            this.text = text;
            return this;
        }

        @Override
        public ButtonOption.Builder description(@NotNull OptionDescription description) {
            Validate.notNull((Object)description, (String)"`description` cannot be null", (Object[])new Object[0]);
            this.description = description;
            return this;
        }

        @Override
        public ButtonOption.Builder action(@NotNull BiConsumer<YACLScreen, ButtonOption> action) {
            Validate.notNull(action, (String)"`action` cannot be null", (Object[])new Object[0]);
            this.action = action;
            return this;
        }

        @Override
        @Deprecated
        public ButtonOption.Builder action(@NotNull Consumer<YACLScreen> action) {
            Validate.notNull(action, (String)"`action` cannot be null", (Object[])new Object[0]);
            this.action = (screen, button) -> action.accept((YACLScreen)((Object)screen));
            return this;
        }

        @Override
        public ButtonOption.Builder available(boolean available) {
            this.available = available;
            return this;
        }

        @Override
        public ButtonOption build() {
            Validate.notNull((Object)this.name, (String)"`name` must not be null when building `ButtonOption`", (Object[])new Object[0]);
            Validate.notNull(this.action, (String)"`action` must not be null when building `ButtonOption`", (Object[])new Object[0]);
            return new ButtonOptionImpl(this.name, this.description, this.action, this.text, this.available);
        }
    }
}

