/*
 * Decompiled with CFR 0.152.
 */
package de.miraculixx.veinminer.networking;

import de.miraculixx.veinminer.VeinMinerEvent;
import de.miraculixx.veinminer.Veinminer;
import de.miraculixx.veinminer.config.ConfigManager;
import de.miraculixx.veinminer.config.data.BlockPosition;
import de.miraculixx.veinminer.config.data.VeinminerSettings;
import de.miraculixx.veinminer.config.network.BlockHighlighting;
import de.miraculixx.veinminer.config.network.JoinInformation;
import de.miraculixx.veinminer.config.network.KeyPress;
import de.miraculixx.veinminer.config.network.RequestBlockVein;
import de.miraculixx.veinminer.config.network.ServerConfiguration;
import de.miraculixx.veinminer.config.utils.GlobalsKt;
import de.miraculixx.veinminer.networking.PacketsKt;
import de.miraculixx.veinminer.utils.NMSConversionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import net.silkmc.silk.core.Silk;
import net.silkmc.silk.network.packet.ServerPacketContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000e\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ+\u0010\u0011\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00102\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ3\u0010#\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b(\u0010)R#\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001e0*8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u001d\u00100\u001a\b\u0012\u0004\u0012\u00020\b0/8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00104R\u0014\u0010\u000e\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u00104R\u0014\u0010\u0011\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u00104\u00a8\u00065"}, d2={"Lde/miraculixx/veinminer/networking/FabricNetworking;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "Lde/miraculixx/veinminer/config/network/JoinInformation;", "packet", "Ljava/util/UUID;", "uuid", "", "onJoin", "(Lnet/minecraft/class_3222;Lde/miraculixx/veinminer/config/network/JoinInformation;Ljava/util/UUID;)V", "Lde/miraculixx/veinminer/config/network/KeyPress;", "onPress", "(Ljava/util/UUID;Lde/miraculixx/veinminer/config/network/KeyPress;)V", "Lde/miraculixx/veinminer/config/network/RequestBlockVein;", "onMine", "(Lnet/minecraft/class_3222;Lde/miraculixx/veinminer/config/network/RequestBlockVein;Ljava/util/UUID;)V", "Lnet/minecraft/class_3244;", "Lnet/minecraft/server/MinecraftServer;", "server", "onDisconnect", "(Lnet/minecraft/class_3244;Lnet/minecraft/server/MinecraftServer;)V", "Lde/miraculixx/veinminer/config/data/VeinminerSettings;", "settings", "sendConfiguration", "(Lnet/minecraft/class_3222;Lde/miraculixx/veinminer/config/data/VeinminerSettings;)V", "", "allowed", "", "icon", "", "Lde/miraculixx/veinminer/config/data/BlockPosition;", "blocks", "sendHighlighting", "(Lnet/minecraft/class_3222;ZLjava/lang/String;Ljava/util/List;)V", "type", "invalidUserInformation", "(Ljava/lang/String;)V", "userNotConnected", "(Ljava/util/UUID;)V", "", "registeredPlayers", "Ljava/util/Map;", "getRegisteredPlayers", "()Ljava/util/Map;", "", "readyToVeinmine", "Ljava/util/Set;", "getReadyToVeinmine", "()Ljava/util/Set;", "Lkotlin/Unit;", "veinminer-fabric"})
@SourceDebugExtension(value={"SMAP\nFabricNetworking.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FabricNetworking.kt\nde/miraculixx/veinminer/networking/FabricNetworking\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1563#2:115\n1634#2,3:116\n*S KotlinDebug\n*F\n+ 1 FabricNetworking.kt\nde/miraculixx/veinminer/networking/FabricNetworking\n*L\n77#1:115\n77#1:116,3\n*E\n"})
public final class FabricNetworking {
    @NotNull
    public static final FabricNetworking INSTANCE = new FabricNetworking();
    @NotNull
    private static final Map<UUID, String> registeredPlayers = new LinkedHashMap();
    @NotNull
    private static final Set<UUID> readyToVeinmine = new LinkedHashSet();
    @NotNull
    private static final Unit onJoin;
    @NotNull
    private static final Unit onPress;
    @NotNull
    private static final Unit onMine;

    private FabricNetworking() {
    }

    @NotNull
    public final Map<UUID, String> getRegisteredPlayers() {
        return registeredPlayers;
    }

    @NotNull
    public final Set<UUID> getReadyToVeinmine() {
        return readyToVeinmine;
    }

    public final void onJoin(@Nullable class_3222 player, @NotNull JoinInformation packet, @Nullable UUID uuid) {
        MinecraftServer minecraftServer;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Object object = player;
        if ((object == null || (object = object.method_5667()) == null) && (object = uuid) == null) {
            this.invalidUserInformation("join");
            return;
        }
        Object uuid2 = object;
        class_3222 class_32222 = player;
        if (class_32222 == null && ((minecraftServer = Silk.INSTANCE.getServer()) != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602((UUID)uuid2) : (class_32222 = null)) == null) {
            this.invalidUserInformation("join player");
            return;
        }
        class_3222 player2 = class_32222;
        VeinminerSettings settings = ConfigManager.INSTANCE.getSettings();
        if (!settings.getClient().getAllow()) {
            return;
        }
        Veinminer.Companion.getLOGGER().info(player2.method_5820() + " joined with Veinminer version " + packet.getVeinminerClientVersion());
        registeredPlayers.put((UUID)uuid2, packet.getVeinminerClientVersion());
        this.sendConfiguration(player2, settings);
    }

    public static /* synthetic */ void onJoin$default(FabricNetworking fabricNetworking, class_3222 class_32222, JoinInformation joinInformation, UUID uUID, int n, Object object) {
        if ((n & 4) != 0) {
            uUID = null;
        }
        fabricNetworking.onJoin(class_32222, joinInformation, uUID);
    }

    public final void onPress(@Nullable UUID uuid, @NotNull KeyPress packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (uuid == null) {
            this.invalidUserInformation("key press");
            return;
        }
        if (GlobalsKt.getDebug()) {
            Veinminer.Companion.getLOGGER().info(uuid + " pressed hotkey (" + packet.getPressed() + ")");
        }
        boolean bl = packet.getPressed() ? readyToVeinmine.add(uuid) : readyToVeinmine.remove(uuid);
    }

    /*
     * WARNING - void declaration
     */
    public final void onMine(@Nullable class_3222 player, @NotNull RequestBlockVein packet, @Nullable UUID uuid) {
        void $this$mapTo$iv$iv;
        MinecraftServer minecraftServer;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Object object = player;
        if ((object == null || (object = object.method_5667()) == null) && (object = uuid) == null) {
            this.invalidUserInformation("mine");
            return;
        }
        Object uuid2 = object;
        class_3222 class_32222 = player;
        if (class_32222 == null && ((minecraftServer = Silk.INSTANCE.getServer()) != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602((UUID)uuid2) : (class_32222 = null)) == null) {
            this.invalidUserInformation("mine player");
            return;
        }
        class_3222 player2 = class_32222;
        if (GlobalsKt.getDebug()) {
            Veinminer.Companion.getLOGGER().info((UUID)uuid2 + " requested to veinmine block at " + packet.getBlockPosition());
        }
        class_3218 level = player2.method_51469();
        class_2338 position = NMSConversionKt.toNMS(packet.getBlockPosition());
        class_2680 state = level.method_8320(position);
        Intrinsics.checkNotNull((Object)level);
        class_1937 class_19372 = (class_1937)level;
        class_1657 class_16572 = (class_1657)player2;
        Intrinsics.checkNotNull((Object)state);
        VeinMinerEvent.VeinmineAction veinminerAction = VeinMinerEvent.INSTANCE.allowedToVeinmine(class_19372, class_16572, position, state);
        if (veinminerAction == null) {
            this.sendHighlighting(player2, false, "", CollectionsKt.emptyList());
            return;
        }
        VeinMinerEvent.INSTANCE.veinmine(VeinMinerEvent.VeinmineAction.copy$default(veinminerAction, null, null, null, null, null, null, null, null, VeinminerSettings.copy$default((VeinminerSettings)veinminerAction.getSettings(), (int)0, (boolean)false, (int)0, (int)0, (boolean)false, (int)0, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (int)2043, null), 255, null), false);
        Iterable $this$map$iv = veinminerAction.getProcessedBlocks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            class_2338 class_23382 = (class_2338)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NMSConversionKt.toVeinminer((class_2338)it));
        }
        List blocks = (List)destination$iv$iv;
        this.sendHighlighting(player2, true, VeinMinerEvent.INSTANCE.getPreferredToolIcon(state), blocks);
    }

    public static /* synthetic */ void onMine$default(FabricNetworking fabricNetworking, class_3222 class_32222, RequestBlockVein requestBlockVein, UUID uUID, int n, Object object) {
        if ((n & 4) != 0) {
            uUID = null;
        }
        fabricNetworking.onMine(class_32222, requestBlockVein, uUID);
    }

    public final void onDisconnect(@NotNull class_3244 packet, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        UUID uuid = packet.field_14140.method_5667();
        String removed = registeredPlayers.remove(uuid);
        readyToVeinmine.remove(uuid);
        if (GlobalsKt.getDebug() && removed != null) {
            Veinminer.Companion.getLOGGER().info("Removed " + packet.field_14140.method_5820() + " from registered players");
        }
    }

    public final void sendConfiguration(@NotNull class_3222 player, @NotNull VeinminerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (!registeredPlayers.containsKey(player.method_5667())) {
            return;
        }
        ServerConfiguration conf = new ServerConfiguration(settings.getCooldown(), settings.getMustSneak(), false, settings.getClient().getTranslucentBlockHighlight());
        PacketsKt.getPACKET_CONFIGURATION().send((Object)conf, player);
    }

    public final void sendHighlighting(@NotNull class_3222 player, boolean allowed, @NotNull String icon, @NotNull List<BlockPosition> blocks) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        if (!registeredPlayers.containsKey(player.method_5667())) {
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            this.userNotConnected(uUID);
            return;
        }
        PacketsKt.getPACKET_HIGHLIGHT().send((Object)new BlockHighlighting(allowed, icon, blocks), player);
    }

    private final void invalidUserInformation(String type) {
        Veinminer.Companion.getLOGGER().warn("Not enough information to handle '" + type + "' packet!");
    }

    private final void userNotConnected(UUID uuid) {
        Veinminer.Companion.getLOGGER().warn("Can not send packet to client " + uuid + " (not connected)");
    }

    static {
        PacketsKt.getPACKET_JOIN().receiveOnServer((Function3)new Function3<JoinInformation, ServerPacketContext, Continuation<? super Unit>, Object>(null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        JoinInformation packet = (JoinInformation)this.L$0;
                        ServerPacketContext context = (ServerPacketContext)this.L$1;
                        FabricNetworking.onJoin$default(FabricNetworking.INSTANCE, context.getPlayer(), packet, null, 4, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(JoinInformation p1, ServerPacketContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        });
        onJoin = Unit.INSTANCE;
        PacketsKt.getPACKET_KEY_PRESS().receiveOnServer((Function3)new Function3<KeyPress, ServerPacketContext, Continuation<? super Unit>, Object>(null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        KeyPress packet = (KeyPress)this.L$0;
                        ServerPacketContext context = (ServerPacketContext)this.L$1;
                        FabricNetworking.INSTANCE.onPress(context.getPlayer().method_5667(), packet);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(KeyPress p1, ServerPacketContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        });
        onPress = Unit.INSTANCE;
        PacketsKt.getPACKET_MINE().receiveOnServer((Function3)new Function3<RequestBlockVein, ServerPacketContext, Continuation<? super Unit>, Object>(null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        RequestBlockVein packet = (RequestBlockVein)this.L$0;
                        ServerPacketContext context = (ServerPacketContext)this.L$1;
                        FabricNetworking.onMine$default(FabricNetworking.INSTANCE, context.getPlayer(), packet, null, 4, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(RequestBlockVein p1, ServerPacketContext p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        });
        onMine = Unit.INSTANCE;
    }
}

